function [p, x, y, N] = tprender(B, nr)
% [p, x, y, N] = tprender(B, nr)
% TPRENDER -- Subdivide a TP spline function B and return points P,
% corresponding Greville abscissae X and Y, and normals N. Abscissae and
% normals are only computed if the corresponding output arguments are given.
%
% See TPSPLIT for an explanation of the parameter NR which selects the
% number of subdivisions performed to compute P.
%
% The returned values P are the control points of the NR times subdivided
% patch B with the duplicate coefficients of abutting patches removed.

% Created by lutter on Wed Sep 29 16:46:47 1999

sps = tpsplit(B, nr, 'global');

%
% Collect the points into p
%
p = zeros(nr+1);
for i=1:nr(1)
  for j=1:nr(2)
    p(i,j) = sps{i,j}.coefs(1,1,1);
  end
end
j = nr(2);
for i=1:nr(1)
  p(i,j+1) = sps{i,j}.coefs(1, 1, end);
end
i = nr(1);
for j=1:nr(2)
  p(i+1, j) = sps{i, j}.coefs(1, end, 1);
end
j = nr(2);
p(i+1,j+1) = sps{i, j}.coefs(1, end, end);

%
% Compute Greville abscissae
%
if nargout > 1
  x = zeros(1, nr(1)+1);
  y = zeros(1, nr(2)+1);
  for i=1:nr(1)
    grev = aveknt(sps{i,1}.knots{1}, sps{i,1}.order(1));
    x(i) = grev(1);
  end
  x(end) = grev(end);
  for j=1:nr(2)
    grev = aveknt(sps{1,j}.knots{2}, sps{1,j}.order(2));
    y(j) = grev(1);
  end
  y(end) = grev(end);
end


%
% Compute normals
%
if nargout > 3
  N = zeros([3 nr+1]);
  dx = [1/(sps{1,1}.order(1)-1) 0];
  dy = [0 1/(sps{1,1}.order(2)-1)];
  for i=1:nr(1)
    for j=1:nr(2)
      N(:,i,j) = normal(sps{i,j}.coefs(1,1,1), ...
			sps{i,j}.coefs(1,2,1), ... 
			sps{i,j}.coefs(1,1,2), dx, dy);
    end
  end
  j = nr(2);
  for i=1:nr(1)
    N(:,i,j+1) = normal(sps{i,j}.coefs(1,1,end), ...
			sps{i,j}.coefs(1,1,end-1), ...
			sps{i,j}.coefs(1,2,end), -dy, dx);
  end
  i = nr(1);
  for j=1:nr(2)
    N(:,i+1,j) = normal(sps{i,j}.coefs(1,end,1), ...
			sps{i,j}.coefs(1,end,2), ...
			sps{i,j}.coefs(1,end-1,1), dy, -dx);
  end
  j = nr(2);
  N(:,i+1,j+1) = normal(sps{i,j}.coefs(1,end,end), ...
			sps{i,j}.coefs(1,end-1,end), ...
			sps{i,j}.coefs(1,end,end-1), -dx, -dy);
end

function N = normal(a, b, c, d1,d2)
  N = cross([b-a d1], [c-a d2]);
  N = N/norm(N);