function  [u, l] = tprange_check(D, psi, P, M, npoints, tol)
% [u, l] = tprange_check(D, psi, P, M, npoints=100, tol=1e-10)
% TPRANGE_CHECK -- Check that the upper and lower envelopes constructed from
% difference operators D and pcw bilinear estimates P and M are really upper
% and lower envelopes by evaluating each of the antidifference basis
% functions PSI and their envelopes on a NPOINTS x NPOINTS grid. Comparisons
% are done numerically with a tolerance of TOL.

% Created by lutter on Mon Oct 11 15:50:22 1999

if nargin < 5 npoints = 100; end;
if nargin < 6 tol = 1e-10; end;

t = cell(1,2);
lknots = cell(1,2);
for i=1:2
  grev = aveknt(psi.knots{i}, psi.order(i));
  lknots{i} = [grev(1) grev grev(end)];
  t{i} = linspace(grev(1), grev(end), npoints);
end

nop = D.k;
m = D.m;
n = D.n;
spP = spmak(lknots, reshape(P,[nop m n])+psi.coefs);
spM = spmak(lknots, reshape(M,[nop m n])+psi.coefs);
p = spval(psi, t);
pP = spval(spP, t);
pM = spval(spM, t);
ok = 1;
Pdiff = pP-p;
Mdiff = p-pM;
u = [ max(max(Pdiff,[],3),[],2)'; min(min(Pdiff, [], 3), [], 2)' ];
l = [ max(max(Mdiff,[],3),[],2)'; min(min(Mdiff, [], 3), [], 2)' ];
if any(Pdiff< - tol)
  fprintf('Upper envelope violated\n');
  ok = 0;
end
if any(Mdiff < - tol)
  fprintf('Lower envelope violated\n');
  ok = 0;
end
if ok 
  fprintf(['Envelopes checked on a uniform %d x %d grid, ' ...
	  'they seem to be valid\n'], npoints, npoints);
end

  