function psi = tppsi(D)
% psi = tppsi(D)
% TPPSI -- Generate the functions PSI for the Bernstein Bezier basis for
%          difference operators defined by the nets D (see MKNETS). TPPSI
%          returns the basis PSI for the lower left cell of the control
%          net as a tensor-product spline. PSI's for other cell's can be
%          obtained by flattening the PSI over that cell.

% Created by lutter on Thu Apr 15 14:36:32 1999
%
%
m = D.m;
n = D.n;
if isempty(D.nets)
  D = lapl(m, n);
end
nop = m*n-4;
B = mknets(m, n, D.nets);
Bf = flatnet(B, 1, 1);
A = mknets(m, n, (D.nets*Bf.nets')'\Bf.nets);
knots = { [zeros(1, m) ones(1, m)], [zeros(1, n) ones(1, n)] };
psi = spmak(knots, reshape(A.nets, nop, m, n));

function netsOut = flatnet(netsIn, i0, j0, i1, j1)
  % netsOut = flatnet(netsIn, i0, j0)
  % FLATNET -- Return as many control nets NETSOUT as there are in
  % NETSIN. The nets in NETSOUT are identical to the ones in NETSIN,
  % except that the bilinear interpolant of the mesh cell with lower left
  % hand corner (i0, j0) has been subtracted

  % Created by lutter on Fri Mar 12 18:25:48 1999
  if isstruct(netsIn)
    m = netsIn.m;
    n = netsIn.n;
  else
    [m n] = size(netsIn);
    netsIn = mknets(m, n, netsIn);
  end
  interp = zeros(m,n);
  netsOut = netsIn;
  nop = netsIn.k;
  if nargin<4
    i1 = i0+1;
    j1 = j0+1;
  end
  ofs = [ 0 0; i1-i0 0; 0 j1-j0; i1-i0 j1-j0 ];

  u = (0:m-1)/(m-1);
  v = (0:n-1)/(n-1);
  U = [ (1-u)', u' ];
  V = [ (1-v); v ];
  for op=1:nop
    %% Make the bilinear interpolant
    netIn = matnet(netsIn, op);
    b = zeros(4, 1);
    A = zeros(4, 4);
    for k=1:4
      u = (i0-1 + ofs(k, 1))/(m-1);
      v = (j0-1 + ofs(k, 2))/(n-1);
      b(k) = netIn(i0+ofs(k,1), j0+ofs(k,2));
      A(k,:) = [ (1-u)*(1-v) (1-u)*v u*(1-v) u*v ];
    end
    c = (A\b)';
    C = reshape(c, 2, 2)';
    %% Expand it 
    net = netIn - U*C*V;
    netsOut.nets(op,:) = net(:)';
  end	
