function tpplotpsi(D, k)
% tpplotpsi(D, k)
% TPPLOTPSI -- Plot the antidifference function corresponding to the K-th
% difference operator in D. Returns the control mesh of that function.

% Created by lutter on Thu Jun  3 17:05:23 1999
%
%

global cblack corange cblue

psi = tppsi(D);

d1 = psi.order(1)-1;
d2 = psi.order(2)-1;

cla;
nu = round(20/d1);
nv = round(20/d1);
t = { linspace(0,1,nu), linspace(0,1,nv) };

sp = spmak(psi.knots, squeeze(psi.coefs(k,:,:)));
tpplot(sp, 'Controlnet', 0, 'style', 'height');
x = aveknt(sp.knots{1}, sp.order(1));
y = aveknt(sp.knots{2}, sp.order(2));
p = fnval(sp, { x y });
for i=1:d1+1
  line(x(i)*ones(1, d2+1), y, p(i,:), 'Color', cblack);
  line(x(i)*ones(1, d2+1), y, zeros(1, d2+1), 'Color', corange);
end
for j=1:d2+1
  line(x, y(j)*ones(1, d1+1), p(:,j), 'Color', cblack);
  line(x, y(j)*ones(1, d1+1), zeros(1, d1+1), 'Color', corange);
end
grid on;
axislabel(d1, 'X');
axislabel(d2, 'Y');
xlabel('u_1');
ylabel('u_2');

psitext = sprintf('\\Psi_{%d}', k);
zlabel(psitext);
title(psitext);

set(0,'DefaultSurfaceEdgeColor', 'none');
axis on
rotate3d on
view(59,14);

function axislabel(d, axis)
  label=cell(1,d+1);
  label{1} = '0';
  label{d+1} = '1';
  set(gca, [axis, 'Tick'], (0:d)/d);
  set(gca, [axis, 'TickLabel'], label);
