function [upper, lower] = tpplotenv(sp, D, psiP, psiM, varargin)
% [upper, lower] = tpplotenv(sp, D, psiP, psiM, ...)
% TPPLOTENV -- Plot a TP function and its upper and lower envelopes based
% on differences D and upper and lower estimates PSIP and PSIM for the
% antidifference basis. The remaining arguments are passed on to TPPLOT.
%
% The return values UPPER and LOWER are the pcw bilinear upper and lower
% envelopes as returned by TPENV

% Created by lutter on Fri Oct  1 16:36:47 1999

global cred cblue corange

[upper, lower] = tpenv(sp, D, psiP, psiM);
x = aveknt(sp.knots{1}, sp.order(1));
y = aveknt(sp.knots{2}, sp.order(2));

tpplot(sp, varargin{:});

surface(x, y, lower', 'FaceColor', 'none', 'EdgeColor', corange);
surface(x, y, upper', 'FaceColor', 'none', 'EdgeColor', cred);

rotate3d on;
