function tpplot(B, varargin)
% tpplot(B, varargin)
% TPPLOT -- Plot a TP Bernstein polynomial B. The remaining (optional)
% arguments are keyword/value pairs to modify the plot. They are:
%    'Depth'     -- the number of subdivision levels
%    'Style'     -- string, if it equals 'mesh', B is plotted as a mesh,
%                   if it equals 'height', B is plotted in colors
%                   indicating size of the function value,
%                   otherwise it is rendered as a Phong shaded surface.
%    'ControlNet' -- draw control net if true

% Created by lutter on Wed Sep 29 22:59:53 1999
%
%
global cblack corange

nr = [8 8];				% Default depths
mesh_style = 'phong';
plot_cnet = 1;
for i=1:2:length(varargin)
  key = varargin{i};
  val = varargin{i+1};
  if strcmpi(key, 'Depth')
    nr = val;
  elseif strcmpi(key, 'Style')
    mesh_style =  val;
  elseif strcmpi(key, 'ControlNet')
    plot_cnet = val;
  else
    error(sprintf('Unknown option key %s', key));
  end
end

[p,x,y] = tprender(B, nr);

if strcmpi(mesh_style, 'mesh')
  surface(x,y,p','EdgeColor', corange, 'FaceColor', 'none', 'LineWidth', 1);
  if plot_cnet
    surface(aveknt(B.knots{1}, B.order(1)), aveknt(B.knots{2}, B.order(2)), ...
	    squeeze(B.coefs)', ...
	    'FaceColor', 'none', 'EdgeColor', cblack);
  end
  set(gcf, 'Renderer', 'painters');
elseif strcmpi(mesh_style, 'height')
  surf(x, y, p');
else
  surface(x,y,p','EdgeColor','none','FaceColor', [.85 .15 .1], ...
	  'FaceLighting','phong');
  if plot_cnet
    surface(aveknt(B.knots{1}, B.order(1)), aveknt(B.knots{2}, B.order(2)), ...
	    squeeze(B.coefs)', ...
	    'FaceColor', 'none', 'EdgeColor', [0 1 0]);
  end
  light('Position',[0 0 100]);
  light('Position',[0 0 -100], 'Color', [ 1 .975 .75 ]);
  set(gcf, 'Renderer', 'zbuffer');
end
rotate3d on;
