function  [P, M] = tpgenrange(name, m, n, niter, ndepth)
% [P, M] = tpgenrange(name, m, n, niter, ndepth)
% TPGENRANGE -- Generate range estimates for the antidifference basis for
% the difference operators called NAME for TP polynomials of order m x n.
% NITER and NDEPTH are passed to tprange.
%
% The difference operators, the range estimates P and M and NITER and
% NDEPTH are stored in a file in the subdirectory './range/' in the
% current directory. The filename is NAME-MxN.m
%
% There has to be a function NAME that takes M and N as arguments and
% returns the corresponding difference operator. See the routine COMB for
% an example.

% Created by lutter on Mon Sep 20 11:39:03 1999

if nargin < 4  niter = 1; end
if nargin < 5  ndepth = 5; end

D = eval([name,'(',num2str(m),',',num2str(n),')']);
psi = tppsi(D);
nop = m*n-4;
fname = ['range/', name, '-', num2str(m), 'x', num2str(n)];

S = [];
if exist([fname, '.mat'], 'file')
  fprintf('Loading existing bounds from %s.\n', fname);
  S = load(fname);
  P = S.P;
  M = S.M;
else
  fprintf('Generating bounds from scratch.\n');
  if checkconv(psi, 0)
    fprintf('Psi are convex.\n');
    [P, M] = tpcvrange(psi);
  else
    P = [];
    M = [];
  end
end
[P, M] = tprange(D, psi, P, M, niter, ndepth);

% Save the mess
if isfield(S, 'niter')
  niter = niter + S.niter;
end
if isfield(S, 'ndepth')
  ndepth = max(ndepth, S.ndepth);
end
save(fname, 'D', 'P', 'M', 'niter', 'ndepth');
