function [P,M] = tpcvrange(psi)
% [P,M] = tpcvrange(psi)
% TPCVRANGE -- Estimate the range of convex basis functions PSI by using
% their pcw bilinear interpolant as an upper bound and their control net
% as a lower bound.

% Created by lutter on Fri Oct  1 17:01:49 1999
%
%

x = aveknt(psi.knots{1}, psi.order(1));
y = aveknt(psi.knots{2}, psi.order(2));
P = reshape(fnval(psi, {x, y}) - psi.coefs, [psi.dim, prod(psi.number)]);
M = zeros(psi.dim, prod(psi.number));
