function isconv = tpconvex_p(psi, verbose)
% isconv = tpconvex_p(psi, verbose=1, tol=1e-8)
% TPCONVEX_P -- Check whether the antidifference basis PSI is (numerically)
% directionally convex by computing all univariate second differences of
% the control nets and checking that they are bigger than -TOL, a small
% positive number.
%
% Returns 0 or 1

% Created by lutter on Fri Jun  4 16:01:04 1999

if nargin < 2  verbose=1; end;
if nargin < 3  tol = 1e-8; end;

m = psi.order(1);
n = psi.order(2);
nop = m*n-4;
Delta = delta(m, n);
isconv = 1;
for k=1:size(psi.coefs, 1)
  c = reshape(psi.coefs(k,:,:), [1 m*n])';
  small = min(min(c));
  if small < -tol
    if verbose
      fprintf('Psi_%d negative? min_coeff = %g\n', k, small);
    end
    isconv = 0;
  end
  c(find(abs(c)<1e-8)) = 0.0;
  small = min(min(Delta.nets*c));
  if small < -tol
    if verbose
      fprintf('Psi_%d nonconvex ? min_diff = %g\n', k, small);
    end
    isconv = 0;
  end
end
