function  D = symm(m,n)
% D = symm(m, n)
% SYMM -- Construct symmetric difference operators based on tensoring
% univariate operators. These produce convex antidifferences and
% are called D^{cnv} in the thesis.

% Created by lutter on Thu Jun 24 19:27:13 1999
%
%

nop = m*n-4;

D = zeros(nop, m, n);
op = 1;
for i=2:m-1
  D(op  , i-1:i+1, 1) = [1 -2 1];
  D(op+1, i-1:i+1, n) = [1 -2 1];
  op = op + 2;
end
for j=2:n-1
  D(op   , 1, j-1:j+1) = [1 -2 1];
  D(op+1 , m, j-1:j+1) = [1 -2 1];
  op = op + 2;
end
for i=2:m-1
  for j=2:n-1
    D(op, i-1, j-1:j+1) = [-1  2 -1];
    D(op, i,   j-1:j+1) = [ 2 -4  2]; 
    D(op, i+1, j-1:j+1) = [-1  2 -1];
    op = op + 1;
  end
end
D = mknets(m, n, reshape(D, nop, m*n));
