function nets = mknets(m, n, rows)
% nets = mknets(m, n, [rows])
% MKNETS -- Make a structure with the fields
%   type: 'nets'
%      k: # of nets in rows
%      m: m
%      n: n
%   nets: rows (or [] if rows is not given)
%
% This structure is used to represent a collection of control nets. ROWS
% must be a matrix with m*n columns and arbitrary many rows. Each row
% represents one m x n net through reshape(rows(i,:), m, n)

% Created by lutter on Thu May 20 15:14:10 1999
%
%
if nargin < 3
  rows = [];
end
k = prod(size(rows))/(m*n);
nets = struct('type', 'nets', 'k', k, ...
	      'm', m, 'n', n, 'nets', reshape(rows, [k m*n]));
