function S = loadrange(name, m, n)
% S = loadrange(name, m, n)
% LOADRANGE -- Load precomputed range estimates from a file. NAME is the
% name of the difference operators, M and N the order of the TP
% polynomials. 
%
% The estimates are loaded from the subdirectory './range/'
%
% The return value is a structure with fields
%   S.D      -- difference operators
%   S.P, S.M -- upper and lower range estimates
%   S.niter,
%   S.depth  -- number of iterations and subdivision depth that was used
%               to generate the range estimates

% Created by lutter on Thu Oct 28 23:29:10 1999

S = load(['range/', name,'-',num2str(m),'x',num2str(n)]);
