function D = lapl(m, n)
% D = lapl(m, n)
% LAPL --   Make a matrix of second difference operators for nets of size
%           m x n that annihilates bilinear nets. 
%           Along the borders, the operators are [1 -2 1], and in the
%           interior they are         1
%                                  1 -4 1
%                                     1
%           Return a struct as described in mknets

% Created by lutter on Fri Mar 12 17:30:26 1999
%
%

nop = m*n-4;

D = zeros(nop, m, n);
op = 1;
for i=2:m-1
  D(op  , i-1:i+1, 1) = [1 -2 1];
  D(op+1, i-1:i+1, n) = [1 -2 1];
  op = op + 2;
end
for j=2:n-1
  D(op   , 1, j-1:j+1) = [1 -2 1];
  D(op+1 , m, j-1:j+1) = [1 -2 1];
  op = op + 2;
end
for i=2:m-1
  for j=2:n-1
    D(op, i, j-1:j+1) = [1 -4 1]; 
    D(op, [i-1 i+1], j) = [1 1];
    op = op + 1;
  end
end
D = mknets(m, n, reshape(D, nop, m*n));
