function junk = figdefault(scheme)
% figdefault([scheme])
% FIGDEFAULT -- Set my defaults and global vars for figures to scheme 
%               SCHEME. Currently, the schemes supported are
%               'grey', 'gray' -- suitable for printing on a b&w printer
%               'color'        -- suitable for color slides
%               The default is 'grey'

% Created by lutter on Tue Nov 10 23:21:15 1998
%
%
%% Default colors
global cbackground cred corange cblue cblack cgrey linewidth fontsize;
if nargin < 1
  scheme = 'color';
end
if strcmp(scheme, 'color')		% For color slides
  cbackground = .4*ones(1,3);
  cgrey = [.6 .6 .6];
  cred    = [ 1  0 0 ];
  corange = [1 .6 .2 ];
  cblue   = [.1 .2 1 ];
  cblack  = [ 0  0 0 ];
  linewidth = 2;
  fontsize = 20;
elseif strcmp(scheme, 'overhead')
  cbackground = ones(1,3);
  cgrey = [.6 .6 .6];
  cred    = [ 1  .3 .3 ];
  corange = [.8 .1 .1 ];
  cblue   = [.1 .2 1 ];
  cblack  = [ 0  0 0 ];
  linewidth = 2;
  fontsize = 20;
else					% For b&w slides
  cbackground = ones(1,3);
  cgrey = .8*ones(1,3);
  cred    = .4*ones(1,3);
  corange = .6*ones(1,3);
  cblue   = .4*ones(1,3);
  cblack  = [ 0  0 0 ];
  linewidth = 2;
  fontsize = 20;
end

%% Figure
set(0, 'DefaultFigureInvertHardCopy', 'off');
set(0, 'DefaultFigureColor', cbackground);
set(0, 'DefaultFigureNextPlot', 'add');	% hold by default
set(0, 'DefaultFigurePosition', [512 303 512 384]);
%% Axes
set(0, 'DefaultAxesColor', cbackground);
set(0, 'DefaultAxesVisible', 'off');
set(0, 'DefaultAxesFontName', 'Times');
set(0, 'DefaultAxesFontSize', fontsize);
set(0, 'DefaultAxesLineWidth', linewidth);
set(0, 'DefaultAxesNextPlot', 'add');	% hold by default
%% Line
set(0, 'DefaultLineLineWidth', linewidth);
set(0, 'DefaultLineColor', cblue);
%% Text
set(0, 'DefaultTextFontName', 'Times');
set(0, 'DefaultTextFontSize', fontsize);
%% Patch
set(0, 'DefaultPatchLineWidth', linewidth);
set(0, 'DefaultPatchEdgeColor', cblue);
%% Surface
set(0, 'DefaultSurfaceLineWidth', linewidth);
set(0, 'DefaultSurfaceFaceColor', 'interp')

fprintf('figdefault: set scheme to %s.\n', scheme);