% EXAMPLES -- Example use of the TP envelope routines

% Created by lutter on Sun Jun  4 23:17:31 2000

close all;
figdefault;

% Make a bicubic TP Bernstein polynomial
t = ({ [zeros(1,4) ones(1,4)], [zeros(1,4) ones(1,4)] });
sp = spmak(t, [ 0 1 2 0; 2 2 2 1; 1 2 2 2; 0 2 1 0]);

% Plot it pretty
figure(1);
tpplot(sp);
view(20, 25);
disp('An example tensor product Bernstein polynomial.');
disp('You can rotate this and all the other plots by');
disp('dragging it with the left mouse button. (See ROTATE3D)');
fprintf('\nRemember that you need to have the spline toolbox to\n');
disp('be able to use these routines.');
disp('Press a key to continue ...');
pause;

% Compute a range estimate
fprintf('\n\n----------------------------------------------------------------\n');
disp('Construct difference operators D')
D = comb(4,4)
disp('Compute antidifference basis PSI')
psi = tppsi(D)
disp('Using TPRANGE to estimate the range of PSI. This might take a while');
tic; [P M] = tprange(D, psi, [], [], 3, 2); 
fprintf('  Estimates computed in roughly %fs\n', toc);
figure(2);
disp('Plotting envelope');
[upper, lower] = tpplotenv(sp, D, P, M, 'style', 'mesh');
view(20, 25);
disp('Upper envelope:')
upper
disp('Lower envelope:')
lower
fprintf('Envelope width: %f\n', max(max(upper-lower)));
disp('Press a key to continue ...');
pause;

% Plot and compute an envelope based on stored range estimates
fprintf('\n\n----------------------------------------------------------------\n');
disp('Loading range estimates based on difference operator COMB');
S = loadrange('comb', 4, 4);
figure(3);
disp('Plotting envelope');
[upper, lower] = tpplotenv(sp, S.D, S.P, S.M, 'style', 'mesh');
view(20, 25);
disp('Upper envelope:')
upper
disp('Lower envelope:')
lower
fprintf('Envelope width: %f\n', max(max(upper-lower)));
disp('Press a key to continue ...');
pause;

fprintf('\n\n----------------------------------------------------------------\n');
disp('Checking the envelope numerically:');
tprange_check(S.D, psi, S.P, S.M);
disp('Press a key to continue ...');
pause;

% Plot one antidifference function
fprintf('\n\n----------------------------------------------------------------\n');
disp('Checking convexity of difference operators:');
if tpconvex_p(psi, 1)
  disp('  The operators are convex');
else
  disp('  The operators are _not_ convex');
end
fprintf('\n\n----------------------------------------------------------------\n');
disp('Plotting the 3rd antidifference function');
figure(4);
tpplotpsi(S.D, 3);