function D = delta(m, n)
% D = delta(d1, d2)
% DELTA -- Make the matrix of difference operators for quad nets of size
%          m x n. The coefficients are assumed to be labeled in column
%          major order.

% Created by lutter on Thu Mar 11 18:08:42 1999
%
%

nop = (m-2)*n + m*(n-2);
ncoeff = m*n;

D = zeros(nop, ncoeff);
for i=1:n
  for j=2:m-1
    D((m-2)*(i-1)+j-1, m*(i-1)+(j-1:j+1)) = [1 -2 1];
  end
end
for j=1:m
  for i=2:n-1
    D((m-2)*n+(n-2)*(j-1)+i-1, m*(i-2:i)+j) = [1 -2 1];
  end
end

D = mknets(m, n, D);
