function D = comb(m, n, all)
% D = comb(m, n)
% COMB -- Make second difference operators from the univariate 2nd diff
%         by arranging them in a comb like shape

% Created by lutter on Wed Jun  2 21:56:30 1999
%
%
if nargin < 3  all=0; end;

if all
  nop = 2*(m*n-m-n);
else
  nop = m*n - 4;
end

D = zeros(nop, m, n);
op = 1;
% First (m-2)*n operators
for i=2:m-1
  for j=1:n
    D(op, i-1:i+1, j) = [1 -2 1];
    op = op+1;
  end
end
% 2*(n-2) more operators
for j=2:n-1
  D(op  , 1, j-1:j+1) = [1 -2 1];
  D(op+1, m, j-1:j+1) = [1 -2 1];
  op = op+2;
end

%% Append the remaining differences if all is set
if all
  for i=2:m-1
    for j=2:n-1
      D(op, i, j-1:j+1) = [1 -2 1];
      op = op+1;
    end
  end
end
D = mknets(m, n, reshape(D, nop, m*n));