% Computation of piecewise bilinear envelopes of tensor product Bernstein
% polynomials. You might want to read my thesis 'Envelopes of nonlinear
% geometry' first. Available from 
%     http://www.watzmann.net/lutter/papers/
%  or http://www.cise.ufl.edu/research/SurfLab/papers/
%
%  For an example how to use these routines see examples.m
%
% Data structures
%
%   TP Bernstein polynomials are represented as TP B-splines using the
%   B-spline toolbox routines (see spmak in the B-spline toolbox)
%
%   Difference operators and the coefficients of antidifference bases
%   (pcw bilinear functions) are represented as net structures as
%   produced by the function mknets.
%  
%   Range estimates are usually represented as a k x mn matrix, where k
%   is the number of difference operators and the underlying polynomials
%   have order [m n]. That means that one row corresponds to one
%   antidifference function and hence to one difference operator
%
%   Upper and lower envelopes are represented as m x n matrices where the 
%   underlying spline has order [m n].
%
% Net manipulation
%
%   mknets - make a net structure
%   p      - print a net structure in a readable format
%   matnet - extract the i-th net in a vector of nets and reshape it into a
%            matrix 
%
% Constructing difference operators
%   All these routines take the order of the polynomials M and N as
%   arguments. comb(3,4) constructs the comb difference operators for
%   bidegree 2 x 3. 
%   comb         - Comb difference operators
%   delta        - Univariate difference operators (all of them, not
%                  linearly independent)
%   lapl         - Differences based on the Laplacian
%   symm         - Symmetric operators based on tensoring univariate
%                  operators. These produce convex antidifferences and
%                  are called D^{cnv} in the thesis
%   
% Range estimation
%   tprange      - Improve a range estimate using the subdivide and bound
%                  procedure.
%   tpcvrange    - Create an initial range estimate for convex differences.
%   tpgenrange   - Driver for tprange which also saves the estimates in a
%                  file in subdirectory './range/' for use with loadrange
%   genranges    - Generate the range estimates for difference operators
%                  SYMM, LAPL, and COMB up to order 8 x 8
%   loadrange    - Load precomputed range estimates from disk
%   tpconvex_p   - Check whether a antidifference basis is directionally
%                  convex 
%   tprange_check- Verify numerically that range estimates lead to valid
%                  envelopes 
%
% Plotting
%
%   tpplot       - Plot a TP polynomial
%   tpplotenv    - Plot a TP polynomial together with its envelope
%   tprender     - Utility function used by tpplot to subdivide TP
%                  polynomial 
%   tpplotpsi    - Plot one antidifference basis function corresponding
%                  to a given difference operator.
%   tpplotallpsi - Plot all antidifference basis functions for a set of
%                  difference operators into one figure
%


