c-----------------------------------------------------------------------
c
c	make (binary) input file for fft example program
c
c-----------------------------------------------------------------------

	program main
	parameter (MAXCOL = 10)
	real temp(MAXCOL)
	integer nrows, ncols
	integer iunit
	complex ctemp

	print*, 'enter nrows, ncols'
	read*, nrows, ncols
	if (ncols .gt. MAXCOL) then
		print*, 'ncols must be .le. ', MAXCOL
		stop
	endif

	iunit = 11
	open(unit=iunit, file='fft.IN', form='unformatted')

	print*, 'enter data'
	do ii = 1, nrows
		read*, (temp(jj), jj = 1, ncols)
		do jj = 1, ncols
			ctemp = cmplx(temp(jj), 0.0)
			write (iunit) ctemp
		enddo
	enddo

	close (iunit)

	end
