C***********************************************************************
C
C    File: /home/ama-iris/g/fortranm/Berna-Mesh/NX/mesh_parms.H
C
C    Last Modified By: Rajit Manohar (rajit@vlsi.cs.caltech.edu)
C    Modification Date: Thu Jul 21 03:17:56 PDT 1994
C    Modification: Added message tags used by P4 calls.
C
C    Original Author: Berna Massingill (berna@vlsi.cs.caltech.edu)
C    Date: Thu Jul 21 03:16:13 PDT 1994
C    Info: Parameters used by the Mesh template, derived from those
C      specified by the user.
C
C***********************************************************************
C=======================================================================
C
C	parameters for mesh computation
C
C=======================================================================

C	must be preceded by include for mesh_uparms.h

C	process types
	integer HOSTTYPE, GRIDTYPE
	parameter(HOSTTYPE=1)
	parameter(GRIDTYPE=2)

C	number of processes
	integer NPROCS
	parameter (NPROCS=XPROCS*YPROCS+1)

C	sizes for local sections without ghost boundaries
	PARAMETER (NXlsize=(NX+XPROCS-1)/XPROCS)
	PARAMETER (NYlsize=(NY+YPROCS-1)/YPROCS)

C	bounds for local sections with ghost boundaries
	PARAMETER (IXLO=1-NGHOST)
	PARAMETER (IXHI=NXlsize+NGHOST)
	PARAMETER (IYLO=1-NGHOST)
	PARAMETER (IYHI=NYlsize+NGHOST)


C#######################################################################
C
C    Modified By: Rajit Manohar
C    On: Thu Jul 21 03:18:22 PDT 1994
C
C    Added the following NX tags for messages:
C       MSG_HTOGINT_TAG  : Used for sending host to grid message. (INTEGER)
C       MSG_GTOHINT_TAG  : Used for sending grid to host message. (INTEGER)
C       MSG_HTOGFLT_TAG  : Used for sending host to grid message. (REAL)
C       MSG_GTOHFLT_TAG  : Used for sending grid to host message. (REAL)
C       MSG_XCH_XLOW_TAG : Boundary exchange, sending to low x.
C       MSG_XCH_XHI_TAG  : Boundary exchange, sending to high x.
C       MSG_XCH_YLOW_TAG : Boundary exchange, sending to low y.
C       MSG_XCH_YHI_TAG  : Boundary exchange, sending to high x.
C#######################################################################
C    Additional modification by Berna Massingill
C    On: Wed  Apr 5 1995
C    Added parameters for sizes of integers, reals.
C#######################################################################
	integer MSG_HTOGINT_TAG, MSG_GTOHINT_TAG
	integer MSG_HTOGFLT_TAG, MSG_GTOHFLT_TAG
        integer MSG_XCH_XLOW_TAG,MSG_XCH_XHI_TAG
        integer MSG_XCH_YLOW_TAG,MSG_XCH_YHI_TAG

        parameter (MSG_HTOGINT_TAG = 1, MSG_GTOHINT_TAG = 2)
        parameter (MSG_HTOGFLT_TAG = 3, MSG_GTOHFLT_TAG = 4)
        parameter (MSG_XCH_XLOW_TAG = 5, MSG_XCH_XHI_TAG = 6)
        parameter (MSG_XCH_YLOW_TAG = 7, MSG_XCH_YHI_TAG = 8)

	integer INTEGER_SIZE
	integer REAL_SIZE

	parameter (INTEGER_SIZE = 4)
	parameter (REAL_SIZE = 4)
C#######################################################################
C     End of Modification.
C#######################################################################
