C=======================================================================
C
C	common block for mesh-computation template
C
C=======================================================================

C	must be preceded by includes for mesh_uparms.h, mesh_parms.h


C	iprocx, iprocy, iprocz are process's coordinates in process
C		grid; iproc_idx is its process number.
	integer iprocx, iprocy, iprocz, iproc_idx

C	l_ioproc is .true. iff this is the designated sequential I/O
C		process
	logical l_ioproc

C	N*local are the sizes of the local sections -- may be 
C		different for different processes if dimensions of
C		process grid do not divide array sizes
	integer NXlocal, NYlocal, NZlocal

C	ports for grid processes (except I/O process) are:
C		inxlo, outxlo, .... connect to neighbors
C		*_glb_* connect to the I/O process
C	ports for the I/O process are:
C		io_*_glb_*(..) connect to the other processes
C
	inport (integer N, real A(N))
     $		inxlo, inxhi, inylo, inyhi, inzlo, inzhi
	outport (integer N, real A(N))
     $		outxlo, outxhi, outylo, outyhi, outzlo, outzhi
	inport (integer N, integer A(N)) in_glb_int
	outport (integer N, integer A(N)) out_glb_int
	inport (integer N, real A(N)) in_glb_real
	outport (integer N, real A(N)) out_glb_real

	inport (integer N, integer A(N))
     $		io_in_glb_int(XPROCS, YPROCS, ZPROCS)
	outport (integer N, integer A(N))
     $		io_out_glb_int(XPROCS, YPROCS, ZPROCS)
	inport (integer N, real A(N))
     $		io_in_glb_real(XPROCS, YPROCS, ZPROCS)
	outport (integer N, real A(N))
     $		io_out_glb_real(XPROCS, YPROCS, ZPROCS)

	process common /mcommon/ iprocx, iprocy, iprocz, iproc_idx,
     $		l_ioproc,
     $		NXlocal, NYlocal, NZlocal,
     $		inxlo, inxhi, inylo, inyhi, inzlo, inzhi,
     $		outxlo, outxhi, outylo, outyhi, outzlo, outzhi,
     $		in_glb_int, out_glb_int,
     $		in_glb_real, out_glb_real,
     $		io_in_glb_int, io_out_glb_int,
     $		io_in_glb_real, io_out_glb_real
C
C	Fortran M temporary addition: 
C	dummy stmt because last stmt in include file is dropped
	integer idummy
