/****************************************************************************
 *
 *    Portable Compressed I/O
 *    Author: Rajit Manohar
 *    Date: Thu Jul 28 14:45:12 PDT 1994
 *
 ***************************************************************************/

#ifndef __PIO_H__
#define __PIO_H__

#include <stdio.h>

/******************************************************************************
 * #defines that you might want to modify.
 *
 *  MAX_OPEN_FILES:
 *       The maximum number of files that can be open at one time.
 *
 *  DIVISOR: 
 *       The floating-point numbers are stored in units of 1/(2^DIVISOR).
 *    CANNOT EXCEED 255.
 *    ASSUMED FOR ALL FILES THAT 2^DIVISOR can fit into an integer.
 *
 *****************************************************************************/
#define MAX_OPEN_FILES 256	/* maximum number of open files */

#define DIVISOR 31		/* floating-point precision 1/(2^DIVISOR) */

/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/

/**** Portable I/O Routine Declarations ****/

void pioopenread (int *file_handle, char *myfile, int *len);
void pioopenread_ (int *file_handle, char *myfile, int *len);
void pioopenwrite (int *file_handle, char *myfile, int *len);
void pioopenwrite_ (int *file_handle, char *myfile, int *len);
void pioclose (int *file_handle);
void pioclose_ (int *file_handle);
void piowritereal (int *file_handle, float *array, int *size);
void piowritereal_ (int *file_handle, float *array, int *size);
void piowriteint (int *file_handle, int *array, int *size);
void piowriteint_ (int *file_handle, int *array, int *size);
void pioreadreal (int *file_handle, float *array, int *size);
void pioreadreal_ (int *file_handle, float *array, int *size);
void pioreadint (int *file_handle, int *array, int *size);
void pioreadint_ (int *file_handle, int *array, int *size);

/**** Compressed I/O Routine Declarations ****/

void c_openread (int *file_handle, char *myfile, int *len);
void c_openread_ (int *file_handle, char *myfile, int *len);
void c_openwrite (int *file_handle, char *myfile, int *len);
void c_openwrite_ (int *file_handle, char *myfile, int *len);
void c_close (int *file_handle);
void c_close_ (int *file_handle);
int c_write (int *file_handle, char *array, int *size);
int c_write_ (int *file_handle, char *array, int *size);
int c_read (int *file_handle, char *array, int *size);
int c_read_ (int *file_handle, char *array, int *size);

/**** Portable Compressed I/O Routine Declarations ****/

void c_pioopenread (int *file_handle, char *myfile, int *len);
void c_pioopenread_ (int *file_handle, char *myfile, int *len);
void c_pioopenwrite (int *file_handle, char *myfile, int *len);
void c_pioopenwrite_ (int *file_handle, char *myfile, int *len);
void c_pioclose (int *file_handle);
void c_pioclose_ (int *file_handle);
void c_piowritereal (int *file_handle, float *array, int *size);
void c_piowritereal_ (int *file_handle, float *array, int *size);
void c_piowriteint (int *file_handle, int *array, int *size);
void c_piowriteint_ (int *file_handle, int *array, int *size);
void c_pioreadreal (int *file_handle, float *array, int *size);
void c_pioreadreal_ (int *file_handle, float *array, int *size);
void c_pioreadint (int *file_handle, int *array, int *size);
void c_pioreadint_ (int *file_handle, int *array, int *size);


#endif
