      program merge

#ifdef COMPRESSED
#define OREAD c_pioopenread
#define OWRITE c_pioopenwrite
#define READ c_pioreadreal
#define WRITE c_piowritereal
#define IREAD c_pioreadint
#define IWRITE c_piowriteint
#define CLOSE c_pioclose
#else
#define OREAD pioopenread
#define OWRITE pioopenwrite
#define READ pioreadreal
#define WRITE piowritereal
#define IREAD pioreadint
#define IWRITE piowriteint
#define CLOSE pioclose
#endif

      include 'mesh_uparms.h'
      include 'mesh_parms.h'

      character*128 filename
      character*256 file
      character*128 argument
      integer NumberOfArrays
      real strip(NX)
      real tmpstrip(NXlsize)
      integer itype(4)
      integer fdin, fdout

      if (iargc() .ne. 2) then
         print *, 'Usage: [c]merge NUMBER_OF_ARRAYS file_to_merge'
         stop
      endif
      call getarg (1, argument)
      call getarg (2, filename)
      read (unit=argument,FMT='(I)') NumberOfArrays
      print *, 'Number of Arrays in File: ', NumberOfArrays
      ilen = len(filename)
      do while (filename(ilen:ilen) .eq. ' ')
         ilen = ilen - 1
      end do
      print *, 'Merge File: ', filename(1:ilen)

      iNXlsize = (nx+xprocs-1)/xprocs
      iNYlsize = (ny+yprocs-1)/yprocs

      call OWRITE (fdout, filename, 128)
      if (fdout .eq. -1) then
         print *, 'Could not open file ', filename,
     $        ' for writing.'
         stop
      endif
      itype(1) = NX
      itype(2) = NY
      itype(3) = XPROCS
      itype(4) = YPROCS
      call IWRITE (fdout, itype, 4)
      if (fdout .eq. -1) then
         print *, 'Could not write to file ', filename
         stop
      endif

      do ii = 1, NumberOfArrays
         do i = 1, NY
            iy = (i-1)/iNYlsize+1
            NYlocal = iNYlsize
            if (iy .eq. YPROCS) NYlocal = ny-(yprocs-1)*iNYlsize
            
            do ix = 1, XPROCS

               NXlocal = iNXlsize
               if (ix .eq. xprocs) NXlocal = nx-(xprocs-1)*iNXlsize
               call fname (GRIDTYPE, ix, iy, filename, file)
               call OREAD (fdin, file, 256)
               if (fdin .eq. -1) then
                  print *, 'Could not open file ', file,
     $                 'for reading'
                  stop
               endif
               call IREAD (fdin, itype, 4)
               if ((itype(1) .ne. NX) .or. (itype(2) .ne. NY) .or.
     $              (itype(3) .ne. XPROCS) .or.
     $              (itype(4) .ne. YPROCS)) 
     $              then
                  print *, file, ' was created for: '
                  print *, 'NX=', itype(1), ' NY=', itype(2),
     $                 ' XPROCS=', itype(3), ' YPROCS=', itype(4)
                  stop
               endif
            
C     seek to current strip.
C     skip: i-(iy-1)*NYlsize+(ii-1)*iNYlsize
            
               do l = 1, i-(iy-1)*iNYlsize-1+(ii-1)*iNYlsize
                  call READ (fdin, tmpstrip, NXlocal)
                  if (fdin .eq. -1) then
                     print *, 'Error reading data from file ', 
     $                    file
                     stop
                  endif
               end do
               
               call READ (fdin, strip((ix-1)*iNXlsize+1), 
     $              NXlocal)
               call CLOSE (fdin)
            end do
            call WRITE (fdout, strip, nx)
         end do
      end do
      call CLOSE (fdout)
      end


C=======================================================================
C
C	subroutine to generate filename
C
C=======================================================================

	subroutine fname(iptype, ipx, ipy, inname, outname)

C	precondition:
C		iptype is process type (HOSTTYPE or GRIDTYPE)
C		ipx, ipy are coordinates of process in process
C			grid (if iptype is GRIDTYPE) -- assumed to
C			be no more than 2 digits each
C		inname is a character string -- base for file name
C	postcondition:
C		outname is inname followed by:
C			'host' if iptype is HOSTTYPE,
C			process grid coordinates (ipx, ipy)
C				if iptype is GRIDTYPE

	include 'mesh_uparms.h'
	include 'mesh_parms.h'

	character*(*) inname
	character*(*) outname
	character*8 cbuff

	if (iptype .eq. HOSTTYPE) then
		outname = inname // 'host'
	else
		if (XPROCS .le. 9 .and. YPROCS .le. 9) then
			write (cbuff, '(3i1.1)') ipx,ipy
		else
			write (cbuff, '(3i2.2)') ipx,ipy
		endif
                call getrlen (inname, ilen)
		outname = inname(1:ilen) // cbuff
	endif

	return
	end

      subroutine getrlen (string,ilen)
      character*(*) string
c
c     subroutine gets length of that part of the string which has 
c     nonblank characters
c
      ilen = len(string)
      do while (string(ilen:ilen) .eq. ' ')
         ilen = ilen - 1
      end do
      return
      end


