C=======================================================================
C
C	common block for mesh-computation template
C
C=======================================================================

C	must be preceded by includes for mesh_uparms.h, mesh_parms.h


C	iproctype is the process type (host or grid -- see mesh_parms.h
C		for values)
C	iprocx, iprocy are coordinates for a grid process

	integer iproctype, iprocx, iprocy

C	N*local are the sizes of the local sections -- may be 
C		different for different processes if dimensions of
C		process grid do not divide array sizes
	integer NXlocal, NYlocal

C	ports for grid processes are:
C		inxlo, outxlo, .... connect to grid neighbors
C		*_glb_* connect to the host
C	ports for the host process are:
C		host_*_glb_*(..) connect to the grid processes
C
	inport (integer N, real A(N))
     $		inxlo, inxhi, inylo, inyhi
	outport (integer N, real A(N))
     $		outxlo, outxhi, outylo, outyhi
	inport (integer N, integer A(N)) in_glb_int
	outport (integer N, integer A(N)) out_glb_int
	inport (integer N, real A(N)) in_glb_real
	outport (integer N, real A(N)) out_glb_real

	inport (integer N, integer A(N))
     $		host_in_glb_int(XPROCS, YPROCS)
	outport (integer N, integer A(N))
     $		host_out_glb_int(XPROCS, YPROCS)
	inport (integer N, real A(N))
     $		host_in_glb_real(XPROCS, YPROCS)
	outport (integer N, real A(N))
     $		host_out_glb_real(XPROCS, YPROCS)

	process common /mcommon/ iproctype, iprocx, iprocy,
     $		NXlocal, NYlocal,
     $		inxlo, inxhi, inylo, inyhi,
     $		outxlo, outxhi, outylo, outyhi,
     $		in_glb_int, out_glb_int,
     $		in_glb_real, out_glb_real,
     $		host_in_glb_int, host_out_glb_int,
     $		host_in_glb_real, host_out_glb_real
C
C	Fortran M temporary addition: 
C	dummy stmt because last stmt in include file is dropped
	integer idummy
