#ifndef MSA_K_H
#define MSA_K_H


//const

#define MAXLEN_K 2000
#define MAX_SEQ_NUM 100

#define SPACE_SIZE 300000000
#define WINDOW_ALIGNMENT_SIZE_K 500

typedef struct group_node_k
{ 
	int childrenCount;
	char* alignment[MAX_SEQ_NUM];
	int orginal_index[MAX_SEQ_NUM];
	int alignmentLength;
	int alignment_sequences_count;
	struct group_node_k* children_group_nodes[MAX_SEQ_NUM];
}GROUP_NODE;

int sequence_pair_upperbound_scores_k[MAX_SEQ_NUM][MAX_SEQ_NUM];
int sequence_pair_induced_sp_scores_k[MAX_SEQ_NUM][MAX_SEQ_NUM];
int sequence_pair_induced_gap_number_k[MAX_SEQ_NUM][MAX_SEQ_NUM];
int sequence_pair_weight_gap_penalty_k[MAX_SEQ_NUM][MAX_SEQ_NUM];

int group_pair_scores_k[MAX_SEQ_NUM][MAX_SEQ_NUM];
int group_number_k;
GROUP_NODE* group_nodes_k[MAX_SEQ_NUM];
GROUP_NODE* current_parent_group_node;
int input_sequence_actual_lengths_k[MAX_SEQ_NUM];

int max_number_in_group_k;

int weight_expectation_k;
int weight_length_k;
char unique_string_k[500];

char** input_k;
char** output_k;
int sequenceCount_k;
int length_k;
int sum_upper_bound_k;
int sum_induced_sp_k;


int (*p_alignment_function)(char** input, char** output, int sequenceCount);
int (*p_group_function)(int* group_flag);

int (*p_pairwise_score_function)(int group_index1,int group_index2);
int g_sum_sw_score;

/**************************************************************************/
int alignTwoSequence_K(char sequence1[MAXLEN_K],char sequence2[MAXLEN_K]);
int getWeight_K(char a,char b);


GROUP_NODE* get_new_group_node();
void erase_group_pair_scores_k();
void set_group_pair_scores_k();
void group_k();
void align_all_groups();
void align_a_group(int group_index);
int setOptimalAlignment_k(int parent_group_index);
void setMultipleDimensionPointInArrayFromPosition_k(int pos, int dimensionPos[MAX_SEQ_NUM],int dimensionCount,int dimensionLength[MAX_SEQ_NUM]);
void setMultipleDirection(int direction, int multipleDirection[MAX_SEQ_NUM], int dimensionCount);
int getScoreOfCell_k(int multipleDimensionScore[SPACE_SIZE],int dimensionPos[MAX_SEQ_NUM],int multipleDirection[MAX_SEQ_NUM],int dimensionCount,int dimensionLength[MAX_SEQ_NUM],int* window[MAX_SEQ_NUM]);
int getPositionOfMultipleDimensionPointInArray_k(int dimensionPos[MAX_SEQ_NUM],int dimensionCount,int dimensionLength[MAX_SEQ_NUM]);
void setMultipleDirection_k(int direction, int multipleDirection[MAX_SEQ_NUM], int dimensionCount);
int set_group_column(char column[MAX_SEQ_NUM],int child_group_index,int col_pos);
int isGap_k(char letter);
int isGapColumn(char column[MAX_SEQ_NUM],int count);
int getSPScoreOfTwoColumns(char column1[MAX_SEQ_NUM],int count1,char column2[MAX_SEQ_NUM],int count2);
int alignSequences_k(char** input, char** output, int sequenceCount);
int getUpperBoundScore(char* sequence1, char* sequence2);
int getInducedSPScore(char* sequence1, char* sequence2);
void recursiveFree(GROUP_NODE* root);

void setRandom(int group_flag[MAX_SEQ_NUM]);
int align_alignment_k(char** input, char** output, int sequenceCount,int length, int max_number_in_group,int dos_flag,char* uid);
int getAlignmentSPScore_k(char** alignment,int sequencesCount,int length);


int set_group_flag_by_metis(int* group_flag);
int set_group_flag_by_div(int* group_flag);
int set_group_flag_by_random(int* group_flag);
int set_group_flag_by_length(int* group_flag);
int set_group_flag_by_min_gaps(int* group_flag);

int get_group_length_k(GROUP_NODE* group_node);
void bubbleSort_int(int numbers[], int array_size);
void bubbleSort_double(double numbers[], int array_size);

int get_weight_of_2_groups_combine_expectation_length(int group_index1,int group_index2);
void set_weight_k(int  weight_expectation_value,int weight_length_value);

int set_flag_array_by_metis_from_matrix(int* group_flag,int group_pair_scores[MAX_SEQ_NUM][MAX_SEQ_NUM]);
int get_max_length_of_group(GROUP_NODE* group_node);
int get_min_length_of_group(GROUP_NODE* group_node);
int get_weight_of_2_groups_with_gap_penalty_from_group_flag(int group_index1, int group_index2, int* group_flag);
int get_gap_penalty_k();
double get_EG_gap_score_for_2_groups(int sequence_index1, int sequence_index2,int group_index1,int group_index2,int* group_flag);
int is_single_gap_column_K(char a,char b);
int getInducedGapNumber(char* sequence1, char* sequence2);
int get_mumGap_score_for_2_groups(int group_index1,int group_index2);
int get_weight_of_2_sequences_from_group_flag(int sequence_index1, int sequence_index2, int* group_flag);
int get_max_length_of_group_index_from_group_flag(int group_index,int* group_flag);
int get_weight_gap_score_for_2_sequence_indice_k(int sequence_index1,int sequence_index2);
int get_length_of_sequence_by_index(int sequence_index);
int get_mumGap_score_for_2_seuquences(int sequence_index1,int sequence_index2);
int get_weight_of_2_groups_expectation(int group_index1,int group_index2);
int get_sum_weight_edges_k(int* group_flag);
int get_gap_weight_of_2_sequences_from_group_flag(int group_index1, int group_index2, int* group_flag);
int is_sequence_in_group(int sequence_index,GROUP_NODE* group_node);
int get_group_index_by_sequnce_index(int sequence_index);
int get_upperbound_of_2_group_nodes(GROUP_NODE* group1,GROUP_NODE* group2);
int get_induced_sp_of_2_group_nodes(GROUP_NODE* group1,GROUP_NODE* group2);
int get_weight_gap_penalty_of_2_group_nodes(GROUP_NODE* group1,GROUP_NODE* group2);
int get_pair_score_of_2_group_index_from_group_flag(int group_index1, int group_index2, int* group_flag);


//***************************************************************************************************//
//the following are the new data structures for new grouping algorithm
typedef struct group_nodes_set_k
{ 
	int node_count;
	struct group_node_k* group_nodes[MAX_SEQ_NUM];
}GROUP_NODE_SET;

int iteration_times_k;
int count_in_array_k(int group_index, int* group_flag);
int set_group_array_from_flag_array(int* group_array_to_set,int group_index, int* group_flag);
void equal_size(int* group_flag);
//***************************************************************************************************//
#endif
