#include <stdio.h>
#include <stdlib.h>

#include <string.h>
#include <ctype.h>
#include <math.h>

#include "k_group_metis.h"

int debug_k_group_metis = -1;
//********************************************************************************************//
//this program is copied from show_bali_score,                                                //
//public module for partition the node by metis                                               //
//********************************************************************************************//
int main_k_group_metis(int argc,char** argv)
{
	int k;
	int ** p_matrix;
	int i;
	int j;
	int* flag_array;
	k = 4;
	if((p_matrix=(int**) malloc((k+1)*sizeof(int*)))==NULL)
	{
		printf("unable to allocate memory.");
		exit(1);
	}

	for(i = 0; i < k+1; i ++)
	{
		if((p_matrix[i] =(int*) malloc((k+1)*sizeof(int)))==NULL)
		{
			printf("unable to allocate memory.");
			exit(1);
		}
	}
	if((flag_array=(int*) malloc((k+1)*sizeof(int)))==NULL)
	{
		printf("unable to allocate memory.");
		exit(1);
	}
	for(i = 0; i < k+1; i ++)
	{
		for(j = i; j < k+1; j ++)
		{
			p_matrix[i][j] = (i+1)*k + j+1;
			p_matrix[j][i] = p_matrix[i][j];
		}
	}

	group_k_metis(p_matrix,k,3,flag_array,1);

	for(i = 0; i < k+1; i ++)
	{
		free(p_matrix[i]);
	}
	free(p_matrix);
	return 0;

}
//******************************************************************************************//
//this function group  a flag array by calling metis,                                       //
//given weight matrix,the size of vector, the flag array for setting,dos indicate the system//
//return the number of group                                                                //
//******************************************************************************************//
int group_k_metis(int** weight_matrix, int node_count, int max_number_in_group, int* group_flag_array,int dos)
{
	int ret;
	int mod;

	weight_matrix_k_group_metis = weight_matrix;
	node_count_k_group_metis = node_count;
	max_number_in_group_k_group_metis = max_number_in_group;
	group_flag_array_k_group_metis = group_flag_array;
	dos_k_group_metis = dos;

	mod = (node_count % max_number_in_group);
	number_groups_metis = (node_count / max_number_in_group) + ((mod > 0)?1:0);
	//************************************************************************************//
	//first set weight_matrix to input format of metis                                    //
	//************************************************************************************//
	set_weight_matrix_to_input_format_of_metis();

	//************************************************************************************//
	// then create the command and execute it                                             //
	//************************************************************************************//
	create_and_execute_metis_command();
	
	//************************************************************************************//
	// then get partition result from metis                                               //
	//************************************************************************************//
	ret = set_flag_from_metis_result();

	post_precess_k_group_metis();
	return ret;
}

void post_precess_k_group_metis()
{
	remove(metis_input_file_name_k_group_metis);
	remove(metis_result_file_name_k_group_metis);
	remove(metis_partition_result_file_name_k_group_metis);
}
//************************************************************************************//
// afer running the kmetis, get the partition result                                  //
// set the flag array                                                                 //
// return the partition found                                                         //
//************************************************************************************//
int set_flag_from_metis_result()
{

	int max_group_index;
	int min_group_index;

	FILE* partitionFile;
	int i;
	int line_count;
	char line[MAXLINE+1];

	max_group_index = -1;
	min_group_index = MAXINT;

	for(i = 0; i < max_number_in_group_k_group_metis ; i ++)
	{
		group_flag_array_k_group_metis[i] = -1;
	}
	//strcpy(metis_partition_result_file_name_k_group_metis,"test.output");
	if((partitionFile=fopen(metis_partition_result_file_name_k_group_metis,"r"))==NULL)
  	{
	  	printf("Cannot open file %s\n",metis_partition_result_file_name_k_group_metis);
        exit(0);
  	}
	i = 0;
	if(debug_k_group_metis > 100)
	{
		printf("\nNow max number in group: %d\n",max_number_in_group_k_group_metis);
	}
	while (fgets(line,MAXLINE+1, partitionFile) != NULL) 
	{
		trimString(line);
		group_flag_array_k_group_metis[i] = atoi(line);
		if(debug_k_group_metis > 200)
		{
			printf("%d ",group_flag_array_k_group_metis[i]);
		}
		if(group_flag_array_k_group_metis[i] < min_group_index)
		{
			min_group_index = group_flag_array_k_group_metis[i];
		}
		i++;
	}

	fclose(partitionFile);
	if(debug_k_group_metis > 100)
	{
		printf("total has %d lines in file %s\n",(i),metis_partition_result_file_name_k_group_metis);
	}
	line_count = i;
	for(i = 0; i < line_count ; i ++)
	{
		group_flag_array_k_group_metis[i] = group_flag_array_k_group_metis[i] - min_group_index;

		if(group_flag_array_k_group_metis[i] > max_group_index)
		{
			max_group_index = group_flag_array_k_group_metis[i];
		}
	}
	if(debug_k_group_metis > 100)
	{
		printf("total set %d groups\n",(max_group_index + 1));
	}
	return (max_group_index + 1);
}
//************************************************************************************//
//first set weight_matrix to input format of metis                                    //
//the name of the created file is set                                                 //
//************************************************************************************//
void set_weight_matrix_to_input_format_of_metis()
{
	FILE *metis_file;
	int row;
	int col;
	int edge_count;
	int min_value;
	int max_value;

	sprintf(metis_input_file_name_k_group_metis,"k_group%s%d%d.metis_input",unique_string_k_group_metis,ABS((int)(&dos_k_group_metis)), ABS((int)&row));
	sprintf(metis_partition_result_file_name_k_group_metis,"%s.part.%d",metis_input_file_name_k_group_metis, number_groups_metis);

	edge_count = (node_count_k_group_metis * (node_count_k_group_metis - 1)) / 2;
	//set the file
	if((metis_file=fopen(metis_input_file_name_k_group_metis,"wt"))==NULL)
  	{
	  	printf("Cannot open file %s\n",metis_input_file_name_k_group_metis);
        exit(0);
  	}

	fprintf(metis_file,"%d %d 1\n",node_count_k_group_metis,edge_count);
	min_value = MAXINT;
	max_value = -MAXINT;

	for( row = 0; row < node_count_k_group_metis; row ++)
	{
		for( col = 0; col < node_count_k_group_metis ; col ++)
		{
			if( col == row)
			{
				continue;
			}
			
			if(min_value > weight_matrix_k_group_metis[row][col])
			{
				min_value = weight_matrix_k_group_metis[row][col];
			}
			if(max_value < weight_matrix_k_group_metis[row][col])
			{
				max_value = weight_matrix_k_group_metis[row][col];
			}

		}
		
	}
	
	for( row = 0; row < node_count_k_group_metis; row ++)
	{
		for( col = 0; col < node_count_k_group_metis ; col ++)
		{
			if( col == row)
			{
				continue;
			}
			if(min_cut_k_group_metis)
			{
				fprintf(metis_file,"%d %d ", (col+1), (weight_matrix_k_group_metis[row][col] - min_value + 1) );
			}
			else
			{
				fprintf(metis_file,"%d %d ", (col+1), (max_value - weight_matrix_k_group_metis[row][col] + 1) );
			}
		}
		fprintf(metis_file,"\n");
	}
	fclose(metis_file);
}
//************************************************************************************//
// then create a command of metis and execute it                                      //
//************************************************************************************//
void create_and_execute_metis_command()
{
	char command[400];
	
	sprintf(metis_result_file_name_k_group_metis,"k_group%s%d%d.metis_output",unique_string_k_group_metis,&dos_k_group_metis, &command);

	if(dos_k_group_metis == 1)
	{
		//sprintf(command,"kmetis %s %d > %s",
		sprintf(command,"pmetis %s %d > %s",
				metis_input_file_name_k_group_metis, number_groups_metis,
				metis_result_file_name_k_group_metis);
	}
	else
	{
		//sprintf(command,"./kmetis %s %d > %s",
		sprintf(command,"./pmetis %s %d > %s",
				metis_input_file_name_k_group_metis, number_groups_metis,
				metis_result_file_name_k_group_metis);
	}
	system(command);
}

