#ifndef INIT_WINDOW_LOCATION_H
#define INIT_WINDOW_LOCATION_H
#include "node.h"

//const
#define MAXNAMES 400
#define MAXSEQ 30

#define Boolean short
#define TRUE 1
#define FALSE 0
#define EOS '\0'

#define UP 3
#define LEFT 1
#define DIAGNAL 2

#define LOW 1
#define MEDIUM 2
#define HIGH 3

#define SHORT_L 1
#define MEDIUM_L 2
#define LONG_L 3

#define INDENTITY 1
#define BLOSUM62 2
#define GONNET250 3

#define MAX_SEQ_WITH_PATTERN 20
#define MAX_NODES_IN_PATTERN  8000
#define MAX_NODES_IN_PATTERN_FOR_CLUSTER 8000

#define MAXINT 1000000
#define MAX(a ,b) ((a) > (b)?(a) : (b))
#define MIN(a ,b) ((a) > (b)?(b) : (a))

#define WINDOW_SIZE 8
#define SPACE_SIZE 300000000
#define WINDOW_ALIGNMENT_SIZE WINDOW_SIZE*5
/**************************************************************************/
//global variables
int GOP_I = -10;
int GEP_I = 0;
int GOP_G = -10;
int GEP_G = 0;
int GOP_B  = -4;
int GEP_B  = -4;

int noGapPenaltyAtEnd = 0;
int noGapPenaltyAtBegin = 0;


int columnCount; //how many column the alignment has
int alignmentLength;
char names[MAXSEQ][MAXNAMES+1];//for read from msf file,store names
NODE* sequences[MAXSEQ][MAXLEN];
int columns[MAXSEQ][MAXLEN];//will record the position of the columns;
int alignment[MAXSEQ][MAXLEN];//will record the position of the columns;
int sequencesLength[MAXSEQ];
int matrixUsed = BLOSUM62;
NODE* sequences2[MAXSEQ][MAXLEN];//save no gap version of sequences
int sequencesLength2[MAXSEQ];

//NODE* lines[2][MAX_NODES_IN_PATTERN_FOR_CLUSTER];
int indentityScore;
int similarityCount; //use to count how many letters match.

//for multiple sequence alignment
NODE* groupNodeClusters[MAX_SEQ_WITH_PATTERN][MAX_NODES_IN_PATTERN_FOR_CLUSTER];
int groupNodeClusterLength[MAX_SEQ_WITH_PATTERN];//this indicate the length in this cluster 
int groupNodeClustersCount;
int groupNodeClusterNo[MAX_SEQ_WITH_PATTERN];//this indicate which cluster it belongs to,initial value is itself's index,
//int groupNodeArrayLength[MAX_SEQ_WITH_PATTERN];

//for anchor based
int anchorEndPos[MAXLEN];
int anchorBeginPos[MAXLEN];
int anchorsCount;
NODE* resultAlignment[MAXSEQ][MAXLEN];
int resultAlignmentLength[MAXSEQ];
NODE* window[MAXSEQ][WINDOW_SIZE];
NODE* windowAlignment[MAXSEQ][WINDOW_ALIGNMENT_SIZE];
int windowAlignmentLength;
int N = 1;//this is the one dimension array length
int gapPenalty = -4;

int windowBeginPos = 0;
int lastPositionInSequences[MAXSEQ];
Boolean windowReachEnd = FALSE;
Boolean windowAtBegin = FALSE;
int positionInWindow;
int positionInWindowAlignment;

//IMPORTANT

Boolean useReducedDirection = FALSE;
int distanceError = 0;

Boolean alignWindowUseMSA = FALSE;
//Boolean allowGapInput = FALSE;
Boolean allowGapInput = FALSE;
Boolean forInitialAlignment = FALSE;
//*************************************************************************//
char inputMsfFilename[400];
/**************************************************************************/
//				functions				  //
/**************************************************************************/

void readSequencesFromMsf(char* filename);
int countmsf(FILE *fin);
void readmsf(FILE *fin,unsigned int sequenceCount);
Boolean blankline(char *line);

void setLinks();
int alignTwoNodeSequenceArray(NODE* patternNodeArray1[],NODE* patternNodeArray2[],int count1,int count2);
int getGapExtensionPenalty();
int getGapOpenPenalty();
int getWeightOfIndentity(char letter1,char letter2);
void freeAll();
void printoutAlignmentOfTwoSequences(int index1, int index2);
void printoutScoreTable(int score[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER]);
void setAnchors();
void setColumnsSet();
void concatenateColumns();
void printResultFile(char* filename);
void printoutPairwiseAlignment();

/******************************************************************/	

int  alignTwoNodeSequenceClusters(int index1,int index2,int score[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER],short int track[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER]);
int getGroupNodeClusterCount(int index);
void setAlignmentOfTwoGroupNodeCluster(int index1,int index2,short int track[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER]);
int nodeGapPenalty = 4;
int getWeightOfGroupNodeClusterPair(int index1,int index2,int pos1,int pos2);
void addOneNode(NODE* lines[MAX_SEQ_WITH_PATTERN][MAX_NODES_IN_PATTERN_FOR_CLUSTER],int index,int clusterPos,int linePos );
void addOneGapNode(NODE* lines[MAX_SEQ_WITH_PATTERN][MAX_NODES_IN_PATTERN_FOR_CLUSTER],int pos);
int getGroupNodeClusterRowIndex(int index,int no);
NODE* getNodeFromGroupNodeClusters(int index,int pos,int no);
int multiAlignPatternsNodesArray(int blockIndex);
void initializeGroupNodeCluster(int index);
void appendBlock();
void appendAnchor(int anchorIndex);
void alignWithAnchor();
/******************************************************************/
// for anchor based
void printoutColumns();
void printResultAlignmentToResultFile(char* filename);
Boolean getConsecutiveOfColumn(int currentColumnPos);


int setInitialWindow();
int selectAColumnFromWindow();
Boolean slideWindowToNext();
void clearWindow();
int getPositionOfMultipleDimensionPointInArray(int dimensionPos[MAXSEQ],int dimensionCount,int dimensionLength[MAXSEQ]);
void setMultipleDimensionPointInArrayFromPosition(int pos, int dimensionPos[MAXSEQ],int dimensionCount,int dimensionLength[MAXSEQ]);
int getDirectionOfMultipleDirection(int multipleDirection[MAXSEQ],int dimensionCount);
void setMultipleDirection(int direction, int multipleDirection[MAXSEQ],int dimensionCount);
int getScoreOfCell(int multipleDimensionScore[SPACE_SIZE],int dimensionPos[MAXSEQ],int multipleDirection[MAXSEQ],int dimensionCount,int dimensionLength[MAXSEQ],NODE* window[MAXSEQ][WINDOW_SIZE]);
int setOptimalAlignmentFromWindow();
//*******************************************************************************//
int wholeProcess();
Boolean setInitialAlignment();
Boolean	putInitialWindow();
Boolean setOptimalAlignment();
Boolean	putBlock();
Boolean	setNextWindow();
Boolean isGap(char letter);
void printoutWindow();
void printoutWindowAlignment();
Boolean setLastRColumnsOfWindow();
Boolean setOtherPartOfWindowFromWindowAlignment();
Boolean addPartialWindowAlignmentToAlignment();
int processByFlexibleWindow();
Boolean addWindowAlignmentToAlignment();
void setGroupNodeClusterFromWindow();
void setWindowAlignmentFromGroupNodeClusters();
int getSequenceScore();
void setDimensionGroupK3(int dimensionGroup[MAXSEQ], int dimensionCount, int dimensionPos[MAXSEQ],NODE* compactWindow[MAXSEQ][WINDOW_SIZE]);
Boolean isInSameGroup(int multipleDirection[MAXSEQ], int dimensionGroup[MAXSEQ], int dimensionCount);
int setAlignmentFromWindowByLinks();
int getNodesCountInGroup(int dimensionGroup[MAXSEQ],int groupIndex);
int power(int base,int powerValue);
void setMultipleDirectionByGroup(int groupDirection,int dimensionGroup[MAXSEQ],int groupIndex,int multipleDirection[MAXSEQ],int dimensionCount);
void setDimensionGroup(int dimensionGroup[MAXSEQ], int dimensionCount, int dimensionPos[MAXSEQ],NODE* compactWindow[MAXSEQ][WINDOW_SIZE]);
int getWindowSPScore(NODE* window[MAXSEQ][WINDOW_SIZE],int sequencesCount,int length);
int getWindowAlignmentSPScore(NODE* windowAlignment[MAXSEQ][WINDOW_ALIGNMENT_SIZE],int sequencesCount,int length);
int getWindowUpperBoundScore(NODE* window[MAXSEQ][WINDOW_SIZE],int sequencesCount,int length);
int getWindowAlignmentUpperBoundScore(NODE* windowAlignment[MAXSEQ][WINDOW_ALIGNMENT_SIZE],int sequencesCount,int length);

//*******************************************************************************//
//new data structures for testing locations of window start here                 //
//*******************************************************************************//
typedef struct
{ 
	int expection_improvement_score; // this is upper bound of the window minus original sp score
	int actual_improvement_score; // this is the optimal score minus original sp score
   	//int pos; // location for the window from the original sequences 
}EXP_RECORD;

#define MAX_RUN_COUNT 2000
int g_qoma2_run_count;
int g_qoma1_run_count;
int g_qoma1_sp_score[MAX_RUN_COUNT];
int g_qoma2_sp_score[MAX_RUN_COUNT];



EXP_RECORD exp_records[MAX_RUN_COUNT];
int exp_record_count;
void initResultAlignment();
void replaceAlginment(int beginPos);
void printResultAlignment();   
Boolean	setNextWindowFromResultAlignment();
void update_exp_records();
void copy_EXP_RECORD(EXP_RECORD source, EXP_RECORD* target);
//int processByLocatedWindow();
int getResultAlignmentScore();
double getGapPercentOfWindow();
int getSequenceUpperboundScore();

//*******************************************************************************//
//new data structures for testing k groups of window start here                 //
//*******************************************************************************//
Boolean useKGroup = TRUE;

int max_number_in_group;
void setAlignmentByKGroup();

void copy_window_alignment(NODE* source[MAXSEQ][WINDOW_ALIGNMENT_SIZE],NODE* target[MAXSEQ][WINDOW_ALIGNMENT_SIZE],
						   int alignment_length);
						   
						   
//******************************************************************************//
// new data strutures for experements k clusters , 12-19-2006                   //
//******************************************************************************//
char output_file_name_main[MAXNAMES];
FILE* output_file_main;
int query_sequences_count_main; // how many sequence the file has

int max_group_number_lower_main = 2;
int max_group_number_upper_main = 4;

#define LINUX_MAIN 0
int dos_init = !LINUX_MAIN;
#if LINUX_MAIN
	struct timeval tv_main;
#endif


//******************************************************************************//
// new data strutures for dynymic select location for window , 01-22-2007       //
//******************************************************************************//
EXP_RECORD exp_records_bak[MAX_RUN_COUNT];
int exp_record_count_bak;

int g_M = 12;
int g_a;
int g_b;
int g_exp_array[MAX_RUN_COUNT];
int tau = 2;

int g_qoma2_opt_run_count;
int g_qoma2_sp_score_opt[MAX_RUN_COUNT];

int g_location_flag[MAX_RUN_COUNT];
int processByLocatedWindow_greedy();
int processByLocatedWindow_DP();
void update_g_location_flag();
void set_exp_records();
void bak_exp_records();
void restore_exp_records();
#endif
