#include <stdio.h>
#include <stdlib.h>

#include <string.h>
#include <ctype.h>
#include <math.h>
#include <time.h>

#include "node.h"
#include "common.h"
#include "init_window_location.h"
#include "msa_k.h"
#include "k_group_metis.h"
//*************************************************************************************//
//this program is to test where to put the initial window on the initial alignment     //
//*************************************************************************************//

int debug = 0;
int start_detail_debug = 0;
int set_link = 0;
int testing_higher = 0;

//******************************************************************************************//
//the main function                                                                         //
//the parameter 1: the input file of sequences, in msf format, it is the initial alignment  //
//the parameter 2: the result alignment file name, the alignment is from qoma1: sliding window //
//the parameter 3: the maximum node allowed in each group                                   //
//the parameter 4: the output file name                                                     //
//the  parameter 5: the M                                                                   //
//******************************************************************************************//

int main(int argc,char** argv)
{

	char resultAlignmentFileNameQoma1[MAXNAMES];
	char resultFileNameForSPLine[MAXNAMES];
	int score;
	int q1;
	int q2;
	int q3;
	int i;
	FILE *fp;
	//****************************************************************//
	if(0) //this part is to output the g_b
	{
		debug = -10;
		strcpy(inputMsfFilename,argv[1]);
		matrixUsed = BLOSUM62;
		setInitialAlignment();
		set_exp_records();
			//bak_exp_records();
			g_a = exp_record_count;
			g_b = g_M;
		if(g_b >= g_a /( 2*tau + 1 ))
			{
				g_b = g_a /( 2*tau + 1 ) - 1;
			}
		printf("%d\n",g_b);
		exit(0);
	}
		//**************************************************************//
	// read file names
	strcpy(inputMsfFilename,argv[1]);
	strcpy(resultAlignmentFileNameQoma1,argv[2]);
	max_number_in_group = atoi(argv[3]);
	strcpy(output_file_name_main,argv[4]);
	if(argc > 5)
	{
		g_M = atoi(argv[5]);
	}
	//***************************************************************//

	//***************************************************************//
	
	if((output_file_main=fopen(output_file_name_main,"wt"))==NULL)  
	{  
		printf("Cannot open file strike any key exit!");  
		exit(1);  
	}
#if LINUX_MAIN
	gettimeofday( &tv_main, NULL );

	fprintf(output_file_main,"start_second=%ld\n",tv_main.tv_sec);
	fprintf(output_file_main,"start_uSecond=%ld\n",tv_main.tv_usec);
#endif
	matrixUsed = BLOSUM62;
	setInitialAlignment();
	if((sequencesLength[0]) >=1500)
	{
		fprintf(output_file_main,"too long =%d\n",sequencesLength[0]);
		exit(0);
	}

	fprintf(output_file_main,"sequence_count=%d\n",query_sequences_count_main);
	fprintf(output_file_main,"max_number_in_group=%d\n",max_number_in_group);
	
	//**************************************************************//
	//for showing upper bound of the input sequences
	score = getSequenceUpperboundScore();
	fprintf(output_file_main,"upperbound_score=%d\n",score);

	//**************************************************************//
	score = getSequenceScore();
	fprintf(output_file_main,"sp_score_before_alignment=%d\n",score);
	
	for(i = 0; i < g_M + 1; i ++)
	{
		g_qoma1_sp_score[i] = 0;
		g_qoma2_sp_score[i] = 0;
		g_qoma2_sp_score_opt[i] = 0;
	}

	g_qoma1_sp_score[0] = score;
	g_qoma2_sp_score[0] = score;
	g_qoma2_sp_score_opt[0] = score;

	g_qoma1_run_count = 1;
	g_qoma2_run_count = 1;
	g_qoma2_opt_run_count = 1;

	q1 = 1;
	q2 = 1;
	q3 = 1;

	
	//***************************************************************//
	//qoma 1 : use sliding window                                    //
	//***************************************************************//
	
		if((q2) || (q3))
		{
			set_exp_records();
			bak_exp_records();
			g_a = exp_record_count;
		}
		else
		{
			g_a = sequencesLength[0];
		}


	if(g_M >= g_a /( 2*tau + 1 ))
	{
		exit(0);
	}

	i = 1;
	while( i < g_M )
	{
		g_b = i;
		//g_b = g_M;
		if((q2) || (q3))
		{
			if(g_b >= g_a /( 2*tau + 1 ))
			{
				g_b = g_a /( 2*tau + 1 ) - 1;
			}
		}
		
		printf("run g_b = %d\n",g_b);
		fflush(stdout);

		g_qoma1_run_count = 0;
		g_qoma2_run_count = 0;
		g_qoma2_opt_run_count = 0;
		if(q1)
		{
			processByFlexibleWindow();
			score = getResultAlignmentScore();
			fprintf(output_file_main,"sp_score_q1_after=%d\n",score);
			g_qoma1_sp_score[g_b] = score;
			printResultAlignmentToResultFile(resultAlignmentFileNameQoma1);	
		}
		//***************************************************************//
		//qoma 2 : use selected window greedy                            //
		//***************************************************************//
		//g_qoma1_run_count = 30;
		if(q2)
		{
			restore_exp_records();
			processByLocatedWindow_greedy();
			score = getResultAlignmentScore();
			fprintf(output_file_main,"sp_score_q2_after=%d\n",score);
			g_qoma2_sp_score[g_b] = score;
		}
		//***************************************************************//
		//qoma 3 : use selected window d p                               //
		//***************************************************************//
		//g_qoma1_run_count = 30;
		if(q3)
		{
			restore_exp_records();
			processByLocatedWindow_DP();
			score = getResultAlignmentScore();
			fprintf(output_file_main,"sp_score_q3_after=%d\n",score);
			g_qoma2_sp_score_opt[g_b] = score;
		}
		i ++;
	}
	printResultAlignmentToResultFile(resultAlignmentFileNameQoma1);
	
	fprintf(output_file_main,"sp_score_after=%d\n",score);

#if LINUX_MAIN
	gettimeofday( &tv_main, NULL );

	fprintf(output_file_main,"end_second=%ld\n",tv_main.tv_sec);
	fprintf(output_file_main,"end_uSecond=%ld\n",tv_main.tv_usec);
#endif
	//***************************************************************//
	fclose(output_file_main);
	
	//***************************************************************//
	//print out the two columns of sp scores for drawing lines       //
	/***************************************************************/
	if((q1) || (q2) || (q3))
	{
		sprintf(resultFileNameForSPLine,"%s.line",output_file_name_main);
		if((fp=fopen(resultFileNameForSPLine,"wt"))==NULL)  
		{  
			printf("Cannot open file strike any key exit!");  
			exit(1);  
		}
		//write file
		/*
		for(i = 0; i < g_qoma1_run_count; i ++)
		{
			if(i >= g_qoma2_run_count)
			{
				score = g_qoma2_sp_score[g_qoma2_run_count-1];
			}
			else
			{
				score = g_qoma2_sp_score[i];
			}
			fprintf(fp,"%d \t %d \t %d\n",(i+1), score,g_qoma1_sp_score[i]);
		}
		*/
		if(q1)
		{
			fprintf(fp,"Q1:\t");
			for(i = 0; i < g_M; i ++)
			{
				fprintf(fp,"%d \t", g_qoma1_sp_score[i]);
			}
			fprintf(fp,"\n");
		}
		if(q2)
		{
			fprintf(fp,"Q2:\t");
			for(i = 0; i < g_M; i ++)
			{
				fprintf(fp,"%d \t", g_qoma2_sp_score[i]);
			}
			fprintf(fp,"\n");
		}
		if(q3)
		{
			fprintf(fp,"Q3:\t");
			for(i = 0; i < g_M; i ++)
			{
				fprintf(fp,"%d \t", g_qoma2_sp_score_opt[i]);
			}
			fprintf(fp,"\n");
		}
		fclose(fp);
	}
	//***************************************************************/
	//free all memory allocated                                      //
	//***************************************************************//
	freeAll();
	return 0;
}

void readSequencesFromMsf(char* filename)
{
	FILE *ifd;
  	if((ifd=fopen(filename,"r"))==NULL)
  	{
	  	fprintf(stderr,"Cannot open reference aln file [%s]",filename);
        exit(0);
  	}
        /* read the reference alignment into refnames,refseq_array,refseqlength */
    query_sequences_count_main = countmsf(ifd);

  	if(query_sequences_count_main == 0) 
  	{
		fprintf(stderr,"Error: no sequences in %s\n",filename);
		exit(0);
	}
	readmsf(ifd,query_sequences_count_main);
}	
int countmsf(FILE *fin)
{
/* count the number of sequences in a PILEUP alignment file */

        char line[MAXLINE+1];
        int  lnseqs;
		int len;

        while (fgets(line,MAXLINE+1,fin) != NULL) {
			if((strstr(line,"MSF:")) && (strstr(line,"Type:")) && (strstr(line,"Check:")) )
			{
				sscanf(line,"   MSF: %d  T",&len);
				if((len > MAXLEN) || (len > MAXLINE))
				{
					exit(0);
				}
			}
                if(line[0]=='/' && line[1]=='/') break;
        }

        while (fgets(line,MAXLINE+1,fin) != NULL) {
                if(!blankline(line)) break;             /* Look for next non- */
        }                                               /* blank line */
        lnseqs = 1;

        while (fgets(line,MAXLINE+1,fin) != NULL) {
                if(blankline(line)) return lnseqs;
                lnseqs++;
        }

        return 0; /* if you got to here-funny format/no seqs.*/
}
void readmsf(FILE *fin,unsigned int query_sequences_count_main)
{
	char line[MAXLINE+1];
    unsigned int len,seqno, i,j,k;
	unsigned char c;
	NODE* node;
	
	int indexWithGap;
	int indexWithoutGap;

	for(seqno=0;seqno<query_sequences_count_main;seqno++)
	{

        	fseek(fin,0,0);                 /* start at the beginning */

        	len=0;                         /* initialise length to zero */
        	for(i=0;;i++) 
        	{
               	if(fgets(line,MAXLINE+1,fin)==NULL) return; /* read the title*/
                if(line[0]=='/' && line[1]=='/') break;
 
        	}
			indexWithGap = -1;
			indexWithoutGap = -1;
        	while (fgets(line,MAXLINE+1,fin) != NULL) 
        	{
                	if(!blankline(line)) 
                	{
	                        for(i=0;i<seqno;i++) fgets(line,MAXLINE+1,fin);
                      		for(j=0;j<=strlen(line);j++) if(line[j] != ' ') break;
                        	for(k=j;k<=strlen(line);k++) if(line[k] == ' ') break;
                        	strncpy(names[seqno],line+j,k-j);
                        	names[seqno][k-j]='\0';
                       		names[seqno][MAXNAMES]='\0';
                       		//printf("%s\n",names[seqno]);
							
                        	for(i=k;i<=MAXLINE;i++) 
                        	{
                                	c=line[i];
                                	if(c == '.' || c == '~' ) c = '-';
                                	if(c == '*') c = '-';
                                	if(c == '\n' || c == EOS) break; /* EOL */
                                	if(isalpha(c) || c=='-') indexWithGap ++;
									if(isalpha(c)&&(!( c=='-'))) indexWithoutGap ++;
									
                                	if((isalpha(c))||((c=='-')&&(allowGapInput)))
									{
										node = getNewNode(c);
									
										node->indexWithGap = indexWithGap;
										node->indexWithoutGap = indexWithoutGap;

										node->sequenceNo = seqno;
										sequences[seqno][len++] = node;
									}
                        	}

                        	for(i=0;;i++) 
                        	{
                                	if(fgets(line,MAXLINE+1,fin)==NULL) break;
                                	if(blankline(line)) break;
                        	}
                	}
        	}
		sequencesLength[seqno] = len;
		for(;len<MAXLEN;len++)
			sequences[seqno][len]=0;
	}
}
Boolean blankline(char *line)
//check if this is blank line or not
{
	int i;

        for(i=0;line[i]!='\n' && line[i]!=EOS;i++) {
                if( isdigit(line[i]) ||
                    isspace(line[i]) ||
                    (line[i] == '*') ||
                    (line[i] == ':') ||
                    (line[i] == '.'))
                        ;
                else
                        return FALSE;
        }
        return TRUE;
}
int getGapOpenPenalty()
{
	if(matrixUsed == INDENTITY)
	{
		return GOP_I;
	}
	else if(matrixUsed == GONNET250)
	{
		return GOP_G;
	}
	else
	{
		return GOP_B;
	}

}
int getGapExtensionPenalty()
{
	if(matrixUsed == INDENTITY)
	{
		return GEP_I;
	}
	else if(matrixUsed == GONNET250)
	{
		return GEP_G;
	}
	else
	{
		return GEP_B;
	}
}
int getWeight(char a,char b) 
{ 
	return getWeightBLOSUM62(a,b);
}
int getWeightOfDefault(char a,char b)
//this is for gon250mt
{ 
	return getWeightGON250(a,b);
}
int getWeightOfIndentity(char letter1,char letter2)
{

	letter1 = toUpperCase(letter1);
	letter2 = toUpperCase(letter2);
	if(letter1 == letter2)
	{
		return indentityScore;
	}
	else
	{
		return 0;
	}
}

int getRoughScoreOfTwoNodes(NODE* node1,NODE* node2)
{

	int basicScore;

	int totalScore;
	char letter1,letter2;

	if(!node1)
	{
		letter1 = '*';
	}
	else
	{
		letter1 = node1->letter;
	}

	if(!node2)
	{
		letter2 = '*';
	}
	else
	{
		letter2 = node2->letter;
	}

	totalScore = 0;
	if(
		(!(isalpha(letter1))) 
		&& 
		(!(isalpha(letter2)))
		)
	{
		return 0;
	}
	if(matrixUsed == INDENTITY )
	{
		basicScore = getWeightOfIndentity(letter1 ,letter2);
	}
	else if(matrixUsed == BLOSUM62)
	{
		basicScore = getWeight(letter1 ,letter2);
	}
	else
	{
		basicScore = getWeightOfDefault(letter1 ,letter2);
	}
	
	
	//totalScore = typeScore + basicScore + groupScore + globalScore ;
	totalScore = basicScore;
	return totalScore;
}

int alignTwoNodeSequenceArray(NODE* nodeArray1[],NODE* nodeArray2[],int count1,int count2)
//use count1 and count2 to control
{
    int rowLength;
    int colLength;
	//int scoreE[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER];//col
	//int scoreV[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER];//current
	//int scoreF[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER];//row
	//int scoreG[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER];//diagnal
	//int track[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER];
	

	int** scoreV;//current
	int scoreE;
	int scoreG;
	int scoreF;
	int** track;

	int i,j;
	int row = 0;
    int col = 0;
    int above = 0;
    int proceeding = 0;
    int diagnal =0;
    //char a,b;
	NODE* node1;
	NODE* node2;
	int maxInColumn ;
	int maxInRow ;
	int maxInColumnPos;
	int maxInRowPos;
	int gapOpenPenalty;
	int gapExtensionPenalty;
	int alignmentScore;
	int pos1;
	int pos2;
	int weight;

    // initialize
	//add on 07/07/2005

	if ((count1 ==0) ||(count2 ==0))
	{
		//return 0;
		
		gapExtensionPenalty = getGapExtensionPenalty();
		if( count1 > 0)
		{
			return (gapExtensionPenalty * count1);
		}
		else
		{
			return (gapExtensionPenalty * count2);
		}

	}
	similarityCount = 0;

	rowLength = count1 + 1;

	colLength = count2 + 1;
	
	
	
	if((scoreV=(int **) malloc((rowLength+1)*sizeof(int*)))==NULL)
	//add 1 to prevent overflow
	{
		fprintf(stderr,"unable to allocate memory.");
		exit(1);
	}
	
	if((track=(int **) malloc((rowLength+1)*sizeof(int*)))==NULL)
	//add 1 to prevent overflow
	{
		fprintf(stderr,"unable to allocate memory.");
		exit(1);
	}
	for (i = 0; i< rowLength+1;i++)
	{
		
		if((scoreV[i]=(int *) malloc((colLength+1)*sizeof(int)))==NULL)
		//add 1 to prevent overflow
		{
			fprintf(stderr,"unable to allocate memory.");
			exit(1);
		}
		
		if((track[i]=(int *) malloc((colLength+1)*sizeof(int)))==NULL)
		//add 1 to prevent overflow
		{
			fprintf(stderr,"unable to allocate memory.");
			exit(1);
		}
	}

    for (i = 0; i< rowLength+1;i++)
	{
	
		scoreV[i][0]=0;
		
		track[i][0]=0;
	}
	for(j = 0; j< colLength +1;j++)
	{
		
		scoreV[0][j]=0;
		
		track[0][j]=0;
	}
	//E(i, 0) = gap_open + i x gap_extend
	//E(i,j) = max{E(i, j-1) + gap_extend,
                  //    V(i-1, j-1) + gap_open + gap_extend}

	//F(0, j) = gap_open + j x gap_extend

	//F(i,j) = max{F(i-1, j) + gap_extend,
                  //    V(i-1, j-1) + gap_open + gap_extend}

	//G(i,j) = G(i-1, j-1) + s(x(i), y(j))

	gapExtensionPenalty = getGapExtensionPenalty();
	gapOpenPenalty = getGapOpenPenalty();

    if(noGapPenaltyAtBegin)
	{
		//do nothing
	}
	else
	{
		for (i = 1; i< colLength;i++)
		{
			
			scoreV[0][i] = gapOpenPenalty + (i-1) * gapExtensionPenalty;
		
		}
		for (i = 1; i< rowLength;i++)
		{
			
			scoreV[i][0] = gapOpenPenalty + (i-1) * gapExtensionPenalty;
			
		}
		
		scoreV[0][0] = 0;
		
	}
    track[0][0] = 0;
	for (i = 1; i< rowLength;i++)
		track[i][0] = UP;
    for (j = 1; j< colLength;j++)
        track[0][j] = LEFT;
    //begin to calculate

	for (row = 1; row < rowLength;row ++)
    {
		for (col = 1; col < colLength; col ++)
		{
         // compute the maximum one
			node1 = nodeArray1[row - 1];
			node2 = nodeArray2[col - 1];

			
			scoreE = MAX(scoreV[row][col-1]+gapExtensionPenalty,scoreV[row][col-1] + gapOpenPenalty);
			scoreF = MAX(scoreV[row-1][col]+gapExtensionPenalty,scoreV[row-1][col] + gapOpenPenalty);
			
			scoreG = scoreV[row-1][col-1]+getRoughScoreOfTwoNodes(node1,node2);
			
			if(scoreF >= scoreE)
			{
				if(scoreF >= scoreG)
				{
					scoreV[row][col] = scoreF; //scoreF[row][col] is max;
					track[row][col] = UP;
				}
				else
				{
					scoreV[row][col] = scoreG; //scoreG[row][col] is max;
					track[row][col] = DIAGNAL;
				}
			}
			else
			{
				if(scoreE >= scoreG)
				{
					scoreV[row][col] = scoreE; //scoreE[row][col] is max;
					track[row][col] = LEFT;
				}
				else
				{
					scoreV[row][col] = scoreG; //scoreG[row][col] is max;
					track[row][col] = DIAGNAL;
				}
			}//if else

      }//for col
    }//for row

	//after alignment score matrix set, here need to track back
	alignmentScore = scoreV[rowLength-1][colLength-1];
	if(noGapPenaltyAtEnd)
	{
		maxInColumn = -MAXINT;
		maxInRow = -MAXINT;
	
		//here try to trace the max one in row and col
		//check the last column 
		for(i = rowLength -1 ; i > 0; i--)
		{
			if((scoreV[i][colLength-1] >= maxInColumn)&&
				((track[i][colLength-1]==LEFT)||(track[i][colLength-1]==DIAGNAL)))
			{
				maxInColumn = scoreV[i][colLength-1];
				maxInColumnPos = i;
			}
		}
		//chech the last row
		for(i = colLength -1; i > 0; i--)
		{
			if((scoreV[rowLength-1][i] >= maxInRow)&&
				((track[rowLength-1][i]==UP)||(track[rowLength-1][i]==DIAGNAL)))
			{
				maxInRow = scoreV[rowLength-1][i];
				maxInRowPos = i;
			}
		}
		if((maxInRow == -MAXINT)&&(maxInColumn == -MAXINT))
		{
			//do nothing
			alignmentScore = scoreV[rowLength-1][colLength-1];
		}
		else if(maxInRow < maxInColumn)
		{
			//force to track back from col
			//set to 3,go above
			for(i = maxInColumnPos +1; i < rowLength; i ++)
			{
				track[i][colLength-1] = UP;
			}
			alignmentScore =  maxInColumn;
		}
		else
		{
			//set to 1
			for(i = maxInRowPos + 1; i < colLength; i ++)
			{
				track[rowLength - 1][i]=LEFT;
			}

			alignmentScore =  maxInRow;
		}
	}//if nogap
	//here actual track back
		//printoutScoreTable(scoreE);
		//printoutScoreTable(scoreF);
		//printoutScoreTable(scoreG);
		//printoutScoreTable(scoreV);
		//printoutScoreTable(track);
	/****************************************************************************************/

	pos1 = 0;
	pos2 = 0;
	row = rowLength - 1;
	col = colLength - 1;

    while((row>0) || (col>0))
    {
		if(track[row][col]==LEFT)
		{
			//lines[0][pos1++] = 0;
		
			//lines[1][pos2++] = nodeArray2[col -1];
			col --;
		
		}
		else if(track[row][col]==DIAGNAL)
		{
			//since match link two nodes with an edge
			if((!nodeArray1[row - 1])||(!nodeArray2[col - 1]))
			{
				row --;
				col --;
				continue;
			}
			if( set_link)
			{
				nodeArray1[row - 1]->edgePos[(nodeArray2[col-1]->sequenceNo)] = col-1;
				nodeArray2[col - 1]->edgePos[(nodeArray1[row-1]->sequenceNo)] = row-1;
				weight = getRoughScoreOfTwoNodes(nodeArray1[row - 1],nodeArray2[col - 1]);
				nodeArray1[row - 1]->edgeWeights[(nodeArray2[col-1]->sequenceNo)] = weight;
				nodeArray2[col - 1]->edgeWeights[(nodeArray1[row-1]->sequenceNo)] = weight;
				nodeArray1[row - 1]->edgeCount ++;
				nodeArray2[col - 1]->edgeCount ++;
				
				nodeArray1[row - 1]->totalWeight += weight;
				nodeArray2[col - 1]->totalWeight += weight;
			}
			//add on 07/07/2005
			similarityCount ++;
			//*************************************
			//lines[0][pos1++] = nodeArray1[row -1];
			row --;
			//lines[1][pos2++] = nodeArray2[col -1];
			col --;
		}
		else if(track[row][col]==UP)
		{
			//lines[0][pos1++] = nodeArray1[row -1];
			row --;
			//lines[1][pos2++] = 0;
			
		}
		else if(track[row][col]==0)
		{
			if(row > 0)
			{
				//lines[0][pos1++] = nodeArray1[row-1];
				row --;
				//lines[1][pos2++] = 0;
			}
			else
			{
				//lines[0][pos1++] = 0;
				//lines[1][pos2++] = nodeArray2[col-1];
				col --;
			}
		}
		else
		{
			break;
		}
	}//while
	/*
	for(i = pos1; i < MAX_NODES_IN_PATTERN_FOR_CLUSTER;i ++)
		lines[0][i]=0; 
	for(i = pos2; i < MAX_NODES_IN_PATTERN_FOR_CLUSTER;i ++)
		lines[1][i]=0; 
	*/
	for (i = 0; i< rowLength+1;i++)
	{
		
		free(scoreV[i]);
		
		free(track[i]);
	}

	free(scoreV);
	
	free(track);
	return alignmentScore;
}
void printoutScoreTable(int score[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER])
{
	int i;
	int j;
	for(i = 0; i < 10; i ++)
	{
		for(j = 0; j < 10; j ++)
		{
			printf("%d\t",score[i][j]);
		}
		printf("\n");
	}
}
void printoutWindow()
{
	int i;
	int j;
	
	printf("BEGIN AT %d\n",windowBeginPos);
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		for(j = 0; j < WINDOW_SIZE; j ++)
		{
			if(window[i][j])
			{
				printf("%c\t",window[i][j]->letter );
			}
			else
			{
				printf("*\t");
			}
		}
		printf("\n");
	}
	printf("\n");
}
void printoutWindowAlignment()
{
	int i;
	int j;
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		for(j = 0; j < windowAlignmentLength; j ++)
		{
			if(windowAlignment[i][j])
			{
				
				printf("%c\t",windowAlignment[i][j]->letter);
			}
			else
			{
				printf("-\t");
			}
		}
		printf("\n");
	}
	printf("\n");
	printf("\n");

}
void setLinks()
{
	int i;
	int j;
	int totalScore;
	int score;
	totalScore = 0;
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		for(j = i + 1; j < query_sequences_count_main; j ++)
		{
			score = alignTwoNodeSequenceArray(sequences[i],sequences[j],sequencesLength[i],sequencesLength[j]);
			totalScore += score;
			//printf("i= %d,j= %d,score = %d\n",i,j,score);
			//printoutAlignmentOfTwoSequences(i,j);
		}
	}
	if(debug > 4)
	{
		printf("TotalScore (upper bound) = %d\n",totalScore);
	}
}
void printoutPairwiseAlignment()
{
	int i;
	int j;
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		for(j = i + 1; j < query_sequences_count_main; j ++)
		{
			printf("i= %d,j= %d\n",i,j);
			printoutAlignmentOfTwoSequences(i,j);
		}
	}
}
void printoutAlignmentOfTwoSequences(int index1, int index2)
//this is called to debug, print out the alignment of two sequences
//which have been aligned
{
	
	int i;
	int pos1,pos2;//original sequence pos
	int line1Pos,line2Pos;//pos in line1, line2
	NODE* node1;
	NODE* node2;
	NODE* line1[MAXLEN];
	NODE* line2[MAXLEN];
	pos1 = 0;
	pos2 = 0;
	line1Pos = 0;
	line2Pos = 0;
	for( i = 0; i < MAXLEN; i ++)
	{
		line1[i] = 0;
		line2[i] = 0;
	}
	while((pos1 < sequencesLength[index1])
			||(pos2 < sequencesLength[index2]))
	{
		node1 = sequences[index1][pos1];
		node2 = sequences[index2][pos2];
		if((node1->edgePos[index2] > -1)&&(node2->edgePos[index1] > -1))
			//match
		{
			line1[line1Pos++] = node1;
			line2[line2Pos++] = node2;
			pos1++;
			pos2++;
		}
		else if (node1->edgePos[index2] > -1)
		{
			line2[line2Pos++] = node2;
			line1Pos++;
			pos2 ++;
		}
		else if (node2->edgePos[index1] > -1)
		{
			line1[line1Pos++] = node1;
			pos1 ++;
			line2Pos ++;
		}
		else
		{
			break;
		}
		if( pos1 == sequencesLength[index1])
		{
			while(pos2 < sequencesLength[index2])
			{
				line2[line2Pos++] = sequences[index2][pos2++];
			}
		}
		if( pos2 == sequencesLength[index2])
		{
			while(pos1 < sequencesLength[index1])
			{
				line1[line1Pos++] = sequences[index1][pos1++];
			}
		}
	}
	for( i = 0; i < line1Pos; i ++)
	{
		if(line1[i])
		{
			printf("%c",line1[i]->letter);
		}
		else
		{
			printf(".");
		}
	}
	printf("\n");
	for( i = 0; i < line2Pos; i ++)
	{
		if(line2[i])
		{
			printf("%c",line2[i]->letter);
		}
		else
		{
			printf(".");
		}
	}
	printf("\n");
}
void freeAll()
{
	int i;
	int j;
	for( i = 0; i < MAXSEQ; i ++)
	{
		for( j = 0; j < MAXLEN; j ++)
		{
			if(sequences[i][j])
			{
				free(sequences[i][j]);
			}
		}
	
	}
}
void sortNodes()
//after setting edge weight for each node, now sort them 
//by their weight to make the search faster later 
{
	//sort order:#edges,total weight
	int i;
	int j;
	for( i = 0; i < MAXSEQ; i ++)
	{
		for( j = 0; j < MAXLEN; j ++)
		{
			if(sequences[i][j])
			{
				printf("%d ",sequences[i][j]->edgeCount);
			}
		}
		printf("\n");
	}
}
void setAnchors()
//this function scans the consecutiveArray,set the array of anchorBeginPos and anchorEndPos
{

	int countInBlock;
	int currentColumnPos;

	short int end;
	int beginPos;

	currentColumnPos = 0;
	end = FALSE;
	
	while(currentColumnPos + 1 < columnCount)
	{
		countInBlock = 0;
		//first get consecutive information
		//set consecutive
	
		//now check the block
		beginPos = -1;
		while((getConsecutiveOfColumn(currentColumnPos))&&(currentColumnPos +1 < columnCount ))
		{
				countInBlock ++;
			
				if(beginPos < 0)
				{
					beginPos = currentColumnPos;
				}
				currentColumnPos ++;	
		}
		
		if(countInBlock > 3)
			//this 3 is a threshold
		{
			anchorBeginPos[anchorsCount] = beginPos;
			anchorEndPos[anchorsCount] = currentColumnPos;
			anchorsCount ++;
		}//while

		currentColumnPos ++;
	}
	//this is for debug
	printf("totally have %d anchors.",anchorsCount);

}
void setColumnsSet()
//it should be called after pair-wise alignment
//1. initialize the candicate node set
//2. get the node with max edges number in the candicate set
//  if (no such node)
//		{go ahead, set next candicate set , based on current set}
//	else
//		{from that node, set a column, add to existing column set
//			set next candicate set, base on current set}
{
	int pos[MAX_SEQ_WITH_PATTERN];
		//this array indicates the pos of the candicate set in sequence array
	int lastPos[MAX_SEQ_WITH_PATTERN];
		//this array indicates the last position the successfully gotten column
	int i;
	int j;
	int reachedEnd;
	NODE* node;
	int allGood;
	int goodPos;
//	int minDistanceFromLast;
//	int distanceFromLast;
	int maxEdgeNumber;
	int maxTotalWeight;
	

	//initialize the candicate node set
	columnCount = 0;

	for( i = 0; i < query_sequences_count_main; i ++)
	{
		pos[i] = 0;
		lastPos[i] = -2;
	}
	//loop
	reachedEnd = FALSE;
	while(!reachedEnd)
	{
		//try to find a node that have max edges number
		//here is the new algorithm, modified on 07/04/2005
	
		goodPos = -1;
		//minDistanceFromLast  = MAXINT;
		maxTotalWeight = -1;
		for( i = 0; i < query_sequences_count_main; i ++)
		{
			node = sequences[i][pos[i]];
			//two conditions needed to be satisfied
			//1. max edge number
			//2. all edge end nodes are after the last pos
			//check them one by one 
			//select the one with max tatalWeight
			maxEdgeNumber = FALSE;
			//check it has max edge number?
			if(node)
			{
				if(node->edgeCount == query_sequences_count_main - 1)
				{
					maxEdgeNumber = TRUE;
				}
				else
				{
					continue;
				}
			}
			else
			{
				continue;
			}
			
			//yes, it has max edge number
			
			//check if all edges end nodes are after the last pos
			allGood = TRUE;
			
			//calculate the distance from last pos
			//for each candicate set
			//initial value
			//distanceFromLast = pos[i] - lastPos[i];
			for( j = 0; j < query_sequences_count_main; j ++)
			{
				if (node->sequenceNo == j)
					continue;
				if( node->edgePos[j] <= lastPos[j])
						//not good for column
				{
					allGood = FALSE;
					break;
				}
				else
				{
					//distanceFromLast += node->edgePos[j] - lastPos[j];
				}
			}
			//after cheching the distance and not crossing last column
			//need to check result
			//if((allGood)&&(distanceFromLast < minDistanceFromLast))
			if(allGood)
			{
				if(node->totalWeight > maxTotalWeight)
				{
					goodPos = i;
					//minDistanceFromLast = distanceFromLast;
					maxTotalWeight =  node->totalWeight;
				}
			}
			else 
			{
				if(!allGood)
				{
					continue;
				}
			}
			//all passed, need to set pos
			
		}//for to check the good pos

		//after looking for good pos from candicate set
		//check result
		if(goodPos >= 0)
		{
			
			//prepare to set new column
			node = sequences[goodPos][pos[goodPos]];
			//printf("set column from node :(%d,%c) at pos %d\n",node->sequenceNo,node->letter ,columnCount);
			
			for( i = 0; i < query_sequences_count_main; i ++)
			{
				columns[i][columnCount] = node->edgePos[i];
			}
			columns[node->sequenceNo][columnCount] = pos[node->sequenceNo];

			//for( i = 0; i < query_sequences_count_main; i ++)
			//{
			//	printf("%c",sequences[i][columns[i][columnCount]]->letter );
			//}
			//printf("\n");
			columnCount ++;
			
			//set next candicate set
			//add on 07/07/2005
			
			//will be current column set increase by one
			
			for( i = 0; i < query_sequences_count_main; i ++)
			{
				lastPos[i] = columns[i][columnCount-1];
				pos[i] = lastPos[i]+1 ;
			}
			//check reach End?
			for( i = 0; i < query_sequences_count_main; i ++)
			{
				if(pos[i]+1 >= sequencesLength[i])
				{
					reachedEnd = TRUE;
				}
			}
		}//add a column
		else
		{
			//{go ahead, set next candicate set , based on current set}
			for( i = 0; i < query_sequences_count_main; i ++)
			{
				lastPos[i] = pos[i]++;
			}
			//check reach End?
			for( i = 0; i < query_sequences_count_main; i ++)
			{
				if(pos[i]+1 >= sequencesLength[i])
				{
					reachedEnd = TRUE;
				}
			}
		}//else
	}//while
}
void setColumnsSetByWindow(int windowSize)
//it should be called after pair-wise alignment
//1. initialize the candicate node set in the initial window
//2. For each window
//   2.1 get the optimal multiple alignment by dynamic programming
//	 2.2 select a highest score column from this window
//	 2.3 slide the window to next position 
{
	Boolean notDone;

	columnCount = 0;
	clearWindow();
	if(setInitialWindow()==-1)
		return;
	notDone = TRUE;
	while(notDone)
	{
		if(!selectAColumnFromWindow())
			break;
		notDone = setNextWindow();
	}
}
int selectAColumnFromWindow()
//this is to set a column to columns array
//increase the columnCount in the meanwhile
//this column is selected from the window array
//using the MSA algorithm to find the optimal alignment
//then select the column
{
	int i;
	int j;
	Boolean found;
	int begin;
	int pos;
	NODE* node;

	setOptimalAlignmentFromWindow();
	//check result to get a column
	for ( i = 0; i < windowAlignmentLength; i ++)
	{
		found = TRUE;
		for ( j = 0; j < query_sequences_count_main; j ++)
		{ 
			found = found && windowAlignment[j][i];
		}
		if(found)
		{
			break;
		}
	}
	if(!found)
		return 0;
	//set column
	for ( j = 0; j < query_sequences_count_main; j ++)
	{ 
		begin = columns[j][columnCount - 1];
		node = sequences[j][begin];
		pos  = begin + 1;
		while(node != sequences[j][pos])
		{
			pos++;
		}
		columns[j][columnCount] = pos;
	}
	
	return 1;
}
//use k group to align a window
void setAlignmentByKGroup()
{
	//first initialize 
	char** input;
	char** output;
    // initialize
	int i;
	int j;

	int letter_index_window = 0;
	int letter_index_alignment = 0;

	if((input =(char **) malloc((query_sequences_count_main)*sizeof(char*)))==NULL)
	{
		printf("unable to allocate memory.");
		exit(1);
	}
	for( i = 0; i < query_sequences_count_main; i ++)
	{
		if((input[i]=(char *) malloc((WINDOW_SIZE + 1)*sizeof(char)))==NULL)
		{
			printf("unable to allocate memory.");
			exit(1);
		}
	}
	if((output =(char **) malloc((query_sequences_count_main)*sizeof(char*)))==NULL)
	{
		printf("unable to allocate memory.");
		exit(1);
	}
	for( i = 0; i < query_sequences_count_main; i ++)
	{
		if((output[i]=(char *) malloc((WINDOW_ALIGNMENT_SIZE + 1)*sizeof(char)))==NULL)
		{
			printf("unable to allocate memory.");
			exit(1);
		}
	}

	for(i =0 ; i < query_sequences_count_main ; i ++)
	{
		for( j = 0 ; j < WINDOW_SIZE; j ++)
		{
			if((window[i][j])&&(!isGap(window[i][j]->letter)))
			{
				input[i][j] = window[i][j]->letter;
			}
			else
			{
				input[i][j] = '*';
			}
		}
		input[i][j] = 0;
	}
	align_alignment_k(input, output, query_sequences_count_main,WINDOW_SIZE,max_number_in_group,dos_init,names[0]);
	//set back to windowAlignment
	windowAlignmentLength = (int)strlen(output[0]);
	
	letter_index_window = 0;
	letter_index_alignment = 0;
	for ( j = 0; j < query_sequences_count_main; j ++)
	{ 
		for ( i = 0; i < windowAlignmentLength; i ++)
		{
			windowAlignment[j][i] = 0;
		}
	}
	for ( i = 0; i < query_sequences_count_main; i ++)
	{
		letter_index_window = 0;
		letter_index_alignment = 0;

		for(letter_index_alignment = 0; letter_index_alignment < windowAlignmentLength; letter_index_alignment ++)
		{
			if(!(isGap(output[i][letter_index_alignment])))
			{
				while( (!window[i][letter_index_window]) || isGap(window[i][letter_index_window]->letter) )
				{
					letter_index_window ++;
				}
				if(window[i][letter_index_window]->letter == output[i][letter_index_alignment])
				{
					windowAlignment[i][letter_index_alignment] = window[i][letter_index_window];
					letter_index_window ++;
				}
			}
		}
	}
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		free(input[i]);
		free(output[i]);
	}
	free(input);
	free(output);
	return ;
}
int setOptimalAlignmentFromWindow()
//using extension of w-m danymic programming
//get the optimal multiple alignment 
//result set to windowAlignment, the length set to windowAlignmentLength
{
	//first initialize the score array

	int dimensionCount; 
	//this dimensionCount is how many dimension ,that is , how many actual fragments
	NODE* compactWindow[MAXSEQ][WINDOW_SIZE];
	//this is window compacted,without gaps
	int fragmentLength[MAXSEQ];
	//the actual length of each fragment in window
	Boolean fragmentEmptyFlag[MAXSEQ];
	//the actual fragment is empty?
	int dimensionLength[MAXSEQ];
	//this to store the lengthes of sequences fragment,similar to rowLength and colLength
	//int multipleDimensionScore[SPACE_SIZE];
	int* multipleDimensionScore;
	//this array is scores for multiple dimension, need to compute location with
	//dimensionPos array
	int dimensionPos[MAXSEQ];
	//this array is the multiple axis pos
   	//int multipleDimensionTrack[SPACE_SIZE];

	short int* multipleDimensionTrack;
	//this array is to track back;also used with dimensionPos array
	int i,j;
	//this is to tempary store scores of multiple dimension, 
	//for later comparison.
	//totally it should have 2^dimensionCount - 1 scores
	int multipleDirection[MAXSEQ];
	//record the direction information, 
	//1 indicate go along the direction
	//0 means not go along the direction
	
	int direction;
	//it is to compute multipleDirection
	int directionCount;
	//it is the count of total directions

	int alignmentScore;
	int cellValue;
	int maxValue;
	int maxDirection;
	NODE* temp[MAXSEQ][WINDOW_ALIGNMENT_SIZE];
	int alignmentPos;
	int alignmentLength;
	Boolean gapColumn;
	int index;

    // initialize
	//first set compact window

	dimensionCount = 0;
	for(i =0 ; i < query_sequences_count_main ; i ++)
	{
		fragmentEmptyFlag[i] = FALSE;
		fragmentLength[dimensionCount] = 0;
		for( j = 0 ; j < WINDOW_SIZE; j ++)
		{
			if((window[i][j])&&(!isGap(window[i][j]->letter)))
			{
				compactWindow[dimensionCount][fragmentLength[dimensionCount]] = window[i][j];
				fragmentLength[dimensionCount] ++;
			}
		}
		if(fragmentLength[dimensionCount]>0)
		{
			dimensionCount ++;
		}
		else
		{
			fragmentEmptyFlag[i] = TRUE;
		}
	}
	
	//compute the whole one dimension array size
	//fix one dimension to 0,set values for all posibiity of other dimension
	for ( i = 0; i < dimensionCount ; i ++)
	{
		//for each dimension 
		dimensionPos[i] = 0;
		dimensionLength[i] = fragmentLength[i];
		
		//travel all other dimension
	}
	N = 1;
	directionCount = 1;
	for ( i = 0; i < dimensionCount; i ++)
	{
		N = (dimensionLength[i] + 1)* N;
		directionCount = 2*directionCount;
	}
	N--;
	
	if((multipleDimensionScore=(int*) malloc((N + 2)*sizeof(int)))==NULL)
	//add 1 to prevent overflow
	{
		printf("unable to allocate memory for multipleDimensionScore.");
		exit(1);
	}
	if((multipleDimensionTrack=(short int*) malloc((N + 2)*sizeof(short int)))==NULL)
	//add 1 to prevent overflow
	{
		printf("unable to allocate memory for multipleDimensionTrack.");
		exit(1);
	}
	for( i = 0; i < N + 1; i ++)
	{
		multipleDimensionScore[i] = 0;
		multipleDimensionTrack[i] = 0;
	}

	
	//E(i, 0) = gap_open + i x gap_extend

	//THIS is the position [0,0,..,0]
    multipleDimensionScore[0] = 0;
	//For the track array:multipleDimensionTrack, each position has a value between 2^query_sequences_count_main and 1
	//this value indicates the direction it gets, 
	//it is computed from a direction array,which has length of query_sequences_count_main,
	//the elements in this direction array use 
	//1 indicate there is a movement from previos cell along this dimension
	//0 indicate it is same (match) on this dimension
	
    //begin to calculate

	for (i = 1; i <= N; i ++)
    {
		//first compute the position of multiple dimension cell
		setMultipleDimensionPointInArrayFromPosition(i, dimensionPos,dimensionCount,dimensionLength);
		//then compute the value of this cell
		//for each dimension,test value of pos - 1, and pos
		//so it has loop indicator value between 2^query_sequences_count_main and 1
		maxValue = -MAXINT;
		maxDirection = 0;
		for ( direction  = 1; direction < directionCount ; direction ++)
		{
			//get value for this direction
			//first set multipleDirection
			setMultipleDirection(direction,multipleDirection,dimensionCount);
			//get the value of the cell for this direction
			cellValue = getScoreOfCell(multipleDimensionScore,dimensionPos,multipleDirection,dimensionCount,dimensionLength,compactWindow);
			if(cellValue > maxValue)
			{
				maxValue = cellValue;
				maxDirection = direction;
			}
		}
		//record the direction
		if(maxValue > -MAXINT)
		{
			multipleDimensionScore[i] = maxValue;
			multipleDimensionTrack[i] = maxDirection;
		}
		else
		{
			return -MAXINT;
		}
	}//for i


	//after alignment score matrix set, here need to track back

	//get the dimension pos at the last
	for ( i = 0; i < dimensionCount; i ++)
	{
		dimensionPos[i] = dimensionLength[i];
	}
	//or
	//setMultipleDimensionPointInArrayFromPosition(N, dimensionPos);
	i = N;
	i = getPositionOfMultipleDimensionPointInArray(dimensionPos,dimensionCount,dimensionLength);
	alignmentPos = WINDOW_ALIGNMENT_SIZE - 1;
	alignmentLength = 0;
	while( i > 0)
	{
		
		//get the direction
		direction = multipleDimensionTrack[i];
		setMultipleDirection(direction, multipleDirection,dimensionCount);
		//for ( j = 0; j < query_sequences_count_main; j ++)
		for ( j = 0; j < dimensionCount; j ++)
		{
			if(multipleDirection[j] == 1)
			{
				//a step along this direction
				
				temp[j][alignmentPos] = compactWindow[j][dimensionPos[j] -1];
				dimensionPos[j] --;
			}
			else
			{
				//a gap along this direction
				
				temp[j][alignmentPos] = 0;
				//dimensionPos[j] --;
			}
		}
		alignmentPos --;
		alignmentLength ++;
		i = getPositionOfMultipleDimensionPointInArray(dimensionPos,dimensionCount,dimensionLength);
	}

	//set back to windowAlignment
	windowAlignmentLength = 0;
	for ( i = 0; i < alignmentLength; i ++)
	{
		//check if it is a gap column 
		gapColumn = TRUE;
		for ( j = 0; j < dimensionCount; j ++)
		{ 
			//windowAlignment[j][i] = temp[j][alignmentPos +1  + i];
			if((temp[j][alignmentPos +1  + i])&&
				(!isGap(temp[j][alignmentPos +1  + i]->letter)))
			{
				gapColumn = FALSE;
				break;
			}
		}
		if(!gapColumn)
		{
			index = 0;
			for ( j = 0; j < query_sequences_count_main; j ++)
			{ 
				if(!fragmentEmptyFlag[j])
				{
					windowAlignment[j][windowAlignmentLength] = temp[index++][alignmentPos +1  + i];
				}
				else
				{
					windowAlignment[j][windowAlignmentLength] = 0;
				}
			}
			windowAlignmentLength ++;
		}
	}

	alignmentScore = multipleDimensionScore[N];

	free(multipleDimensionScore);
	free(multipleDimensionTrack);

	return alignmentScore;
}
int getPositionOfMultipleDimensionPointInArray(int dimensionPos[MAXSEQ],int dimensionCount,int dimensionLength[MAXSEQ])
{
	int i;
	int pos;
	i = 0;
	pos = 0;
	while(i < dimensionCount)
	{
		if(i > 0)
		{
			pos = pos*(dimensionLength[i]+1) + dimensionPos[i];
		}
		else
		{
			pos = dimensionPos[0];
		}
		i ++;
	}
	return pos;
}
int getDirectionOfMultipleDirection(int multipleDirection[MAXSEQ],int dimensionCount)
{
	int i;
	int direction;
	i = 0;
	direction = 0;
	while(i < dimensionCount)
	{
		direction = direction*2 + multipleDirection[i];
		i ++;
	}
	return direction;
}
void setMultipleDimensionPointInArrayFromPosition(int pos, int dimensionPos[MAXSEQ],int dimensionCount,int dimensionLength[MAXSEQ])
//this will set dimension array from pos
{
	int i;
	for( i = 0; i < query_sequences_count_main + 1; i ++)
	{
		dimensionPos[i] = -MAXINT;
	}
	i = dimensionCount - 1;
	
	while(i > 0)
	{
		dimensionPos[i] = pos%(dimensionLength[i] +1);
		pos =  pos/(dimensionLength[i] + 1) ;
		i --;
	}
	dimensionPos[i] = pos;
}

void setMultipleDirection(int direction, int multipleDirection[MAXSEQ], int dimensionCount)
{
	int i;
	i = dimensionCount - 1;
	
	while(i >= 0)
	{
		multipleDirection[i] = direction%2 ;
		direction =  direction/2 ;
		i --;
	}
}
void clearWindow()
//this is to clear the window's content
{
	int i;
	int j;

	for( i = 0; i < query_sequences_count_main; i ++)
	{
		for( j = 0; j < WINDOW_SIZE; j ++)
		{
			window[i][j] = 0;
		}
	}
}
int setInitialWindow()
//return -1 means fail to set
//otherwise return 0
//will set an intial window
//first look for the best sequence for seting, 
//it will compare all sequence segment to get the best one
//then based on the sequence segment selected, set other sequnece
{
	//first look for the best sequence for setting
	//1.find a good node to be the initial node
	//2.from this node, get the initial positions 
	//3.Begin from the initial positions, set same number of nodes from each sequence to window
	//first select a good node, it should be a "full edge" node,
	//so it can adjust the location of others
	int i;
	int j;
	int columnPos ;
	int maxTotalWeight;
	NODE* node;
	int goodPos;
	int pos;

	Boolean found;
	Boolean end;
	columnPos  = 0;
	found = FALSE;
	end = FALSE;
	
	while((!found)&&(!end))
	{
		maxTotalWeight = -MAXINT;
		found = FALSE;
		for( i = 0; i < query_sequences_count_main; i ++)
		{
			if(columnPos + 1 >= sequencesLength[i])
			{
				end = TRUE;
				break;
			}
			node = sequences[i][columnPos];
			//two conditions needed to be satisfied
			//1. max edge number
			//2. all edge end nodes are after the last pos
			//check them one by one 
			//select the one with max tatalWeight
			
			//check it has max edge number?
			if(node->edgeCount == query_sequences_count_main - 1)
			{
				found = TRUE;
			}
			else
			{
				continue;
			}
			
			//yes, it has max edge number
			if(node->totalWeight > maxTotalWeight)
			{
				goodPos = i;
				maxTotalWeight =  node->totalWeight;
			}
	
		}//for to check the good pos
		if((found)||(end))
		{
			break;
		}
		columnPos ++;
	}//while
	if((!found)&&(end))
	{
		return -1;
	}
	if(found)
	{
		//this is the start node for the window's nodes
		node = sequences[goodPos][columnPos];
		for( i = 0; i < query_sequences_count_main; i ++)
		{
			pos = node->edgePos[i];

			for( j = 0; j < WINDOW_SIZE; j ++)
			{
				window[i][j] = sequences[i][pos];
				pos ++;
			}
		
		}
		//set the node's sequence
		pos = columnPos;
		for( j = 0; j < WINDOW_SIZE; j ++)
		{
			window[goodPos][j] = sequences[goodPos][pos];
			pos ++;
		}
		
	}
	return 0;
}
void concatenateColumns()
//align sequences by using path array just created
//concatenate the columns
{
	int i;
	int j;
	int k;
	int colPos = 0;//indicate the position of current done on the columns

	int beginPos;
    int maxLength;
    
	for(i = 0; i < query_sequences_count_main; i++)
	{
		for( j = 0; j < MAXLEN; j++)
		{
			alignment[i][j] = -1;
		}
	}
	if(columnCount <= 0)
		return;
	//add the begin part before the first column
	
	maxLength = 0;
	for(i = 0; i < query_sequences_count_main; i++)
	{
		k = 0;
		for(j = 0; j < columns[i][0]; j++)
		{
			alignment[i][k]= j;
			k ++;
		}
		
		if( k > maxLength)
		{
			maxLength = k;
		}
	}
  	beginPos = maxLength;
	//add the columns part
  //fill the gap
	colPos = 0;

	while(colPos < columnCount)
    {
		if (colPos == columnCount-1)
			break;
		
		for(i = 0; i < query_sequences_count_main; i++)
		{
			alignment[i][beginPos] = columns[i][colPos];
		}
		maxLength = 0;
		for(i = 0; i < query_sequences_count_main; i++)
		{
			j = 0;
			for(k = columns[i][colPos]+1; k < columns[i][colPos+1]; k ++)
			{
				alignment[i][beginPos+j+1] = k;
				j ++;
			}
			if(j > maxLength)
			{
				maxLength = j;
			}
		}
		beginPos = beginPos + maxLength +1;
		colPos++;
	}//while
	//add the rest of the sequence to alignment
	for(i = 0; i < query_sequences_count_main; i++)
	{
		alignment[i][beginPos]=columns[i][columnCount-1];
	}
	maxLength = 0;
	for(i = 0; i < query_sequences_count_main; i++)
	{
		k = 0;
		for(j = columns[i][columnCount-1]+1; j < sequencesLength[i]; j++)
		{
			alignment[i][beginPos+k+1]= j;
			k ++;
		}
		
		if( k > maxLength)
		{
			maxLength = k;
		}
	}
  	alignmentLength = beginPos + maxLength +1;
 }
void printResultFile(char* filename)
{
  	FILE *fp;

  	int i;
  	int j;

  	if(!filename)
	  filename = "ref\\result2";

	if((fp=fopen(filename,"wt"))==NULL)  
	{  
		printf("Cannot open file strike any key exit!");  
		exit(1);  
	}

	//write file
	//tile
	fputs("PileUp\n\n\n",fp);
	fputs("\tMSF:	82	Type: P	Check:  0   ..\n\n",fp);
	for(i = 0;i<query_sequences_count_main;i++)
  	{
	      fputs("\tName: ",fp);
	      fputs(names[i],fp);
	      fputs(" oo  Len:   0  Check:  0  Weight:  1.00\n",fp);
	}
	fputs("\n\n//\n\n\n",fp);
	for(i = 0;i<query_sequences_count_main;i++)
  	{
	      
	      fputs(names[i],fp);
	      fputs(" \t",fp);
		  for(j = 0; j < alignmentLength; j ++)
		  {
			  if(alignment[i][j] > -1)
			  {
				  fprintf(fp,"%c",sequences[i][(alignment[i][j])]->letter);
			  }
			  else
			  {
				  fprintf(fp,"-");
			  }
		  }
	      fputs("\n",fp);
	}
	//write the end of msf
	fputs(" \n",fp);
  	fclose(fp);
  
  	return;
  	
}
void printResultAlignmentToResultFile(char* filename)
//this is to print the result file from array resultAlignment
{
  	FILE *fp;

  	int i;
  	int j;

  	if(!filename)
	  filename = "ref\\result2";

	if((fp=fopen(filename,"wt"))==NULL)  
	{  
		printf("Cannot open file strike any key exit!");  
		exit(1);  
	}

	//write file
	//tile
	fputs("PileUp\n\n\n",fp);
	fputs("\tMSF:	82	Type: P	Check:  0   ..\n\n",fp);
	for(i = 0;i<query_sequences_count_main;i++)
  	{
	      fputs("\tName: ",fp);
	      fputs(names[i],fp);
	      fputs(" oo  Len:   0  Check:  0  Weight:  1.00\n",fp);
	}
	fputs("\n\n//\n\n\n",fp);
	for(i = 0;i<query_sequences_count_main;i++)
  	{
	      
		fputs(names[i],fp);
	    fputs(" \t",fp);
		for(j = 0; j < resultAlignmentLength[i]; j ++)
		{
			if(resultAlignment[i][j])
			{
				fprintf(fp,"%c",resultAlignment[i][j]->letter);
			}
			else
			{
				fputs(".",fp);
			}
		}
	    fputs("\n",fp);
	}
	//write the end of msf
	fputs(" \n",fp);
  	fclose(fp);
  
  	return;
  	
}
void printResultAlignment()
//this is to print array resultAlignment
{
  	
  	int i;
  	int j;


	for(i = 0;i<query_sequences_count_main;i++)
  	{
	      
		for(j = 0; j < resultAlignmentLength[i]; j ++)
		{
			if(resultAlignment[i][j])
			{
				printf("%c",resultAlignment[i][j]->letter);
			}
			else
			{
				printf(".");
			}
		}
	    printf("\n");
	}
	//write the end of msf
	printf(" \n");
 
  	return;
  	
}

int main2(int argc,char** argv)
{
    
	//char featureTableFileName[64];
//	char resultFileName[64];
//	int score;
//	int i;
/**************************************************************/
	// read file
	//strcpy(resultFileName,argv[2]);
	/*
	strcpy(featureTableFileName, argv[1]);
	i = 0;
	while(featureTableFileName[i])
	{
		if(featureTableFileName[i] == '.')
			break;
		i++;
	}
	featureTableFileName[i+1]='f';
	featureTableFileName[i+2]='t';
	featureTableFileName[i+3]='b';

	printf("%s,%s,%s\n",argv[1],resultFileName,featureTableFileName);
	
	/************************************************************/

 	readSequencesFromMsf(argv[1]);
	/***********************************************************/
	//for compute score
	//score = getSequenceScore();
	//printf("Total score = %d\n",score);
	//printf("Alignment length = %d\n",sequencesLength[0]);
   	//readSecondFromFtb(featureTableFileName); 
	/***********************************************************/
	//	matrixUsed = GONNET250;
	
	
	setLinks();
	//sortNodes();
	
	setColumnsSet();
	if(0)
	{
		concatenateColumns();
		printResultFile(argv[2]);
	}
	else
	{
		alignWindowUseMSA = TRUE;
		setAnchors();
		alignWithAnchor();
		printResultAlignmentToResultFile(argv[2]);
	}
	
	printf("%s,query_sequences_count_main = %d\n",argv[1],query_sequences_count_main);
	freeAll();
	return 0;
}

/******************************************************************************/
//THIS IS FOR MULTIPLE SEQUENCE ALIGNMENT PART
/******************************************************************************/
int multiAlignPatternsNodesArray(int blockIndex)
	//this function will align a block in terms of nodes
	//the value of blockIndex should be between 0 and anchorsCount 
	 //assume the nodes array have been set to groupNodeArray
	 //which is a group sequence
{
    //initialize

	int i;
	int j;
	int k;
    int index=0;//means which is the root index
	int row;
    int col;
	int maxRow;
	int maxCol;
    int maxScore;
	int index1,index2;
	int clusterPairScoreTable[MAX_SEQ_WITH_PATTERN][MAX_SEQ_WITH_PATTERN];
    int tmpScore[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER];
    short int tmpTrack[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER];
	int newClusterPairScoreTable[MAX_SEQ_WITH_PATTERN][MAX_SEQ_WITH_PATTERN];
    int rowLength ;
    int colLength ;
	int countI; 
    int countJ; 
	int I,J ;//I would be deleted
	int alignedScore;
	
	//**********************************************************************************************//

	//initialize clusters node
	if(!alignWindowUseMSA)
	{
		setGroupNodeClusterFromWindow();
	}
	else
	{
		initializeGroupNodeCluster(blockIndex);
	}
    //--------------------------------------------------------------------------------------------
    
	matrixUsed = GONNET250;

    for(row = 0;row<query_sequences_count_main;row ++)
	{
		for(col = 0;col<=row;col++)
		{
			if(row == col)
			{
				clusterPairScoreTable[row][col] = 0;
				for(i = 0; i < groupNodeClusterLength[row]; i++)
				{
					clusterPairScoreTable[row][col] += getRoughScoreOfTwoNodes(groupNodeClusters[row][i],groupNodeClusters[row][i]);
				}
			}
			else
			{
				clusterPairScoreTable[row][col]=(alignTwoNodeSequenceArray(groupNodeClusters[row],groupNodeClusters[col],groupNodeClusterLength[row],groupNodeClusterLength[col]));
				clusterPairScoreTable[col][row] =clusterPairScoreTable[row][col];
			}
		}
	}
	
	matrixUsed = BLOSUM62;
      //--------------------------------------------------------------------------------------------
      while(groupNodeClustersCount>1)
      {
			//select the max score from table
			maxRow=0;
			maxCol=0;
			maxScore = -MAXINT;
		
			for(row = 0;row<query_sequences_count_main;row ++)
			{
					for(col = 0;col<query_sequences_count_main;col++)
					{
						if((maxScore < clusterPairScoreTable[row][col])&&(row!=col))
						{
						  maxScore = clusterPairScoreTable[row][col];
						  maxRow = row;
						  maxCol = col;
						}
					}
			}
		
          //combine the two sequence
          //first set aligned strings in cluster

			index1 = maxCol;
			index2 = maxRow;


			rowLength = groupNodeClusterLength[index1] + 1;
			colLength = groupNodeClusterLength[index2] + 1;

			alignedScore = alignTwoNodeSequenceClusters(index1,index2,tmpScore,tmpTrack);

			//I will be deleted
			//set I,J
			if (maxCol>maxRow)
			{
				I = maxRow;
				J = maxCol;
				index = maxRow;
			}
			else
			{
				I = maxCol;
				J = maxRow;
				index = maxCol;
			}

          //change the score table
			k = 0;
			for(row = 0; row < query_sequences_count_main;row ++)
			{
				for(col = 0;col<query_sequences_count_main;col++)
				{
					if(!((row==I)&&(col==J)))
					{
						newClusterPairScoreTable[row][col] = clusterPairScoreTable[row][col] ;
					}
				}//for
          }//for

          countI = getGroupNodeClusterCount(I);
          countJ = getGroupNodeClusterCount(J);
          for (k = 0; k < query_sequences_count_main;k++)
          {
				if(!((k==I)||(k==J)))
				{
					newClusterPairScoreTable[I][k]= (countI*clusterPairScoreTable[I][k]+countJ*clusterPairScoreTable[J][k])/(countI+countJ);
					newClusterPairScoreTable[k][I]=newClusterPairScoreTable[I][k];
				}
          }

			for (k = 0; k < query_sequences_count_main;k++)
			{
				newClusterPairScoreTable[k][J]=-MAXINT;
				newClusterPairScoreTable[J][k]=-MAXINT;
			}
          //combine two clusters
			setAlignmentOfTwoGroupNodeCluster(index1,index2,tmpTrack);//also set new clusterCount
		
			//combineTwoCluster(index1,index2);

			
			//scoreTable = newTable;
			for(i = 0; i < MAX_SEQ_WITH_PATTERN; i ++)
			{
				for(j = 0; j < MAX_SEQ_WITH_PATTERN; j ++)
				{
					clusterPairScoreTable[i][j] = newClusterPairScoreTable[i][j];
				}
			}
      }//while
		if((alignWindowUseMSA)&&(!forInitialAlignment))
		{
			setWindowAlignmentFromGroupNodeClusters();
		}
		return alignedScore;
  }

void initializeGroupNodeCluster(int anchorIndex)
//this is to populate the data between anchor anchorIndex-1 and anchor anchorIndex 
//to array
{
	int i;
	int j;
	int index;
	
	int beginPos;
	int endPos;

	groupNodeClustersCount = query_sequences_count_main;

	//first reset the groupNodeClusters and groupNodeClusterNo
	for(i = 0; i < MAX_SEQ_WITH_PATTERN;i++)
	{
		for ( j  = 0; j < MAX_NODES_IN_PATTERN_FOR_CLUSTER; j ++)
		{
			groupNodeClusters[i][j] = 0;
		}
	}
	for(i = 0; i < MAX_SEQ_WITH_PATTERN;i++)
	{
		groupNodeClusterNo[i]  = -1;
	}
	
	for(i = 0; i < query_sequences_count_main;i++)
	{
			
		groupNodeClusterNo[i] = i;
		index = 0;	
		
		//calculate the begin pos and end pos
		if(anchorIndex == 0)
		//this is the very first block
		{
			beginPos = 0;
		}
		else
		{
			beginPos = columns[i][anchorEndPos[anchorIndex - 1]] + 1;
		}
		if(anchorIndex == anchorsCount)
		//this is the very last block
		{
			
			endPos = sequencesLength[i] - 1;
		}
		else
		{
			endPos = columns[i][anchorBeginPos[anchorIndex]] - 1;
		}
		//set the value
		if((endPos - beginPos + 1) >= MAX_NODES_IN_PATTERN_FOR_CLUSTER)
		{
			exit(0);
		}
		for ( j  = beginPos; j <= endPos; j ++)
		{
			groupNodeClusters[i][index] = sequences[i][j];
			index ++;
		}//for
		
		groupNodeClusterLength[i] = index;
	}
}

int  alignTwoNodeSequenceClusters(int index1,int index2,int score[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER],short int track[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER])
//basic element of each sequence is node
//clusters are sets of sequence of node
{

	int rowLength; //= cluster1[0].size()+1;
	int colLength; //= cluster2[0].size()+1;
	
	// initialize
	int i,j;
	int gapPenalty;

	int row;
	int col;
	int above;
	int preceding;
	int diagnal;

	int gapOpenPenalty;
	int gapExtensionPenalty;

	int debug;
	debug = 0;

	rowLength = groupNodeClusterLength[index1]+1; 
	colLength = groupNodeClusterLength[index2]+1;
	//initialize
	for (i = 0; i< rowLength+1;i++)
      for (j = 0; j< colLength+1;j++)
	  {
			score[i][j] = 0;
			track[i][j] = 0;
	  }
	//gapPenalty = getWeight('a','.');
	gapPenalty = -nodeGapPenalty;
	gapExtensionPenalty = getGapExtensionPenalty();
	gapOpenPenalty = getGapOpenPenalty();

	if(noGapPenaltyAtBegin)
	{
		for (i = 1; i< colLength;i++)
		{
			score[0][i] = 0;//i * gapPenalty;
		}
		for (i = 1; i< rowLength;i++)
		{
			score[i][0] = 0;//i * gapPenalty;
		}
		score[0][0] = 0;
	}
	else
	{
		for (i = 1; i< colLength;i++)
		{
			score[0][i] = gapOpenPenalty + (i-1) * gapExtensionPenalty;
		}
		for (i = 1; i< rowLength;i++)
		{
			score[i][0] = gapOpenPenalty + (i-1) * gapExtensionPenalty;
		}
		score[0][0] = 0;
	}
   
	for (i = 1; i< rowLength;i++)
		track[i][0] = UP;
    for (j = 1; j< colLength;j++)
        track[0][j] = LEFT;
   //begin to calculate
   row = 0;
   col = 0;
   above = 0;
   preceding = 0;
   diagnal =0;

   for (row = 1; row < rowLength; row ++)
   {
     for (col = 1; col < colLength; col ++)
     {
       // compute the maximum one
		if(track[row -1][col] == UP)
		 {
			
			above = score[row -1][col] +gapExtensionPenalty;
		 }
		 else
		 {
			above = score[row -1][col] +gapOpenPenalty;
		 }
		 if(track[row][col-1] == LEFT)
		 {
			 preceding = score[row][col-1] + gapExtensionPenalty;
		 }
		 else
		 {
			preceding = score[row][col-1] + gapOpenPenalty;
		}

       diagnal = score[row -1][col -1] + getWeightOfGroupNodeClusterPair(index1,index2,row-1,col-1);
       // compare
       // how to deal with multiple path?
	   {
       if(above >= preceding)
       {
          if (above >= diagnal)
          {
            score[row][col] = above;//above is the max
            track[row][col] = UP;
          }
          else
          {
            score[row][col] = diagnal;//diagal is the max
            track[row][col] = DIAGNAL;
          }
       }
       else //preceding is the bigger
       {
         if (preceding >= diagnal)
         {
           score[row][col] = preceding;//preceding is the max
           track[row][col] = LEFT;
         }
         else
         {
           score[row][col] = diagnal;//diagnal is the max
           track[row][col] = DIAGNAL;
          }
       }//if else
	   }
     }//for col
   }//for row
	
   return score[rowLength-1][colLength-1];

 }

 int getGroupNodeClusterCount(int index)
//this function will return how many node pattern sequence is included in this cluster
{
	int i;
	int count;
	count = 0;
	for(i = 0; i < MAX_SEQ_WITH_PATTERN; i ++)
	{
		if(groupNodeClusterNo[i]==index)
		{
			count ++;
		}
	}
	return count;
}

void setAlignmentOfTwoGroupNodeCluster(int index1,int index2,short int track[MAX_NODES_IN_PATTERN_FOR_CLUSTER][MAX_NODES_IN_PATTERN_FOR_CLUSTER])
{
	int length1; //= cluster1[0].size();
    int length2; //= cluster2[0].size();
    int row ; //=length2 ;
    int col; //=length1 ;
    int count1;//= cluster1.length;
    int count2;//= cluster2.length;
   
    NODE* lines1[MAX_SEQ_WITH_PATTERN][MAX_NODES_IN_PATTERN_FOR_CLUSTER];
	NODE* lines2[MAX_SEQ_WITH_PATTERN][MAX_NODES_IN_PATTERN_FOR_CLUSTER];
	int i;
	int j;
	int pos1;
	int pos2;
	//ArrayList lines1[]=new ArrayList[count2];
    //ArrayList lines2[]=new ArrayList[count1];
	

	length1 = groupNodeClusterLength[index1];
	length2 = groupNodeClusterLength[index2];
	
	row = length2 ;
	col = length1 ;
	count1 = getGroupNodeClusterCount(index2);
	count2 = getGroupNodeClusterCount(index1);
	pos1 = 0;
	pos2 = 0;

    while((row>0) || (col>0))
    {
		if(track[col][row]==LEFT)
		{
			//line1=sequence2.charAt(row-1)+line1;
			addOneNode(lines1,index2,row-1,pos1++);
			row --;
			//line2='.'+line2;
			addOneGapNode(lines2,pos2++);
		}
		else if(track[col][row]==DIAGNAL)
		{
			//line1=sequence2.charAt(row-1) +line1;
			addOneNode(lines1,index2,row-1,pos1++);
			row --;
			//line2=sequence1.charAt(col-1) +line2;
			addOneNode(lines2,index1,col-1,pos2++);
			col --;
		}
		else if(track[col][row]==UP)
		{
			//line2=sequence1.charAt(col-1)+line2;
			addOneNode(lines2,index1,col-1,pos2++);
			col --;
			//line1 = '.'+line1;
			addOneGapNode(lines1,pos1++);
		}
		else if(track[col][row]==0)
		{
			if(row > 0)
			{
				  addOneNode(lines1,index2,row-1,pos1++);
				  row --;
				  //line2='.'+line2;
				  addOneGapNode(lines2,pos2++);
			}
			else
			{
				  addOneNode(lines2,index1,col-1,pos2++);
				  col --;
				  //line1 = '.'+line1;
				  addOneGapNode(lines1,pos1++);
			}
		}
		else
		{
			break;
		}
	}//while
	
	//here copy back to original array
	//make sure to keep the original order
    //remember that cluster index1 is in line2 and cluster index2 is in line1
	//also the patterns in line1 and line2 are in reverse order 
	
	for(i = 0;i < count2;i++)
	{
		row = getGroupNodeClusterRowIndex(index1,i);
		for(j = 0; j < pos2; j ++)
		{
			groupNodeClusters[row][pos2-j-1] = lines2[i][j];
		}
	}
    for(i = 0;i < count1;i++)
	{
		row = getGroupNodeClusterRowIndex(index2,i);
		for(j = 0; j < pos1; j ++)
		{
			groupNodeClusters[row][pos1-j-1] = lines1[i][j];
		}
	}
	//combine
	if(index1 > index2)
		row = index2;
	else
		row = index1;

	for(i = 0;i < MAX_SEQ_WITH_PATTERN;i++)
	{
		if((groupNodeClusterNo[i] == index2)||(groupNodeClusterNo[i] == index1))
		{
			groupNodeClusterNo[i] = row;
			groupNodeClusterLength[i] = pos1;
		}
	}
	groupNodeClustersCount -- ;

    //return returnArray;
  }
int getWeightOfGroupNodeClusterPair(int index1,int index2,int pos1,int pos2)
{
     int i,j;
     int weight = 0;
     NODE* a;
	 NODE* b;
	 int count1;
	 int count2;

	count1 = getGroupNodeClusterCount(index1);
	count2 = getGroupNodeClusterCount(index2);
     for(i = 0;i < count1;i++)
     {
		for(j = 0; j < count2;j++)
		{
			a = getNodeFromGroupNodeClusters(index1,pos1,i);
			b = getNodeFromGroupNodeClusters(index2,pos2,j);
			//if(!((a->letter=='.')||(b.letter=='.')))//check if there is a gap
			//if((a)&&(b))//check if there is a gap
			
				//weight += getBestScoreOfTwoPatterns(a,b);
			if((a)&&(b))//deal with gap
			{
				weight += getRoughScoreOfTwoNodes(a,b);
			}
			
		}
     }
     weight = weight /(count1*count2);
	 
     return weight;
  }

void addOneNode(NODE* lines[MAX_SEQ_WITH_PATTERN][MAX_NODES_IN_PATTERN_FOR_CLUSTER],int index,int clusterPos,int linePos )
//this function add a "column" to lines at linePos,which gotten from cluster index at clusterPos
{
	int count;
	NODE* node;
	int i;
	count = getGroupNodeClusterCount(index);
	for(i = 0; i < count ; i ++)
	{
		node = getNodeFromGroupNodeClusters(index,clusterPos,i);
		lines[i][linePos] = node;
	}

}
void addOneGapNode(NODE* lines[MAX_SEQ_WITH_PATTERN][MAX_NODES_IN_PATTERN_FOR_CLUSTER],int pos)
{
	int i;
	for(i = 0; i < MAX_SEQ_WITH_PATTERN ; i ++)
	{
		
		lines[i][pos] = 0;
	}
}

int getGroupNodeClusterRowIndex(int index,int no)
//this function will return the actual index in clusters array for cluster index no row 
{
	int i;
	int count;
	count = 0;
	for(i = 0; i < MAX_SEQ_WITH_PATTERN; i ++)
	{
		if(groupNodeClusterNo[i] == index)
		{
			if(count == no)
			{
				return i;
			}
			count++;
		}
	}
	return -1;
}
NODE* getNodeFromGroupNodeClusters(int index,int pos,int no)
//this function will return the NODE* from group node cluster index at column pos ,row no
{

	int rowIndex;

	//first locate the no
	rowIndex = getGroupNodeClusterRowIndex(index,no);
	
	if(rowIndex == -1)
		return 0;
	else
		return groupNodeClusters[rowIndex][pos];
}

void appendBlock()
//this will directly append data to existing alignment from
//array groupNodeCluster
{
	int i;
	int j;
	//printf("\n");
	for (i = 0; i < query_sequences_count_main; i ++)
	{
		for(j = 0; j < groupNodeClusterLength[i]; j ++)
		{
			resultAlignment[i][(resultAlignmentLength[i]+j)]=groupNodeClusters[i][j];
			/*
			if(groupNodeClusters[i][j])
			{
				printf("%c",groupNodeClusters[i][j]->letter);
			}
			else
			{
				printf("0");
			}
			*/
		}
		resultAlignmentLength[i] += groupNodeClusterLength[i];
		//printf("\n");
	}
}

void appendAnchor(int anchorIndex)
//this will  append data to existing alignment from
//anchor indexed by anchorIndex in that array anchor 
{
	int i;
	int j;
	int length;
	length = 0;
	printf("Now for anchor %d,begin at %d, end at %d\n", anchorIndex, anchorBeginPos[anchorIndex], anchorEndPos[anchorIndex]);
	for (j = anchorBeginPos[anchorIndex]; j <= anchorEndPos[anchorIndex]; j ++)
	{
		for(i = 0; i < query_sequences_count_main; i ++)
		{
			resultAlignment[i][(resultAlignmentLength[i]+length)] = sequences[i][columns[i][j]];
		}
		if(0)
		{
			for(i = 0; i < query_sequences_count_main; i ++)
			{
				printf("%c",resultAlignment[i][(resultAlignmentLength[i]+length)]->letter);
			}
			printf("\n");
		}
		length ++;
	}
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		resultAlignmentLength[i] += length;
	}
}

void alignWithAnchor()
{
	int i;
	i = 0;
	//printf("The columns are:\n");
	//printoutColumns();
	//printf("\n");
	///anchorsCount = 0;
	while(i < anchorsCount)
	{
		//initialize
		multiAlignPatternsNodesArray(i);
		appendBlock();
		appendAnchor(i);
		i ++;
	}
	multiAlignPatternsNodesArray(i);
	appendBlock();
}
void printoutColumns()
//this is for printing out the values of columnsArray
{
	int i;
	int j;
	for (j = 0; j < columnCount; j ++)
	{
		for(i = 0; i < query_sequences_count_main; i ++)
		{
			if(sequences[i][columns[i][j]])
				printf("%c",sequences[i][columns[i][j]]->letter);
			else
				printf("0");
		}
		printf("\n");
	}
}

Boolean getConsecutiveOfColumn(int currentColumnPos)
//this function is to test if column at currentColumnPos is consecutive to next or not
{
	int i;
	short int consecutive;
	consecutive = TRUE;
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		if(columns[i][currentColumnPos] + 1 < columns[i][currentColumnPos+1])
		{
			consecutive = FALSE;
		}
	}
	return consecutive;
}

int getScoreOfCell(int multipleDimensionScore[SPACE_SIZE],int dimensionPos[MAXSEQ],int multipleDirection[MAXSEQ],int dimensionCount,int dimensionLength[MAXSEQ],NODE* window[MAXSEQ][WINDOW_SIZE])
//this is to get the value of the cell in the multiple dimensional space
//along the perticular direction (indicated by multipleDirection)
//the cell needed to compute is the current cell (indicated by dimensionPos) 
//offset along the dirction (indicated by multipleDirection)
{
	int pos;
	int i;
	int j;
	int gapCount;
	int func;
	NODE* node1;
	NODE* node2;

	i = 0;
	pos = 0;
	gapCount = 0;
	while(i < dimensionCount)
	{
		if(dimensionPos[i] < multipleDirection[i])
		{
			return -MAXINT+1;
		}
		else
		{
			if( i > 0)
			{
				pos = pos*(dimensionLength[i]+1) + dimensionPos[i]  - multipleDirection[i];
			}
			else
			{
				pos = dimensionPos[i]  - multipleDirection[i];
			}
			i ++;
		}
	}
	//now we have the position of the cell along the direction,it is at multipleDimensionScore[pos]
	//calculate the value from the cell and from the direction
	func = 0;
	//for each dimension, 0 means gap;
	//1 means a step!

	for( i = 0; i < dimensionCount ; i ++)
	{
		for ( j = i+1 ; j < dimensionCount; j ++)
		{
			if((multipleDirection[i] == 0) && (multipleDirection[j] == 0))
			{
				//do nothing 
				continue;
			}
			else if((multipleDirection[i] == 1) && (multipleDirection[j] == 1))
			{
				if((dimensionPos[i] < 1)||(dimensionPos[j] < 1))
				{
					//do nothing
					continue;
				}
				node1 = window[i][dimensionPos[i]-1];
				node2 = window[j][dimensionPos[j]-1];
				func = func + getRoughScoreOfTwoNodes(node1,node2);
			}//if else
			else if((multipleDirection[i] == 1) || (multipleDirection[j] == 1))
			{
				if(multipleDirection[i] == 1)
				{
					//along this direction, there is a step
					if(dimensionPos[i] < 1)
					{
						continue;
					}
					//if this direction is another gap,if so, do nothing
					if(dimensionPos[i] >= 1)
					{
						node1 = window[i][dimensionPos[i]-1];
						if((!node1)||((node1)&&(isGap(node1->letter))))
						{
							continue;
						}
					}
				}
				if(multipleDirection[j] == 1)
				{
					// along this direction, there is a step
					if(dimensionPos[j] < 1)
					{
						continue;
					}
					//if this direction is another gap,if so, do nothing
					if(dimensionPos[j] >= 1)
					{
						node1 = window[j][dimensionPos[j]-1];
						if((!node1)||((node1)&&(isGap(node1->letter))))
						{
							continue;
						}
					}
				}
				func = func + gapPenalty;
			}
		

		}//for j
	}//for j

	return (multipleDimensionScore[pos] + func);
}

Boolean setLastRColumnsOfWindow()
//based on lastPositionInSequences, slide window to next pos
//keep window size WINDOW_SIZE
//set last r = lower int((w+1)/2) part of window
//if slide successfully, return 1;
//else (include reaching end), return 0;
{
	//algorithm
	//1. find the begin position of the window
	//1.1 compute r = lower int((w+1)/2)

	int i;
	int j;
	int r;
	int beginPos;
	int k;
	int len;
	
	if(windowReachEnd)
	{
		return FALSE;
	}

	r = (WINDOW_SIZE + 1)/2;
	len = r;
	positionInWindow = WINDOW_SIZE -1;
	windowAtBegin = FALSE;
	windowReachEnd = TRUE;
	k = 0;

	for(i = 0; i < query_sequences_count_main; i ++)
	{
		if(lastPositionInSequences[i] >= sequencesLength[i] - 1)
		{
			continue;
		}
		beginPos = lastPositionInSequences[i] + r;
		if( beginPos >= sequencesLength[i] - 1)
		{
			beginPos = sequencesLength[i] - 1;
			len = sequencesLength[i] - 1 - lastPositionInSequences[i];
			if(len > r)
			{
				len = r;
			}
		}
		else
		{
			windowReachEnd = FALSE;
			len = r;
		}
		lastPositionInSequences[i] = beginPos;
		k = 0;
		for( j = beginPos; j >= 0; j --)
		{
			if( k >= len)
			{
				window[i][WINDOW_SIZE -1 -k] = 0;
			}
			else
			{
				window[i][WINDOW_SIZE -1 -k] = sequences[i][j];
			}
			k ++;
			if(k >= r)
			{
				break;
			}
			
		}
		if(j < 0)
		{
			windowAtBegin = TRUE;
		}
	}
	positionInWindow = WINDOW_SIZE -1 -k;
	return (!windowReachEnd);
}

int wholeProcess()
{
	Boolean notDone;
	setInitialAlignment();
	putInitialWindow();
	notDone = TRUE;
	while(notDone)
	{
		//printoutWindow();
		setOptimalAlignment();
		//printoutWindowAlignment();
		putBlock();
		notDone = setNextWindow();
	}
	setOptimalAlignment();
	putBlock();
	return 0;
}
void align_a_window(int* optimal_score,int* score_improvement,int original_score,
					NODE* best_alignment[MAXSEQ][WINDOW_ALIGNMENT_SIZE],
					int* best_scoreOpt, int* best_alignment_length,
					int set_to_best)
{
	setOptimalAlignment();
	*optimal_score = getWindowAlignmentSPScore(windowAlignment,query_sequences_count_main,windowAlignmentLength);
	*score_improvement = *optimal_score - original_score;
	//if((*optimal_score) > (*best_scoreOpt))
	if(set_to_best)
	{
		*best_scoreOpt = *optimal_score;
		copy_window_alignment(windowAlignment,best_alignment,windowAlignmentLength);
		*best_alignment_length = windowAlignmentLength;
	}
	if(debug > -1)
	{
		printf("%d\t%d\t",  *optimal_score,g_sum_sw_score);
		fflush(stdout);
	}
}
void output_window_info_to_file(
	int scoreSP,
	int scoreUpper,
	int scoreOpt,
	int scoreImpExp,
	int scoreImp,
	int max_group_number_to_set)
{
	char output_filename[MAXNAMES];
	FILE* fp;
	int i,j;

	sprintf(output_filename,"%s.z%d.g%d.at%d.m%d.window",inputMsfFilename,WINDOW_SIZE,max_number_in_group,lastPositionInSequences[0],max_group_number_to_set);

	if((fp=fopen(output_filename,"wt"))==NULL)  
	{  
		printf("Cannot open file strike any key exit!");  
		exit(1);  
	}
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		for(j = 0; j < WINDOW_SIZE; j ++)
		{
			if(window[i][j])
			{
				fprintf(fp,"%c",window[i][j]->letter );
			}
			else
			{
				fprintf(fp,"-");
			}
		}
		fprintf(fp,"\n");
	}
	fprintf(fp,"\n");
	fprintf(fp,"scoreSP_before=%d\n",scoreSP);
	fprintf(fp,"scoreUpper=%d\n",scoreUpper);
	fprintf(fp,"scoreSP_after=%d\n",scoreOpt);
	fprintf(fp,"scoreImpExp=%d\n",scoreImpExp);
	fprintf(fp,"scoreImp=%d\n",scoreImp);
	fprintf(fp,"squence_count=%d\n",query_sequences_count_main);
	fprintf(fp,"max_number_in_group=%d\n",max_number_in_group);
	fprintf(fp,"g_sum_sw_score=%d\n",g_sum_sw_score);
	fprintf(fp,"iteration_times_k=%d\n",iteration_times_k);
	
	fclose(fp);
}

int processByFlexibleWindow()
{
	Boolean notDone;
	int scoreSP;
	int scoreUpper;
	int scoreOpt;
	int scoreImp;
	int scoreImpExp;
	int i;
	int j;
	int len;
	int beginPos;
	int beginPos2;

	int best_scoreOpt;
	NODE* best_alignment[MAXSEQ][WINDOW_ALIGNMENT_SIZE];
	int best_alignment_length;

#if  LINUX_MAIN
	long time_begin;
	long time_end;
#endif

	long time_total[7];

	int max_number_in_group_bak;
	int out;

	max_number_in_group_bak = max_number_in_group;

	for(i = 0; i < 7; i ++)
	{
		time_total[i] = 0;
	}

	windowBeginPos = 0;
	putInitialWindow();
	notDone = TRUE;

	
	//ret = set_group_flag_by_div(group_flag);
	//ret = set_group_flag_by_random(group_flag);
	//ret = set_group_flag_by_length(group_flag);
	//ret = set_group_flag_by_metis(group_flag);
	//ret = set_group_flag_by_min_gaps(group_flag);
	
	while(notDone)
	{
		best_scoreOpt = -MAXINT;

		scoreSP = getWindowSPScore(window,query_sequences_count_main,WINDOW_SIZE);
		scoreUpper = getWindowUpperBoundScore(window,query_sequences_count_main,WINDOW_SIZE);
		scoreImpExp = scoreUpper - scoreSP;

		if((scoreImpExp > 0) && (g_qoma1_run_count < g_b))
		{
			//max_number_in_group = max_group_number_lower_main;
			//while(max_number_in_group <= max_group_number_upper_main)
			{
				out = (max_number_in_group == max_number_in_group_bak)?1:0;
				if(debug > -1)
				{
					printf("%d\t%d\t%d\t",max_number_in_group, scoreSP,scoreUpper);
					fflush(stdout);
				}
				//*********************************************************************************************//
				if(0)
				{
					p_group_function = &set_group_flag_by_random;
					align_a_window(&scoreOpt, &scoreImp, scoreSP, best_alignment, &best_scoreOpt, &best_alignment_length,0);
				}
				//*********************************************************************************************//
				if(0)
				{
					p_group_function = &set_group_flag_by_length;
					align_a_window(&scoreOpt, &scoreImp, scoreSP, best_alignment, &best_scoreOpt, &best_alignment_length,0);
				}
				//*********************************************************************************************//
				if(0)
				{
					p_group_function = &set_group_flag_by_metis;
					min_cut_k_group_metis = 1;
					p_pairwise_score_function = &get_weight_of_2_groups_expectation;
				
					align_a_window(&scoreOpt, &scoreImp, scoreSP, best_alignment, &best_scoreOpt, &best_alignment_length,0);
				}
				//*********************************************************************************************//
				if(0)
				{
					p_group_function = &set_group_flag_by_metis;
					min_cut_k_group_metis = 1;
					p_pairwise_score_function = &get_weight_of_2_groups_combine_expectation_length;

					align_a_window(&scoreOpt, &scoreImp, scoreSP, best_alignment, &best_scoreOpt, &best_alignment_length,0);
				}
				//*********************************************************************************************//
				if(0)
				{
					p_group_function = &set_group_flag_by_min_gaps;
					min_cut_k_group_metis = 1;

					align_a_window(&scoreOpt, &scoreImp, scoreSP, best_alignment, &best_scoreOpt, &best_alignment_length,0);
				}
				//*********************************************************************************************//
				if(0)
				{
					p_group_function = &set_group_flag_by_metis;
					min_cut_k_group_metis = 0;
					p_pairwise_score_function = &get_weight_of_2_groups_expectation;

					align_a_window(&scoreOpt, &scoreImp, scoreSP, best_alignment, &best_scoreOpt, &best_alignment_length,0);
				}
				//*********************************************************************************************//
				if(0)
				{
					p_group_function = &set_group_flag_by_metis;
					min_cut_k_group_metis = 0;
					p_pairwise_score_function = &get_weight_of_2_groups_combine_expectation_length;

					align_a_window(&scoreOpt, &scoreImp, scoreSP, best_alignment, &best_scoreOpt, &best_alignment_length,0);
				}
				//*********************************************************************************************//
				if(1)
				{
					p_group_function = &set_group_flag_by_min_gaps;
					min_cut_k_group_metis = 0;

#if LINUX_MAIN
						gettimeofday( &tv_main, NULL );
						time_begin = 1000000 * ( tv_main.tv_sec  ) + tv_main.tv_usec;
#endif
					
						align_a_window(&scoreOpt, &scoreImp, scoreSP, best_alignment, &best_scoreOpt, &best_alignment_length,out);
					//	output_window_info_to_file(scoreSP,scoreUpper,scoreOpt,scoreImpExp,scoreImp,max_number_in_group_bak);
						

#if LINUX_MAIN
						gettimeofday( &tv_main, NULL );
						time_end = 1000000 * ( tv_main.tv_sec  ) + tv_main.tv_usec;
						time_total[max_number_in_group] += (time_end - time_begin);
#endif
	
				}
				//*********************************************************************************************//
							
				//copy back the best
				scoreOpt = best_scoreOpt;
				scoreImp = scoreOpt - scoreSP;
				copy_window_alignment(best_alignment,windowAlignment,best_alignment_length);
				windowAlignmentLength = best_alignment_length;
				//max_number_in_group ++;
			}
			if(debug > -1)
			{
				printf("\n");
			}
			max_number_in_group = max_number_in_group_bak;
		}
		else
		{
			windowAlignmentLength = WINDOW_SIZE;
			for(i = 0; i < query_sequences_count_main; i ++)
			{
				for(j = 0; j < WINDOW_SIZE; j ++)
				{
					windowAlignment[i][j] = window[i][j];
				}
			}
			scoreImp = 0;
		}

		//**************************************************************//
		//here we output the window and alignment information to file   //
		//**************************************************************//
	
		//**************************************************************//
	
		if(scoreImp < 0)
		{
			//copybackWindowToAlignment();
			windowAlignmentLength = WINDOW_SIZE;
			for(i = 0; i < query_sequences_count_main; i ++)
			{
				for(j = 0; j < WINDOW_SIZE; j ++)
				{
					windowAlignment[i][j]  = window[i][j];
				}
				windowAlignment[i][j] = 0;
			}
		}
		

	
		notDone = setLastRColumnsOfWindow();
		
		if( windowAtBegin)
		{
			continue;
		}
		setOtherPartOfWindowFromWindowAlignment();

		if( ++ g_qoma1_run_count >= g_b)
		{
			break;
		}
		addPartialWindowAlignmentToAlignment();

		if( !notDone)
			break;
		//g_qoma1_sp_score[g_qoma1_run_count] = scoreImp + g_qoma1_sp_score[g_qoma1_run_count - 1] ;
		
	
	}
	if(g_qoma1_run_count >= g_b)
	{
		addWindowAlignmentToAlignment();
		for(j = 0; j < query_sequences_count_main; j ++)
		{
			beginPos = resultAlignmentLength[j];
					
			beginPos2 = lastPositionInSequences[j] - (WINDOW_SIZE + 1)/2 + 1 ;
			
			len = sequencesLength[j] - beginPos2;
			
			for( i = 0; i < len; i ++)
			{
				resultAlignment[j][i + beginPos] = sequences[j][i + beginPos2 ];
			}
			resultAlignmentLength[j] += len;
		}
	}
	else
	{
		setOptimalAlignment();
		addWindowAlignmentToAlignment();
	}
	

	for(i = max_group_number_lower_main; i <= max_group_number_upper_main; i ++)
	{
		fprintf(output_file_main,"time_total[%d]=%ld\n",i,time_total[i]);
	}
	return g_qoma1_run_count;
}
int processByLocatedWindow_greedy()
{
	Boolean notDone;
	int scoreSP;

	int scoreOpt;
	int scoreImp;
	int scoreImpExp;
	int bestExpPos;
	int bestExp;
	int disabled_flag[MAXLEN];
	int i;
	int delta;
	int beginPos;
	int endPos;

	double gapPercent;
	double combine_factor;
	int total_run;

	int best_scoreOpt;
	NODE* best_alignment[MAXSEQ][WINDOW_ALIGNMENT_SIZE];
	int best_alignment_length;

#if  LINUX_MAIN
	long time_begin;
	long time_end;
#endif

	long time_total[7];

	int max_number_in_group_bak;

	for(i = 0; i < 7; i ++)
	{
		time_total[i] = 0;
	}
	total_run = 0;

	windowBeginPos = 0;
	putInitialWindow();
	notDone = TRUE;
	
	bestExp = -MAXINT;

	max_group_number_lower_main = max_number_in_group;
	max_group_number_upper_main = max_number_in_group;
	max_number_in_group_bak = max_number_in_group;


	//*****************************************************************************************//
	//now start to iterate                                                                     //
	//*****************************************************************************************//
	delta = 0;//WINDOW_SIZE / 8;
	notDone = 1;

	initResultAlignment();
	//printf("Scan again!!!\n");
	for( i = 0; i < exp_record_count; i ++)
	{
		disabled_flag[i] = 0;
	}
	for( i = exp_record_count; i < 2000; i ++)
	{
		disabled_flag[i] = 1;
	}
	bestExp = -MAXINT;
	printf("//*****************************************************************************************//\n");
	printf("exp_record_count = %d\n",exp_record_count);
	printf("//*****************************************************************************************//\n");
	/* this is to test, the result will be higher if have it*/
	if(testing_higher)
	{
		for(i = 0; i < exp_record_count; i ++)
		{
			if(exp_records[i].actual_improvement_score <= 0)
			{
				disabled_flag[i] = 1;
			}
		}
	}
	p_group_function = &set_group_flag_by_min_gaps;
	min_cut_k_group_metis = 0;

	while(notDone)
	{
		//find the best score in the array, which is one disabled.
		bestExp = -MAXINT;
		notDone = 1;
		for(i = 0; i < exp_record_count + 1; i ++)
		{
			scoreImpExp = exp_records[i].expection_improvement_score;
		
			if((scoreImpExp > bestExp) &&(!disabled_flag[i]) &&(scoreImpExp >=0))
			{
				bestExp = scoreImpExp;
				bestExpPos = i;
			}
		}

		windowBeginPos = bestExpPos;
		scoreImpExp = bestExp;
		
		if( scoreImpExp <= 0) 
		{
			break;
		}
		setNextWindowFromResultAlignment();
		gapPercent = getGapPercentOfWindow();
		combine_factor = gapPercent*scoreImpExp;
		//if((gapPercent < 0.06) || (combine_factor < 1) || (scoreImpExp < 1 * WINDOW_SIZE / 2) ) // disable this filter for testing
		if(0)
		{

			disabled_flag[windowBeginPos] = 1;
			notDone = 0;
			for(i = 0; i < exp_record_count; i ++)
			{
				if(!disabled_flag[i])
				{
					notDone = 1;
					break;
				}
			}
			if( !notDone)
			{
				break;
			}
			total_run ++;
			continue;
		}

		if( !notDone)
		{
			break;
		}
		//*********************************************************************************************//
		scoreSP = getWindowSPScore(window,query_sequences_count_main,WINDOW_SIZE);
		if(1)
		{
		
				
#if LINUX_MAIN
			gettimeofday( &tv_main, NULL );
			time_begin = 1000000 * ( tv_main.tv_sec  ) + tv_main.tv_usec;
#endif
					
			align_a_window(&scoreOpt, &scoreImp, scoreSP, best_alignment, &best_scoreOpt, &best_alignment_length,1);
			//	output_window_info_to_file(scoreSP,scoreUpper,scoreOpt,scoreImpExp,scoreImp,max_number_in_group_bak);
#if LINUX_MAIN
			gettimeofday( &tv_main, NULL );
			time_end = 1000000 * ( tv_main.tv_sec  ) + tv_main.tv_usec;
			time_total[max_number_in_group] += (time_end - time_begin);
#endif
		
		}
				//copy back the best
		scoreOpt = best_scoreOpt;
		scoreImp = scoreOpt - scoreSP;
		copy_window_alignment(best_alignment,windowAlignment,best_alignment_length);
		windowAlignmentLength = best_alignment_length;

		printf("q2: windowBeginPos=%d,g_qoma2_run_count=%d\t",windowBeginPos,g_qoma2_run_count);

		if(	scoreImp >= 0)
		{
			replaceAlginment(windowBeginPos);
			//update_exp_records();
			g_qoma2_run_count ++;
		}
		
		if(g_qoma2_run_count >= g_b)
		{
			break;
		}

		total_run ++;
	
		if((total_run > exp_record_count * 10) || (total_run > g_qoma1_run_count * 10) )
		{
			break;
		}

		beginPos = windowBeginPos - delta;
		endPos = windowBeginPos + delta;
		if(beginPos < 0)
		{
			beginPos = 0;
		}
		if(endPos >= exp_record_count)
		{
			for( i = exp_record_count; i < endPos; i ++)
			{
				disabled_flag[i] = 1;
			}
			endPos = endPos - 1;

		}
		for(i = beginPos; i <= endPos; i ++)
		{
			disabled_flag[i] = 1;
		}
	
		notDone = 0;
		
		for(i = 0; i < exp_record_count; i ++)
		{
			if(!disabled_flag[i])
			{
				notDone = 1;

				break;
			}
		}
		if( !notDone)
		{
		
			break;
		}
	}
	return 0;
}
Boolean setInitialAlignment()
//this function assume it has the filename set to global variable inputMsfFilename
//the result will be stored into sequences[MAXSEQ][MAXLEN];
{
	NODE* sequences1[MAXSEQ][MAXLEN];
	int sequencesLength1[MAXSEQ];
	int length;
	int i;
	int j;

	if(useReducedDirection)
	{
		allowGapInput = TRUE;
		readSequencesFromMsf(inputMsfFilename);
		//copy to temp array
		for( i = 0; i < query_sequences_count_main; i ++)
		{
			for( j = 0; j < sequencesLength[i]; j ++)
			{
				sequences1[i][j] = sequences[i][j];
			}
			sequencesLength1[i] =  sequencesLength[i];
		}
		//set sequence to non- gap array
		for( i = 0; i < query_sequences_count_main; i ++)
		{
			length = 0;
			for( j = 0; j < sequencesLength1[i]; j ++)
			{
				if(!isGap(sequences1[i][j]->letter))
				{
					sequences[i][length] = sequences1[i][j];
					length ++;
				}
			}
			sequencesLength[i] = length ;
		}
		set_link = 1;
		setLinks();
		set_link = 0;
		//printoutPairwiseAlignment();
		//save this non-gap array to bak
		for( i = 0; i < query_sequences_count_main; i ++)
		{
			for( j = 0; j < sequencesLength[i]; j ++)
			{
				sequences2[i][j] = sequences[i][j];
			}
			sequencesLength2[i] = sequencesLength[i] ;
		}
		//copy back to with gap one
		for( i = 0; i < query_sequences_count_main; i ++)
		{
			for( j = 0; j < sequencesLength1[i]; j ++)
			{
				sequences[i][j] = sequences1[i][j];
			}
			sequencesLength[i] = sequencesLength1[i] ;
		}
		
	}
	else
	{
		//read Input File
			//set sequence to non- gap array
		
		allowGapInput = TRUE;
		readSequencesFromMsf(inputMsfFilename);
		for( i = 0; i < query_sequences_count_main; i ++)
		{
			sequencesLength1[i] = 0 ;
		}
	}
	return TRUE;
}


Boolean	putInitialWindow()
{
	int i;
	windowBeginPos = 0;
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		lastPositionInSequences[i] = -1;
		resultAlignmentLength[i] = 0;
	}
	setNextWindow();
	return TRUE;
}

Boolean setOptimalAlignment()
{	
	if(useKGroup)
	{
		setAlignmentByKGroup(); //random
	}
	else if(useReducedDirection)
	{
		setAlignmentFromWindowByLinks();
	}
	else
	{
		setOptimalAlignmentFromWindow();
	}
	return TRUE;
}
Boolean	putBlock()
// the block aligned  begins at windowBeginPos, size WINDOW_SIZE from windowAlignment
// the result block in windowAlignment,size windowAlignmentLength
// put this block to resultAlignment
// adjust the length accordingly
{	
	int i;
	int j;
	int beginPos;
	

	if(!windowAlignmentLength)
	{
		return FALSE;
	}

	for(j = 0; j < query_sequences_count_main; j ++)
	{
		beginPos = resultAlignmentLength[j];
		for( i = 0; i < windowAlignmentLength; i ++)
		{
			resultAlignment[j][i + beginPos] = windowAlignment[j][i];
		}
		resultAlignmentLength[j] += windowAlignmentLength;
	}
	windowBeginPos = windowBeginPos + WINDOW_SIZE;
	return TRUE;
}

Boolean	setNextWindow()
//set to next window
//based on windowBeginPos and WINDOW_SIZE
{	
	int i;
	int j;
	Boolean end;

	end = FALSE;
	for(i =0 ; i < WINDOW_SIZE; i ++)
	{
		for(j = 0; j < query_sequences_count_main;  j ++)
		{
			if((i+windowBeginPos) < sequencesLength[j])
			{
				window[j][i] = sequences[j][i+windowBeginPos];

			}
			else
			{
				window[j][i] = getNewNode('-');
				end = TRUE;
			}
		}
	}
	for(j = 0; j < query_sequences_count_main;  j ++)
	{
		if(end)
		{
			lastPositionInSequences[j] = sequencesLength[j] -1;
		}
		else
		{
			lastPositionInSequences[j] = lastPositionInSequences[j] + WINDOW_SIZE;
		}
	}
	return (!end);
}
Boolean isGap(char letter)
{
	if((letter=='.')||(letter=='-')||(letter=='*'))
		return 1;
	else
		return 0;
}

Boolean setOtherPartOfWindowFromWindowAlignment()
//set other part of window filled by window alignment
{
	int i;

	positionInWindowAlignment = windowAlignmentLength - 1;
	if(positionInWindow < 0)
	{
		return FALSE;
	}
	for( ; positionInWindowAlignment >= 0; positionInWindowAlignment --)
	{
		for( i = 0; i < query_sequences_count_main; i ++)
		{
			window[i][positionInWindow] = windowAlignment[i][positionInWindowAlignment];
		}
		positionInWindow --;
		if(positionInWindow < 0)
		{
			break;
		}
	}
	return TRUE;
}

Boolean addPartialWindowAlignmentToAlignment()
//Add the rest of window alignment to existing alignment
{
	int i;
	int j;
	int beginPos;

	if(!windowAlignmentLength)
	{
		return FALSE;
	}

	for(j = 0; j < query_sequences_count_main; j ++)
	{
		beginPos = resultAlignmentLength[j];
		for( i = 0; i < positionInWindowAlignment; i ++)
		{
			resultAlignment[j][i + beginPos] = windowAlignment[j][i];
		}
		resultAlignmentLength[j] += i;
	}
	
	return TRUE;
}

Boolean addWindowAlignmentToAlignment()
//Add the rest of window alignment to existing alignment
{
	int i;
	int j;
	int beginPos;

	if(!windowAlignmentLength)
	{
		return FALSE;
	}

	for(j = 0; j < query_sequences_count_main; j ++)
	{
		beginPos = resultAlignmentLength[j];
		for( i = 0; i < windowAlignmentLength; i ++)
		{
			resultAlignment[j][i + beginPos] = windowAlignment[j][i];
		}
		resultAlignmentLength[j] += i;
	}
	
	return TRUE;
}

void setGroupNodeClusterFromWindow()
//set the nodes to groupNodeCluster from window
//also set the lengths
{
	int i;
	int j;
	int index;

	groupNodeClustersCount = query_sequences_count_main;

	//first reset the groupNodeClusters and groupNodeClusterNo
	for(i = 0; i < MAX_SEQ_WITH_PATTERN;i++)
	{
		for ( j  = 0; j < MAX_NODES_IN_PATTERN_FOR_CLUSTER; j ++)
		{
			groupNodeClusters[i][j] = 0;
		}
	}
	for(i = 0; i < MAX_SEQ_WITH_PATTERN;i++)
	{
		groupNodeClusterNo[i]  = -1;
	}
	
	for(i = 0; i < query_sequences_count_main;i++)
	{
			
		groupNodeClusterNo[i] = i;
		index = 0;	
		
		//set the value
		for ( j  = 0; j < WINDOW_SIZE; j ++)
		{
			groupNodeClusters[i][j] = window[i][j];
			index ++;
		}//for
		
		groupNodeClusterLength[i] = index;
	}
}
void setWindowAlignmentFromGroupNodeClusters()
{
	int i;
	int j;
	
	for(i = 0;i < query_sequences_count_main; i++)
	{
		for(j = 0; j < groupNodeClusterLength[i]; j ++)
		{
			windowAlignment[i][j] =  groupNodeClusters[i][j];
		}
		
	}
	windowAlignmentLength = groupNodeClusterLength[0];
}

int getSequenceScore()
//only for compute aligned sequence
{
	int i;
	int j;
	int k;
	int score;
	score = 0;
	for( k = 0; k < sequencesLength[0]; k++)
	{
		for( i = 0; i < query_sequences_count_main; i ++)
		{
			for( j = i + 1; j < query_sequences_count_main; j ++)
			{
				score = score + getRoughScoreOfTwoNodes(sequences[i][k],sequences[j][k]);
			}
		}
	}
	return score;
}

void setDimensionGroupK3(int dimensionGroup[MAXSEQ], int dimensionCount, int dimensionPos[MAXSEQ],NODE* compactWindow[MAXSEQ][WINDOW_SIZE])
//this needs o(K^3)
//this one check the nodes from compactWindow at dimensionPos
//set groups in dimensionGroup
{
	int i;
	int j;
	int k;
	NODE* nodesArray[MAXSEQ];
	NODE* node1;
	NODE* node2;
	//initialize
	for ( i = 0; i < dimensionCount ; i ++)
	{
		//for each dimension 
		dimensionGroup[i] = i;
		//travel all other dimension
		if(dimensionPos[i]>=1)
		{
			nodesArray[i] = compactWindow[i][dimensionPos[i]-1];
		}
		else
		{
			//this is on edge
			//set same group and return;
			for ( j = 0; j < dimensionCount ; j ++)
			{
				dimensionGroup[j] = 0;
			}
			return;
		}
	}
	
	//check each pair to set group

	for ( i = 0; i < dimensionCount ; i ++)
	{
		for ( j =  i+1; j < dimensionCount ; j ++)
		{
			node1 = nodesArray[i];
			node2 = nodesArray[j];
			//check if they have link to each other
			if((!node1)||(!node2))
				continue;
			if(node1->edgeCount==0)
				continue;
			for( k = 0; k < query_sequences_count_main; k ++)
			{
				if(node1->edgePos[k] >= 0)
				{
					if(sequences2[k][node1->edgePos[k]]==node2)
					{
						//same group
						dimensionGroup[i] = MIN(dimensionGroup[i],dimensionGroup[j]);
						dimensionGroup[j] = dimensionGroup[i];
					}//	if(sequences[node1->edgePos[k])==node2)
				}// if(node1->edgePos[k] >= 0)
			}//for( k = 0; k < query_sequences_count_main; k ++)
			
		}
	}
}
Boolean isInSameGroup(int multipleDirection[MAXSEQ], int dimensionGroup[MAXSEQ], int dimensionCount)
//check if this direction array has all directions in same group
//directions in different group can not be same
{
	int i;
	int j;
	for(i = 0; i < dimensionCount; i ++)
	{
		for(j = 0; j < dimensionCount; j ++)
		{
			//different group 
			//both 1 means a match
			if(dimensionGroup[i] != dimensionGroup[j])
			{
				if((multipleDirection[i] == multipleDirection[j])
					&&(multipleDirection[i] == 1))
				{
					return 0;
				}
			}
		}
	}
	return 1;
}

int setAlignmentFromWindowByLinks()
//using extension of w-m danymic programming
//reduce the direction searching space by only considering the nodes have links
//get the optimal multiple alignment 
//result set to windowAlignment, the length set to windowAlignmentLength
{
	//first initialize the score array

	int dimensionCount; 
	//this dimensionCount is how many dimension ,that is , how many actual fragments
	NODE* compactWindow[MAXSEQ][WINDOW_SIZE];
	//this is window compacted,without gaps
	int fragmentLength[MAXSEQ];
	//the actual length of each fragment in window
	Boolean fragmentEmptyFlag[MAXSEQ];
	//the actual fragment is empty?
	int dimensionLength[MAXSEQ];
	//this to store the lengthes of sequences fragment,similar to rowLength and colLength
	//int multipleDimensionScore[SPACE_SIZE];
	int* multipleDimensionScore;
	//this array is scores for multiple dimension, need to compute location with
	//dimensionPos array
	int dimensionPos[MAXSEQ];
	//this array is the multiple axis pos
   	//int multipleDimensionTrack[SPACE_SIZE];
	int dimensionGroup[MAXSEQ];

	//this array indicate the nodes in dimensions are in same group or not
	//same value means same group
	short int* multipleDimensionTrack;
	//this array is to track back;also used with dimensionPos array
	int i,j;
	//this is to tempary store scores of multiple dimension, 
	//for later comparison.
	//totally it should have 2^dimensionCount - 1 scores
	int multipleDirection[MAXSEQ];
	//record the direction information, 
	//1 indicate go along the direction
	//0 means not go along the direction
	
	int direction;
	//it is to compute multipleDirection
	int directionCount;
	//it is the count of total directions

	int alignmentScore;
	int cellValue;
	int maxValue;
	int maxDirection;
	NODE* temp[MAXSEQ][WINDOW_ALIGNMENT_SIZE];
	int alignmentPos;
	int alignmentLength;
	Boolean gapColumn;
	int index;
	int k;
	int nodesCountInGroup;
	int totalDirection;
	int groupDirection;


    // initialize
	//first set compact window
	dimensionCount = 0;
	for(i =0 ; i < query_sequences_count_main ; i ++)
	{
		fragmentEmptyFlag[i] = FALSE;
		fragmentLength[dimensionCount] = 0;
		for( j = 0 ; j < WINDOW_SIZE; j ++)
		{
			if((window[i][j])&&(!isGap(window[i][j]->letter)))
			{
				compactWindow[dimensionCount][fragmentLength[dimensionCount]] = window[i][j];
				fragmentLength[dimensionCount] ++;
			}
		}
		if(fragmentLength[dimensionCount]>0)
		{
			dimensionCount ++;
		}
		else
		{
			fragmentEmptyFlag[i] = TRUE;
		}
	}
	
	//compute the whole one dimension array size
	//fix one dimension to 0,set values for all posibiity of other dimension
	for ( i = 0; i < dimensionCount ; i ++)
	{
		//for each dimension 
		dimensionPos[i] = 0;
		dimensionLength[i] = fragmentLength[i];
		
		//travel all other dimension
	}
	N = 1;
	directionCount = 1;
	for ( i = 0; i < dimensionCount; i ++)
	{
		N = (dimensionLength[i] + 1)* N;
		directionCount = 2*directionCount;
	}
	N--;
	
	if((multipleDimensionScore=(int*) malloc((N + 2)*sizeof(int)))==NULL)
	//add 1 to prevent overflow
	{
		printf("unable to allocate memory for multipleDimensionScore.");
		exit(1);
	}
	if((multipleDimensionTrack=(short int*) malloc((N + 2)*sizeof(short int)))==NULL)
	//add 1 to prevent overflow
	{
		printf("unable to allocate memory for multipleDimensionTrack.");
		exit(1);
	}
	for( i = 0; i < N + 1; i ++)
	{
		multipleDimensionScore[i] = 0;
		multipleDimensionTrack[i] = 0;
	}


	//E(i, 0) = gap_open + i x gap_extend

	//THIS is the position [0,0,..,0]
    multipleDimensionScore[0] = 0;
	//For the track array:multipleDimensionTrack, each position has a value between 2^query_sequences_count_main and 1
	//this value indicates the direction it gets, 
	//it is computed from a direction array,which has length of query_sequences_count_main,
	//the elements in this direction array use 
	//1 indicate there is a movement from previos cell along this dimension
	//0 indicate it is same (match) on this dimension
	
    //begin to calculate

	
	for (i = 1; i <= N; i ++)
    {
		//first compute the position of multiple dimension cell
	
		setMultipleDimensionPointInArrayFromPosition(i, dimensionPos,dimensionCount,dimensionLength);
		setDimensionGroup(dimensionGroup,dimensionCount,dimensionPos,compactWindow);
		
	
		//then compute the value of this cell
		//for each dimension,test value of pos - 1, and pos
		//so it has loop indicator value between 2^query_sequences_count_main and 1
		maxValue = -MAXINT;
		maxDirection = 0;
		//check each group
		for(k = 0; k < dimensionCount; k ++)
		{
			//check if the group has been processed
			if( dimensionGroup[k] < k)
			{
				continue;
			}
			nodesCountInGroup = getNodesCountInGroup(dimensionGroup,k);
			totalDirection = power(2,nodesCountInGroup) ;
			for( groupDirection = 1; groupDirection < totalDirection; groupDirection ++)
			{
				//get value for this direction
				//first set multipleDirection
				setMultipleDirectionByGroup(groupDirection,dimensionGroup,k,multipleDirection,dimensionCount);
				//get the value of the cell for this direction
				cellValue = getScoreOfCell(multipleDimensionScore,dimensionPos,multipleDirection,dimensionCount,dimensionLength,compactWindow);
				if(cellValue > maxValue)
				{
					maxValue = cellValue;
					maxDirection = getDirectionOfMultipleDirection(multipleDirection,dimensionCount);
				}
			}
		}
		//record the direction
		if(maxValue > -MAXINT)
		{
			multipleDimensionScore[i] = maxValue;
			multipleDimensionTrack[i] = maxDirection;
		}
		else
		{
			return -MAXINT;
		}
	}//for i

	
	//after alignment score matrix set, here need to track back

	//get the dimension pos at the last
	for ( i = 0; i < dimensionCount; i ++)
	{
		dimensionPos[i] = dimensionLength[i];
	}
	//or
	//setMultipleDimensionPointInArrayFromPosition(N, dimensionPos);
	i = N;
	i = getPositionOfMultipleDimensionPointInArray(dimensionPos,dimensionCount,dimensionLength);
	alignmentPos = WINDOW_ALIGNMENT_SIZE - 1;
	alignmentLength = 0;

	
	while( i > 0)
	{
		
		//get the direction
		direction = multipleDimensionTrack[i];
		setMultipleDirection(direction, multipleDirection,dimensionCount);
		for ( j = 0; j < dimensionCount; j ++)
		{
			if(multipleDirection[j] == 1)
			{
				//a step along this direction
				
				temp[j][alignmentPos] = compactWindow[j][dimensionPos[j] -1];
				dimensionPos[j] --;
			}
			else
			{
				//a gap along this direction
				
				temp[j][alignmentPos] = 0;
				//dimensionPos[j] --;
			}
		}
		alignmentPos --;
		alignmentLength ++;
		i = getPositionOfMultipleDimensionPointInArray(dimensionPos,dimensionCount,dimensionLength);
	}

	
	
	//set back to windowAlignment
	windowAlignmentLength = 0;
	for ( i = 0; i < alignmentLength; i ++)
	{
		//check if it is a gap column 
		gapColumn = TRUE;
		for ( j = 0; j < dimensionCount; j ++)
		{ 
			//windowAlignment[j][i] = temp[j][alignmentPos +1  + i];
			if((temp[j][alignmentPos +1  + i])&&
				(!isGap(temp[j][alignmentPos +1  + i]->letter)))
			{
				gapColumn = FALSE;
				break;
			}
		}
		if(!gapColumn)
		{
			index = 0;
			for ( j = 0; j < query_sequences_count_main; j ++)
			{ 
				if(!fragmentEmptyFlag[j])
				{
					windowAlignment[j][windowAlignmentLength] = temp[index++][alignmentPos +1  + i];
				}
				else
				{
					windowAlignment[j][windowAlignmentLength] = 0;
				}
			}
			windowAlignmentLength ++;
		}
	}

	alignmentScore = multipleDimensionScore[N];

	free(multipleDimensionScore);
	free(multipleDimensionTrack);

	return alignmentScore;
}

int getNodesCountInGroup(int dimensionGroup[MAXSEQ],int groupIndex)
//get the total node number of group index in dimensionGroup
{
	int i;
	int count;
	count = 0;
	for( i = 0; i < query_sequences_count_main; i ++)
	{
		if(dimensionGroup[i] == groupIndex)
		{
			count++;
		}
	}
	return count;
}

int power(int base,int powerValue)
{
	int i;
	int result;
	result = 1;
	if(base == 0)
	{
		return 0;
	}
	if(powerValue == 0)
	{
		return 1;
	}
	for( i = 0; i < powerValue; i ++)
	{
		result *= base;
	}
	return result;
}

void setMultipleDirectionByGroup(int groupDirection,int dimensionGroup[MAXSEQ],int groupIndex,int multipleDirection[MAXSEQ],int dimensionCount)
//set a bit vector first.
//according the bit vector, set the appropriate value in multipleDirection
//padding 0 to other location in multipleDirection
{
	int i;
	int value;
	//first get the bit vector
	for( i = dimensionCount -1; i >= 0; i --)
	{
		//check if this is a location need to set
		if( dimensionGroup[i] == groupIndex)
		{
			//yes, need to set
			//get the last bit in groupDirection
			value = groupDirection & (0x1);
			//modify the value of group for next loop
			groupDirection = groupDirection>>1;
			//set the value to correct location of multipleDirection
			multipleDirection[i] = value;
		}
		else
		{
			//padding by 0
			multipleDirection[i] = 0;
		}		
	}
	
}

void setDimensionGroup(int dimensionGroup[MAXSEQ], int dimensionCount, int dimensionPos[MAXSEQ],NODE* compactWindow[MAXSEQ][WINDOW_SIZE])
//this one check the nodes from compactWindow at dimensionPos
//set groups in dimensionGroup
{
	int i;
	int j;
	int k;
	NODE* nodesArray[MAXSEQ];
	NODE* node1;

	int groupIndex;
	int compactIndex[MAXSEQ];//index of compact array,map from query_sequences_count_main to dimensionCount
	int compactArrayIndex;
	int beginPos;
	int endPos;

	int groupValueToChange;
	int groupIndexToChange;

	
	//initialize
	for ( i = 0; i < query_sequences_count_main ; i ++)
	{
		nodesArray[i] = 0;
		dimensionGroup[i] = - MAXINT;
	}
	for ( i = 0; i < dimensionCount ; i ++)
	{
		//for each dimension 
		dimensionGroup[i] = i;
		//travel all other dimension
		if(dimensionPos[i]>=1)
		{
			//this make the array index corresponds to sequenceNo
			node1 = (compactWindow[i][dimensionPos[i]-1]);
			nodesArray[node1->sequenceNo] = node1;
			compactIndex[node1->sequenceNo] = i;
		}
		else
		{
			//this is on edge
			//set same group and return;
			for ( j = 0; j < dimensionCount ; j ++)
			{
				dimensionGroup[j] = 0;
			}
			return;
		}
	}
	
	
	//check each edge to set group
	groupIndex = -1;
	for ( i = 0; i < query_sequences_count_main ; i ++)
	{
		node1 = nodesArray[i];

		if((!node1))
			continue;
		groupIndex ++;
		//if(node1->edgeCount==0)
		//	continue;
		//check all edges
		for( k = i + 1; k < query_sequences_count_main; k ++)
		{
		
     		//check the other end ,see if it is in distance of d from node1
			if(!nodesArray[k])
			{
				continue;
			}
			if(node1->edgePos[k] >= 0)
			{
				beginPos = node1->edgePos[k] - distanceError;
				if(beginPos < 0)
				{
					beginPos = 0;
				}
				endPos = node1->edgePos[k] + distanceError;
				if(endPos >= sequencesLength2[k])
				{
					endPos = sequencesLength2[k] - 1;
				}
				if(((nodesArray[k]->indexWithoutGap >= beginPos)
					&&(nodesArray[k]->indexWithoutGap <= endPos))
					||(nodesArray[k]->indexWithGap == node1->indexWithGap))
				{
					compactArrayIndex = compactIndex[k];

					//changed on 09-13-2006
					
					groupValueToChange = MIN(dimensionGroup[groupIndex],dimensionGroup[compactArrayIndex]);
					groupIndexToChange = dimensionGroup[compactArrayIndex];
					for( j = 0; j < dimensionCount; j ++)
					{
						if( dimensionGroup[j] ==  groupIndexToChange)
						{
							dimensionGroup[j] = groupValueToChange;
						}
					}
					groupIndexToChange = dimensionGroup[groupIndex];
					for( j = 0; j < dimensionCount; j ++)
					{
						if( dimensionGroup[j] ==  groupIndexToChange)
						{
							dimensionGroup[j] = groupValueToChange;
						}
					}
					//dimensionGroup[compactArrayIndex] = MIN(dimensionGroup[groupIndex],dimensionGroup[compactArrayIndex]);
					//dimensionGroup[groupIndex] = dimensionGroup[compactArrayIndex];
				
				}
			}// if(node1->edgePos[k] >= 0)
			else
			{
				//this node here corresponds a gap
				//need to check back 
				//check d nodes before and after node1 with 
				
				beginPos = node1->indexWithoutGap - distanceError;
				if(beginPos < 0)
				{
					beginPos = 0;
				}
				endPos = node1->indexWithoutGap + distanceError;
				if(endPos >= sequencesLength2[node1->sequenceNo])
				{
					endPos = sequencesLength2[node1->sequenceNo] - 1;
				}
				if(((nodesArray[k]->edgePos[node1->sequenceNo] >= beginPos)
					&&(nodesArray[k]->edgePos[node1->sequenceNo] <= endPos))
					||(nodesArray[k]->indexWithGap == node1->indexWithGap))
				{
					compactArrayIndex = compactIndex[k];
					//dimensionGroup[compactArrayIndex] = MIN(dimensionGroup[groupIndex],dimensionGroup[compactArrayIndex]);
					//dimensionGroup[groupIndex] = dimensionGroup[compactArrayIndex];

					//changed on 09-13-2006	
					groupValueToChange = MIN(dimensionGroup[groupIndex],dimensionGroup[compactArrayIndex]);
					groupIndexToChange = dimensionGroup[compactArrayIndex];
					for( j = 0; j < dimensionCount; j ++)
					{
						if( dimensionGroup[j] ==  groupIndexToChange)
						{
							dimensionGroup[j] = groupValueToChange;
						}
					}
					groupIndexToChange = dimensionGroup[groupIndex];
					for( j = 0; j < dimensionCount; j ++)
					{
						if( dimensionGroup[j] ==  groupIndexToChange)
						{
							dimensionGroup[j] = groupValueToChange;
						}
					}
				}
			}
			//check this node, 
		}//for( k = 0; k < query_sequences_count_main; k ++)
			
	}
}


int getWindowSPScore(NODE* window[MAXSEQ][WINDOW_SIZE],int sequencesCount,int length)
//only for compute aligned sequence
{
	int i;
	int j;
	int k;

	int score;

	matrixUsed = BLOSUM62;
	score = 0;

	score = 0;
	for( k = 0; k < length; k++)
	{
		for( i = 0; i < sequencesCount; i ++)
		{
			for( j = i + 1; j < sequencesCount; j ++)
			{
				//if((lengths[i]>0) &&(lengths[j]>0))
				{
					score = score + getRoughScoreOfTwoNodes(window[i][k],window[j][k]);
				}
			}
		}
	}
	return score;
}
int getWindowAlignmentSPScore(NODE* windowAlignment[MAXSEQ][WINDOW_ALIGNMENT_SIZE],int sequencesCount,int length)
//only for compute aligned sequence
{

	int i;
	int j;
	int k;

	int score;
	int column_score;

	matrixUsed = BLOSUM62;
	score = 0;

	for( k = 0; k < length; k++)
	{
		column_score = 0;
		for( i = 0; i < sequencesCount; i ++)
		{
			for( j = i + 1; j < sequencesCount; j ++)
			{
				//if((lengths[i]>0) &&(lengths[j]>0))
				{
					column_score = column_score + getRoughScoreOfTwoNodes(windowAlignment[i][k],windowAlignment[j][k]);
				}
			}
		}
		score = score + column_score;
	
	}
	return score;
}
int getWindowUpperBoundScore(NODE* window[MAXSEQ][WINDOW_SIZE],int sequencesCount,int length)
{
	 
	int row;
	int col;
	int score;
	NODE* seqs[MAXSEQ][WINDOW_SIZE];
	int lengths[MAXSEQ];
	matrixUsed = BLOSUM62;
	score = 0;
	for(row = 0;row<query_sequences_count_main;row ++)
	{
		lengths[row] = 0;
		for(col = 0;col<length;col++)
		{
			if(!window[row][col])
			{
				continue;
			}
			if(isGap(window[row][col]->letter))
			{
				continue;
			}
			if(!(isalpha(window[row][col]->letter)))
			{
				continue;
			}

			seqs[row][lengths[row]] = window[row][col];
			lengths[row]++;
		}

	}

    for(row = 0;row<query_sequences_count_main;row ++)
	{
		for(col = row+1;col< query_sequences_count_main;col++)
		{
		
			score +=(alignTwoNodeSequenceArray(seqs[row],seqs[col],lengths[row],lengths[col]));
		}
	}
	return score;
}
int getWindowAlignmentUpperBoundScore(NODE* windowAlignment[MAXSEQ][WINDOW_ALIGNMENT_SIZE],int sequencesCount,int length)
{
	 
	int row;
	int col;
	int score;
	NODE* seqs[MAXSEQ][WINDOW_ALIGNMENT_SIZE];
	int lengths[MAXSEQ];
	matrixUsed = BLOSUM62;
	score = 0;
	for(row = 0;row<query_sequences_count_main;row ++)
	{
		lengths[row] = 0;
		for(col = 0;col<length;col++)
		{
			if(!windowAlignment[row][col])
			{
				continue;
			}
			if(isGap(windowAlignment[row][col]->letter))
			{
				continue;
			}
			seqs[row][lengths[row]] = windowAlignment[row][col];
			lengths[row]++;
		}
	}

    for(row = 0;row<query_sequences_count_main;row ++)
	{
		for(col = row +1;col< query_sequences_count_main;col++)
		{
			score +=(alignTwoNodeSequenceArray(seqs[row],seqs[col],lengths[row],lengths[col]));
		
		}
	}
	return score;
}
//this function initial the global viable resultAlignment from sequences
void initResultAlignment()
{
	int i;
	int j;

	for(i = 0; i < query_sequences_count_main; i ++)
	{
		resultAlignmentLength[i] = sequencesLength[i];
		for(j = 0; j < sequencesLength[i]; j ++)
		{
			resultAlignment[i][j] = sequences[i][j];
		}
	}
}
//this function replace the block in resultAlignment at pos with the windowAlignment
//change the length accordingly
void replaceAlginment(int beginPos)
{
	int diff;
	int j;
	int i;


	diff = windowAlignmentLength - WINDOW_SIZE;
	//move back or first
	if(diff > 0)
	{
		for(i = 0; i < query_sequences_count_main; i ++)
		{
			resultAlignmentLength[i] = resultAlignmentLength[i] + diff;
			for( j = resultAlignmentLength[i] -1; j >= beginPos + WINDOW_SIZE; j --)
			{
				resultAlignment[i][j+diff] =  resultAlignment[i][j];
			}
		}
	}
	if(diff < 0)
	{
		for(i = 0; i < query_sequences_count_main; i ++)
		{
			for( j =  beginPos + WINDOW_SIZE; j < resultAlignmentLength[i] ; j ++)
			{
				resultAlignment[i][j+diff] =  resultAlignment[i][j];
			}
			resultAlignmentLength[i] = resultAlignmentLength[i] + diff;
		}
	}
	//*****************************************************************************//
	//check if this is the end of the result alignment, adjust accordingly         //
	//*****************************************************************************//
	if(beginPos + WINDOW_SIZE > resultAlignmentLength[0])
	{
		for(i = 0; i < query_sequences_count_main; i ++)
		{
			resultAlignmentLength[i] = beginPos + windowAlignmentLength;
		}
	}

	j = 0;
	while(j < windowAlignmentLength)
	{
		for(i = 0; i < query_sequences_count_main; i ++)
		{
			resultAlignment[i][beginPos+j] = windowAlignment[i][j];
		}
		j ++;
	}
}

Boolean	setNextWindowFromResultAlignment()
//set to next window
//based on windowBeginPos and WINDOW_SIZE
{	
	int i;
	int j;
	Boolean end;

	end = FALSE;
	
		
	for(i =0 ; i < WINDOW_SIZE; i ++)
	{
		for(j = 0; j < query_sequences_count_main;  j ++)
		{
			if((i+windowBeginPos) < resultAlignmentLength[j])
			{
				window[j][i] = resultAlignment[j][i+windowBeginPos];

			}
			else
			{
				window[j][i] = getNewNode('-');
				end = TRUE;
			}
		}
	}
	
	return (!end);
}
//this function will update exp_records, from windowBeginPos
//the length of exp_records will be updated accordingly
void update_exp_records()
{
	int i;
	int j;
	int save_windowBeginPos;
	NODE* save_window[MAXSEQ][WINDOW_SIZE];
	NODE* save_windowAlignment[MAXSEQ][WINDOW_ALIGNMENT_SIZE];
	int save_windowAlignmentLength;

	int count;
	int diff;
	int scoreSP;
	int scoreUpper;
	int scoreImpExp;
	int scoreOpt;
	int scoreImp;

	save_windowBeginPos = windowBeginPos;
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		for(j = 0; j < WINDOW_SIZE; j ++)
		{
			save_window[i][j] = window[i][j];
		}
	}
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		for(j = 0; j < WINDOW_ALIGNMENT_SIZE; j ++)
		{
			save_windowAlignment[i][j] = windowAlignment[i][j];
		}
	}
	save_windowAlignmentLength = windowAlignmentLength;
	//move exp_records to fit the new values
	
	diff = windowAlignmentLength - WINDOW_SIZE;
	//move back or first
	j = save_windowBeginPos + WINDOW_SIZE;

	
	if(diff > 0)
	{
		exp_record_count += diff;
		for( j = exp_record_count -1; j >= save_windowBeginPos + WINDOW_SIZE; j --)
		{
			copy_EXP_RECORD(exp_records[j],&(exp_records[j+diff]));
		}
	}
	if(diff < 0)
	{
		for( j = save_windowBeginPos + WINDOW_SIZE; j < exp_record_count ; j ++)
		{
			copy_EXP_RECORD(exp_records[j],&(exp_records[j+diff]));
		}
		exp_record_count += diff;
	}
	
	
	count = 0;
	while(count < save_windowAlignmentLength)
	{
		//add this just to avoid memory problem in linux
		//	printf("now windowBeginPos = %d\n",windowBeginPos);
		//	sprintf(tempStr,"%d\n",windowBeginPos);
		//	fprintf(stdout,"now windowBeginPos = %d\n",windowBeginPos);
		
		//	fflush(stdout);
		
		setNextWindowFromResultAlignment();
	
		scoreSP = getWindowSPScore(window,query_sequences_count_main,WINDOW_SIZE);
		
		scoreUpper = getWindowUpperBoundScore(window,query_sequences_count_main,WINDOW_SIZE);
		scoreImpExp = scoreUpper - scoreSP;
		if(testing_higher)
		{
			setOptimalAlignment();
			scoreOpt = getWindowAlignmentSPScore(windowAlignment,query_sequences_count_main,windowAlignmentLength);
			scoreImp = scoreOpt - scoreSP;
			exp_records[windowBeginPos].actual_improvement_score = scoreImp;
		}
		//*************************************************************************************//
		//here store the scores according the position                                         //
		exp_records[windowBeginPos].expection_improvement_score = scoreImpExp;               //
		//exp_records[windowBeginPos].pos = windowBeginPos;  
		//
		
		//printf("scoreImpExp =%d,scoreImp=%d\n",scoreImpExp,scoreImp);
		//fflush(stdout);
        //*************************************************************************************//
	
		windowBeginPos ++;
		count++;
	}
		
	//copy back
	windowBeginPos = save_windowBeginPos;
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		for(j = 0; j < WINDOW_SIZE; j ++)
		{
			window[i][j] = save_window[i][j];
		}
	}
	windowAlignmentLength = save_windowAlignmentLength;
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		for(j = 0; j < WINDOW_ALIGNMENT_SIZE; j ++)
		{
			windowAlignment[i][j] = save_windowAlignment[i][j];
		}
	}
	
}
void copy_EXP_RECORD(EXP_RECORD source, EXP_RECORD* target)
{
	target->expection_improvement_score = source.expection_improvement_score;
	target->actual_improvement_score = source.actual_improvement_score;
	//target->pos = source.pos;
}

int getResultAlignmentScore()
//only for compute aligned sequence
{
	int i;
	int j;
	int k;
	int score;
	score = 0;
	for( k = 0; k < resultAlignmentLength[0]; k++)
	{
		for( i = 0; i < query_sequences_count_main; i ++)
		{
			for( j = i + 1; j < query_sequences_count_main; j ++)
			{
				score = score + getRoughScoreOfTwoNodes(resultAlignment[i][k],resultAlignment[j][k]);
			}
		}
	}
	return score;
}
double getGapPercentOfWindow()
{
	int i;
	int j;
	int total_count;
	int gap_count;
	
	gap_count = 0;
	total_count = query_sequences_count_main * WINDOW_SIZE;
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		for(j = 0; j < WINDOW_SIZE; j ++)
		{
		
			if((!window[i][j])||(isGap(window[i][j]->letter)))
			{
				gap_count ++;
			}
		}
	}
	return ((double)gap_count)/((double)total_count);
}

int getSequenceUpperboundScore()
//only for compute aligned sequence
{
	int row;
	int col;

	int score;

	NODE* seqs[MAXSEQ][MAXLEN];
	int lengths[MAXSEQ];
	matrixUsed = BLOSUM62;
	score = 0;
	for(row = 0;row<query_sequences_count_main;row ++)
	{
		lengths[row] = 0;
		for(col = 0;col<sequencesLength[row];col++)
		{
			if(!sequences[row][col])
			{
				continue;
			}
			if(isGap(sequences[row][col]->letter))
			{
				continue;
			}
			if(!(isalpha(sequences[row][col]->letter)))
			{
				continue;
			}

			seqs[row][lengths[row]] = sequences[row][col];
			lengths[row]++;
		}

	}

    for(row = 0;row<query_sequences_count_main;row ++)
	{
		for(col = row+1;col< query_sequences_count_main;col++)
		{
		
			score +=(alignTwoNodeSequenceArray(seqs[row],seqs[col],lengths[row],lengths[col]));
		
		}
	}
	return score;

}

void copy_window_alignment(NODE* source[MAXSEQ][WINDOW_ALIGNMENT_SIZE],NODE* target[MAXSEQ][WINDOW_ALIGNMENT_SIZE],
						   int alignment_length)
{
	int i;
	int j;
	for(i = 0; i < query_sequences_count_main; i ++)
	{
		for(j = 0; j <= alignment_length; j ++)
		{
			target[i][j] = source[i][j];
		}
	}
}

//************************************************************************************************//
//the following is to use dynamic programming to find the optimal locations of window, 01-22-2007 //
//************************************************************************************************//
int findMaxM(int a, int b)
{
	int row_length;
	int col_length;
	int** score_matrix;
	int i;
	int j;
	int max_score;
	int score;
	int max_less_b;
	int max_same_b;
	int max_pos;
	int found;

	int debug_in_dp = 1;
	FILE* output_fp;

	if ((a ==0) ||(b ==0))
	{
		return 0;
	}
	if( b == 1) //find the max and set and return
	{
		max_score = -MAXINT;
		max_pos = 0;
		for( i = 0; i < a; i ++)
		{
			score = g_exp_array[i];
		
			if(score > max_score)
			{
				max_score = score;
				max_pos = i;
			}
		}
		for( i = 0; i < a; i ++)
		{
			g_location_flag[i] = 0;
		}
		g_location_flag[max_pos] = 1;
		return 1;
	}

	row_length = b + 1;
	col_length = a + 1;
	//first allocate the matrix space
	if((score_matrix=(int **) malloc((row_length)*sizeof(int*)))==NULL)
	{
		fprintf(stderr,"unable to allocate memory.");
		exit(1);
	}
	for (i = 0; i < row_length; i++)
	{
		if((score_matrix[i]=(int *) malloc((col_length)*sizeof(int)))==NULL)
		//add 1 to prevent overflow
		{
			fprintf(stderr,"unable to allocate memory.");
			exit(1);
		}
	}

	//initial 
	max_score = -MAXINT;
	for( i = 0; i < a; i ++)
	{
		score = g_exp_array[i];
	
		if(score > max_score)
		{
			max_score = score;
		}
		score_matrix[0][i] = max_score;
	}
	
	//file the values from b = 2;
	for( i = 1; i < b; i ++)
	{
		for( j = 0; j < tau + 1; j ++)
		{
			score_matrix[i][j] = score_matrix[i-1][j];
		}
		for(; j < a - tau - 1 ; j ++)
		{
			max_less_b = score_matrix[i - 1][j - tau - 1] + g_exp_array[j];
			max_same_b = score_matrix[i][j - 1];
		
			if(max_less_b > max_same_b)
			{
				max_score = max_less_b;
			}
			else
			{
				max_score = max_same_b;
			}
			score_matrix[i][j] = max_score;
		}
		for(; j < a ; j ++)
		{
			score_matrix[i][j] = score_matrix[i][j-1];
		}
	}

	//trace back to know the location of the optimal solution for b

	i = b - 1;
	j = a - 1 - tau;
	
	while(i >= 0)
	{
		//find the max from current j;
		max_score = score_matrix[i][j];
		found = 0;
		while( j > 0 )
		{
			if(max_score > score_matrix[i][j -1])
			{
				g_location_flag[j] = 1;
				j --;
				found = 1;
				break;
			}
			else
			{
				j --;
			}
		}
		if(!found)
		{
			g_location_flag[0] = 1;
			break;
		}
		i --;
	}
	
	if(debug_in_dp)
	{

		if((output_fp=fopen("debug_output","wt"))==NULL)  
		{  
			printf("Cannot open file strike any key exit!");  
			exit(1);  
		}
		for( i = 0; i < a; i ++)
		{
			fprintf(output_fp,"%d\t",g_exp_array[i]);
		}
		fprintf(output_fp,"\n");
		for( i = 0; i < b; i ++)
		{
			for( j = 0; j < a; j ++)
			{
				fprintf(output_fp,"%d\t",score_matrix[i][j]);
			}
			fprintf(output_fp,"\n");
		}
		for( i = 0; i < a; i ++)
		{
			fprintf(output_fp,"%d\t",g_location_flag[i]);
		}
		fprintf(output_fp,"\n");
		fclose(output_fp);
	}

	//free all
	for (i = 0; i < row_length; i++)
	{
		free(score_matrix[i]);
	}
	free(score_matrix);
	return b;
}
void set_exp_records()
{
	Boolean notDone;
	int scoreSP;
	int scoreUpper;
	int scoreOpt;
	int scoreImp;
	int scoreImpExp;

	int bestExp;

	int i;



//int total_run;

	int best_scoreOpt;
	NODE* best_alignment[MAXSEQ][WINDOW_ALIGNMENT_SIZE];
	int best_alignment_length;

#if  LINUX_MAIN
	long time_begin;
	long time_end;
#endif

	long time_total[7];

	int max_number_in_group_bak;
	int out;


	windowBeginPos = 0;
	putInitialWindow();
	notDone = TRUE;
	
	bestExp = -MAXINT;
	exp_record_count = 0;

	max_group_number_lower_main = max_number_in_group;
	max_group_number_upper_main = max_number_in_group;
	max_number_in_group_bak = max_number_in_group;

	for(i = 0; i < 7; i ++)
	{
		time_total[i] = 0;
	}
	for( i = 0; i < 2000; i++)
	{
		exp_records[i].actual_improvement_score = -MAXINT;
		exp_records[i].expection_improvement_score = -MAXINT;
	}

	while(notDone)
	{

		best_scoreOpt = -MAXINT;

		scoreSP = getWindowSPScore(window,query_sequences_count_main,WINDOW_SIZE);
		scoreUpper = getWindowUpperBoundScore(window,query_sequences_count_main,WINDOW_SIZE);
		scoreImpExp = scoreUpper - scoreSP;
		if(scoreImpExp > 0)
		{
			max_number_in_group = max_group_number_lower_main;
			//while(max_number_in_group <= max_group_number_upper_main)
			if(testing_higher)
			{
				out = (max_number_in_group == max_number_in_group_bak)?1:0;
				if(debug > -1)
				{
					printf("%d\t%d\t%d\t",max_number_in_group, scoreSP,scoreUpper);
					fflush(stdout);
				}
			//*********************************************************************************************//
				if(1)
				{
					p_group_function = &set_group_flag_by_min_gaps;
					min_cut_k_group_metis = 0;

					align_a_window(&scoreOpt, &scoreImp, scoreSP, best_alignment, &best_scoreOpt, &best_alignment_length,out);
					//	output_window_info_to_file(scoreSP,scoreUpper,scoreOpt,scoreImpExp,scoreImp,max_number_in_group_bak);
				}
				//copy back the best
				scoreOpt = best_scoreOpt;
				scoreImp = scoreOpt - scoreSP;
				copy_window_alignment(best_alignment,windowAlignment,best_alignment_length);
				windowAlignmentLength = best_alignment_length;
				max_number_in_group ++;
				exp_records[exp_record_count].actual_improvement_score = scoreImp;
			}
				//*********************************************************************************************//
			//here store the scores according the position                                         //
			exp_records[exp_record_count].expection_improvement_score = scoreImpExp;               
			
			exp_record_count ++; 
			//*************************************************************************************//
			if(debug > -1)
			{
				printf("\n");
			}
			max_number_in_group = max_number_in_group_bak;
		}
		windowBeginPos ++;
		notDone = setNextWindow();
		if( !notDone)
			break;
	}
}
int processByLocatedWindow_DP()
{
	Boolean notDone;
	int scoreSP;

	int scoreOpt;
	int scoreImp;
	int scoreImpExp;
	int bestExpPos;
	int bestExp;

	int i;

	double gapPercent;
	double combine_factor;
	int total_run;
	int j;

	int best_scoreOpt;
	NODE* best_alignment[MAXSEQ][WINDOW_ALIGNMENT_SIZE];
	int best_alignment_length;

#if  LINUX_MAIN
	long time_begin;
	long time_end;
#endif

	long time_total[7];

	int max_number_in_group_bak;
	
	if(g_b >= g_a /( 2*tau + 1 ))
	{
		return 0;
	}

	total_run = 0;


	putInitialWindow();
	notDone = TRUE;
	
	bestExp = -MAXINT;

	max_group_number_lower_main = max_number_in_group;
	max_group_number_upper_main = max_number_in_group;
	max_number_in_group_bak = max_number_in_group;

	for(i = 0; i < 7; i ++)
	{
		time_total[i] = 0;
	}

	//set the exp_records value to global array

	for( i = 0; i < exp_record_count; i ++)
	{
		g_exp_array[i] = exp_records[i].expection_improvement_score;
	}

	for( i = 0; i < exp_record_count + 1; i ++)
	{
		g_location_flag[i] = 0;
	}
	//call optimal finder
	findMaxM(g_a,g_b);
	//use the result g_location_flag

	initResultAlignment();

	//*****************************************************************************************//
	//now start to iterate                                                                     //
	//*****************************************************************************************//

	p_group_function = &set_group_flag_by_min_gaps;
	min_cut_k_group_metis = 0;

	for(j = 0; j < exp_record_count; j ++)
	{
		//find the best score in the array, which is one disabled.
		if(!(g_location_flag[j]))
		{
			continue;
		}
		else
		{
			bestExp = g_exp_array[j];
			bestExpPos = j;
		}

		windowBeginPos = bestExpPos;
		scoreImpExp = bestExp;
		
		if( scoreImpExp <= 0) 
		{
			continue;
		}
		setNextWindowFromResultAlignment();
		gapPercent = getGapPercentOfWindow();
		combine_factor = gapPercent*scoreImpExp;
	
		//if((gapPercent < 0.01) || (combine_factor < 1) || (scoreImpExp < 1 * WINDOW_SIZE / 2) )
		if(0)
		{
			total_run ++;
			continue;
		}
	
		//*********************************************************************************************//
		scoreSP = getWindowSPScore(window,query_sequences_count_main,WINDOW_SIZE);

		if(1)
		{
			
#if LINUX_MAIN
			gettimeofday( &tv_main, NULL );
			time_begin = 1000000 * ( tv_main.tv_sec  ) + tv_main.tv_usec;
#endif
					
			align_a_window(&scoreOpt, &scoreImp, scoreSP, best_alignment, &best_scoreOpt, &best_alignment_length,1);
			//	output_window_info_to_file(scoreSP,scoreUpper,scoreOpt,scoreImpExp,scoreImp,max_number_in_group_bak);
#if LINUX_MAIN
			gettimeofday( &tv_main, NULL );
			time_end = 1000000 * ( tv_main.tv_sec  ) + tv_main.tv_usec;
			time_total[max_number_in_group] += (time_end - time_begin);
#endif
	
		}
				//copy back the best
		scoreOpt = best_scoreOpt;
		scoreImp = scoreOpt - scoreSP;
		copy_window_alignment(best_alignment,windowAlignment,best_alignment_length);
		windowAlignmentLength = best_alignment_length;

		printf("q3: windowBeginPos=%d,g_qoma2_opt_run_count=%d\t",windowBeginPos,g_qoma2_opt_run_count);

		if(scoreImp > 0)
		{
			replaceAlginment(windowBeginPos);
			//update_g_location_flag();
			g_qoma2_opt_run_count ++;
		}
		
		if(g_qoma2_opt_run_count >= g_b)
		{
			break;
		}
		total_run ++;
	
		if((total_run > exp_record_count * 10) || (total_run > g_qoma1_run_count * 10) )
		{
			break;
		}
	}

	//g_qoma2_sp_score_opt[g_b] += g_qoma2_sp_score_opt[0] + sum_imp;
	return 0;
}

//this function will update g_location_flag and g_exp_array, from windowBeginPos
void update_g_location_flag()
{

	int j;
	int save_windowBeginPos;
	int save_windowAlignmentLength;

	int diff;

	save_windowBeginPos = windowBeginPos;
	save_windowAlignmentLength = windowAlignmentLength;
	//move exp_records to fit the new values
	
	diff = windowAlignmentLength - WINDOW_SIZE;
	//move back or first
	
	if(diff == 0)
	{
		return;
	}
	if(diff > 0)
	{

		for( j = exp_record_count - diff -1; j >= save_windowBeginPos + WINDOW_SIZE; j --)
		{
			g_exp_array[j+diff] = g_exp_array[j];
			g_location_flag[j+diff] = g_location_flag[j];
		}

	}
	if(diff < 0)
	{
		for( j = save_windowBeginPos + WINDOW_SIZE; j < exp_record_count + diff ; j ++)
		{
			g_exp_array[j+diff] = g_exp_array[j];
			g_location_flag[j+diff] = g_location_flag[j];
		}
	}

	for( j = 0; j < save_windowAlignmentLength; j ++)
	{
		g_exp_array[windowBeginPos+j] = -1;
		g_location_flag[windowBeginPos+j] = 0;
	}
	//copy back
	windowBeginPos = save_windowBeginPos;
	windowAlignmentLength = save_windowAlignmentLength;

}

void bak_exp_records()
{
	int i;
	for( i = 0; i < exp_record_count; i ++)
	{
		copy_EXP_RECORD(exp_records[i], &(exp_records_bak[i]));
	}
	exp_record_count_bak = exp_record_count;
}

void restore_exp_records()
{
	int i;
	for( i = 0; i < exp_record_count_bak; i ++)
	{
		copy_EXP_RECORD(exp_records_bak[i], &(exp_records[i]));
	}
	exp_record_count = exp_record_count_bak;
}