#ifndef COMMON_H
#define COMMON_H

#define MAXLEN 8000
#define MAXLINE 8000
#define Boolean short
#define TRUE 1
#define FALSE 0
#define EOS '\0'



#define MAXINT 1000000


#define UP 3
#define LEFT 1
#define DIAGNAL 2


#define MAX(a ,b) ((a) > (b)?(a) : (b))
#define MIN(a ,b) ((a) > (b)?(b) : (a))
#define ABS(a)	   (((a) < 0) ? -(a) : (a))

/**************************************************************************/
static char* low_similarity[]=
	{
	"1aboA",
	"1idy",
	"1r69",
	"1tvxA",
	"1ubi",
	"1wit",
	"2trx",
	"1bbt3",
	"1sbp",
	"1havA",
	"1uky",
	"2hsdA",
	"2pia",
	"3grs",
	"kinase",
	"1ajsA",
	"1cpt",
	"1lvl",
	"1pamA",
	"1ped",
	"2myr",
	"4enl",
	"gal4"
};   
static char* medium_similarity[]=
	{
	"1aab",
	"1fjlA",
	"1hfh",
	"1hpi",
	"1csy",
	"1pfc",
	"1tgxA",
	"1ycc",
	"3cyr",
	"451c",
	"1ad2",	
	"1aym3",
	"1gdoA",
	"1ldg",
	"1mrj",
	"1pgtA",
	"1pii",
	"1ton",
	"2cba",
	"1ac5",
	"1adj",
	"1bgl",
	"1dlc",
	"1eft",
	"1fieA",
	"1gowA",
	"1pkm",
	"1sesA",
	"2ack",
	"arp",
	"glg"	
	};
static char* high_similarity[]=
	{
	"1aho",
	"1csp",
	"1dox",
	"1fkj",
	"1fmb",
	"1krn",
	"1plc",
	"2fxb",
	"2mhr",
	"9rnt",
	"1amk",
	"1ar5A",
	"1ezm",
	"1led",
	"1ppn",
	"1pysA",
	"1thm",
	"1tis",
	"1zin",
	"5ptp",
	"1ad3",
	"1gpb",
	"1gtr",
	"1lcf",
	"1rthA",
	"1taq",
	"3pmg",
	"actin" 	
	};


static int BLOSUM62[24][24] ={
{  4, -1, -2, -2,  0, -1, -1,  0, -2, -1, -1, -1, -1, -2, -1,  1,  0, -3, -2,  0, -2, -1,  0, -4}, 
{ -1,  5,  0, -2, -3,  1,  0, -2,  0, -3, -2,  2, -1, -3, -2, -1, -1, -3, -2, -3, -1,  0, -1, -4}, 
{ -2,  0,  6,  1, -3,  0,  0,  0,  1, -3, -3,  0, -2, -3, -2,  1,  0, -4, -2, -3,  3,  0, -1, -4}, 
{ -2, -2,  1,  6, -3,  0,  2, -1, -1, -3, -4, -1, -3, -3, -1,  0, -1, -4, -3, -3,  4,  1, -1, -4}, 
{  0, -3, -3, -3,  9, -3, -4, -3, -3, -1, -1, -3, -1, -2, -3, -1, -1, -2, -2, -1, -3, -3, -2, -4}, 
{ -1,  1,  0,  0, -3,  5,  2, -2,  0, -3, -2,  1,  0, -3, -1,  0, -1, -2, -1, -2,  0,  3, -1, -4}, 
{ -1,  0,  0,  2, -4,  2,  5, -2,  0, -3, -3,  1, -2, -3, -1,  0, -1, -3, -2, -2,  1,  4, -1, -4}, 
{  0, -2,  0, -1, -3, -2, -2,  6, -2, -4, -4, -2, -3, -3, -2,  0, -2, -2, -3, -3, -1, -2, -1, -4}, 
{ -2,  0,  1, -1, -3,  0,  0, -2,  8, -3, -3, -1, -2, -1, -2, -1, -2, -2,  2, -3,  0,  0, -1, -4}, 
{ -1, -3, -3, -3, -1, -3, -3, -4, -3,  4,  2, -3,  1,  0, -3, -2, -1, -3, -1,  3, -3, -3, -1, -4}, 
{ -1, -2, -3, -4, -1, -2, -3, -4, -3,  2,  4, -2,  2,  0, -3, -2, -1, -2, -1,  1, -4, -3, -1, -4}, 
{ -1,  2,  0, -1, -3,  1,  1, -2, -1, -3, -2,  5, -1, -3, -1,  0, -1, -3, -2, -2,  0,  1, -1, -4}, 
{ -1, -1, -2, -3, -1,  0, -2, -3, -2,  1,  2, -1,  5,  0, -2, -1, -1, -1, -1,  1, -3, -1, -1, -4}, 
{ -2, -3, -3, -3, -2, -3, -3, -3, -1,  0,  0, -3,  0,  6, -4, -2, -2,  1,  3, -1, -3, -3, -1, -4}, 
{ -1, -2, -2, -1, -3, -1, -1, -2, -2, -3, -3, -1, -2, -4,  7, -1, -1, -4, -3, -2, -2, -1, -2, -4}, 
{  1, -1,  1,  0, -1,  0,  0,  0, -1, -2, -2,  0, -1, -2, -1,  4,  1, -3, -2, -2,  0,  0,  0, -4}, 
{  0, -1,  0, -1, -1, -1, -1, -2, -2, -1, -1, -1, -1, -2, -1,  1,  5, -2, -2,  0, -1, -1,  0, -4}, 
{ -3, -3, -4, -4, -2, -2, -3, -2, -2, -3, -2, -3, -1,  1, -4, -3, -2, 11,  2, -3, -4, -3, -2, -4}, 
{ -2, -2, -2, -3, -2, -1, -2, -3,  2, -1, -1, -2, -1,  3, -3, -2, -2,  2,  7, -1, -3, -2, -1, -4}, 
{  0, -3, -3, -3, -1, -2, -2, -3, -3,  3,  1, -2,  1, -1, -2, -2,  0, -3, -1,  4, -3, -2, -1, -4}, 
{ -2, -1,  3,  4, -3,  0,  1, -1,  0, -3, -4,  0, -3, -3, -2,  0, -1, -4, -3, -3,  4,  1, -1, -4}, 
{ -1,  0,  0,  1, -3,  3,  4, -2,  0, -3, -3,  1, -1, -3, -1,  0, -1, -3, -2, -2,  1,  4, -1, -4}, 
{  0, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2,  0,  0, -2, -1, -1, -1, -1, -1, -4}, 
{ -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,  1}};
static char *amino_acid_order = "ABCDEFGHIKLMNPQRSTVWXYZ";
static char *nucleic_acid_order = "ABCDGHKMNRSTUVWXY";
static int gon250mt[]={
  24,
   0,   0,
   5,   0, 115,
  -3,   0, -32,  47,
   0,   0, -30,  27,  36,
 -23,   0,  -8, -45, -39,  70,
   5,   0, -20,   1,  -8, -52,  66,
  -8,   0, -13,   4,   4,  -1, -14,  60,
  -8,   0, -11, -38, -27,  10, -45, -22,  40,
  -4,   0, -28,   5,  12, -33, -11,   6, -21,  32,
 -12,   0, -15, -40, -28,  20, -44, -19,  28, -21,  40,
  -7,   0,  -9, -30, -20,  16, -35, -13,  25, -14,  28,  43,
  -3,   0, -18,  22,   9, -31,   4,  12, -28,   8, -30, -22,  38,
   3,   0, -31,  -7,  -5, -38, -16, -11, -26,  -6, -23, -24,  -9,  76,
  -2,   0, -24,   9,  17, -26, -10,  12, -19,  15, -16, -10,   7,  -2,  27,
  -6,   0, -22,  -3,   4, -32, -10,   6, -24,  27, -22, -17,   3,  -9,  15,  47,
  11,   0,   1,   5,   2, -28,   4,  -2, -18,   1, -21, -14,   9,   4,   2,  -2,  22,
   6,   0,  -5,   0,  -1, -22, -11,  -3,  -6,   1, -13,  -6,   5,   1,   0,  -2,  15,  25,
   1,   0,   0, -29, -19,   1, -33, -20,  31, -17,  18,  16, -22, -18, -15, -20, -10,   0,  34,
 -36,   0, -10, -52, -43,  36, -40,  -8, -18, -35,  -7, -10, -36, -50, -27, -16, -33, -35, -26, 142,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 -22,   0,  -5, -28, -27,  51, -40,  22,  -7, -21,   0,  -2, -14, -31, -17, -18, -19, -19, -11,  41,   0,  78,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0};
static short int isGapChar(char c)
{
	if((c == '-')||(c == '*')||(c == '~')||(c == '.'))
	{
		return 1;
	}
	return 0;
}
static char toLowerCase(char a) 
{ 
	 
	if((a >= 'A')&&(a<='Z')) 
		return (char)(a-'A'+'a'); 
	return a; 
} 
   
static char toUpperCase(char a) 
{ 
	 
	if((a >= 'a')&&(a<='z')) 
		return (char)(a-'a'+'A'); 
	return a; 
} 
static int getWeightBLOSUM62(char a,char b) 
{ 
	char* searchString = "ARNDCQEGHILKMFPSTWYVBZX*";
	int row ;
  	int col = 0;
	
	if((a=='$')||(b=='$'))
    		return 0;
  
  	a =toUpperCase(a); 
  	b= toUpperCase(b);
  	if((a=='.')||(a=='-')||(a=='~')||(a==0))
    		a='*';
  	if((b=='.')||(b=='-')||(b=='~')||(b==0))
    		b='*';
  	if((a=='*')&&(b=='*'))
    		return 0;
  
  	for(row = 0;(searchString[row]!=a)&&(row<24);row++); 
  	for(col = 0;(searchString[col]!=b)&&(col<24);col++); 
  
  	if ((row<24) && (col < 24)) 
    		return BLOSUM62[row][col]; 
  	else if ((row<24) || (col < 24))
  		return BLOSUM62[1][23];
  	else 
    		return -10000; 
}
static int getWeightGON250(char a,char b)
//this is for gon250mt
{ 
	char* searchString; //= "ARNDCQEGHILKMFPSTWYVBZX*";
	int row = 0 ;
  	int col = 0;
  	int tmp = 0;
  	int pos ;
	if((a=='$')||(b=='$'))
    		return 0;
  	searchString = amino_acid_order;
  	a =toUpperCase(a); 
  	b= toUpperCase(b);
  	if((a=='.')||(a=='-'))
    		a='*';
  	if((b=='.')||(b=='-'))
    		b='*';
  	if((a=='*')||(b=='*'))
    		return 0;
  
  	for(row = 0;(searchString[row]!=a)&&(row<23);row++); 
  	for(col = 0;(searchString[col]!=b)&&(col<23);col++); 
  	//the formular :(row*(row+1))/2+col
  	
  	if ((row<23) && (col < 23))
  	{
    		if(row < col)
	  	{
	  		tmp = row;
	  		row = col;
	  		col = tmp;
  		}
  		pos = (row*(row+1))/2+col;
    		return gon250mt[pos];
    	}
  	else 
  	{
    		return -10000;
    	}
}
static int getWeightDNA(char a,char b) 
{ 
	
	
	a =toUpperCase(a); 
	b= toUpperCase(b);
	if((a=='.')||(a=='*'))
		a='-';
	if((b=='.')||(b=='*'))
		b='-';
	if((a=='-')&&(b=='-'))
		return 0;
	if( a==b)
		return 1;
	return 0;
}
static int sameString(char *a,char *b)
{
	int same = 1;
	while(1)
	{
		if(*a==*b)
		{
			if(!*a)
			{
				if(*b)
					same = 0;
				break;
			}
			a++;
			b++;
		}
		else
		{
			same = 0;
			break;
		}
	}
	return same;
}
static int sameStringIgnoreCase(char *a,char *b)
{
	int same = 1;
	while(1)
	{
		if(toUpperCase(*a)==toUpperCase(*b))
		{
			if(!*a)
			{
				if(*b)
					same = 0;
				break;
			}
			a++;
			b++;
		}
		else
		{
			same = 0;
			break;
		}
	}
	return same;
}
static int getSubstring(char* sub,char* org, int start, int end)
{
	int length;
	int i;
	if(start < 0)
	{
		start = 0;
	}
	length = end - start + 1;
	if (length <= 0)
	{
		return 0;
	}
	for( i = 0; i < length; i ++)
	{
		if(org[start+i])
		{
			sub[i] = org[start+i];
		}
		else
		{
			break;
		}
	}
	sub[i] = 0;
	return i;
}
static int stringToLower(char * str)
{
	int i = 0;
	while(str[i])
	{
		str[i] = toLowerCase(str[i]);
		i ++;
	}
	return i;
}
static int stringToUpper(char * str)
{
	int i = 0;
	while(str[i])
	{
		str[i] = toUpperCase(str[i]);
		i ++;
	}
	return i;
}
static int trimString(char* str)
{
	int i ,j;
	char tmp[MAXLINE];
	i = 0;
	j = 0;
	while((str[i] == '\t')
		||
		(str[i] == '\r')
		||
		(str[i] == ' '))
	{
		i ++;
	}
	while(str[i] != '\0')
	{
		tmp[j++] = str[i];
		i ++;	
	}
	j --;
	while((tmp[j] == '\t')
		||
		(tmp[j] == '\r')
		||
		(tmp[j] == ' ')
		||
		(tmp[j] == '\n'))
	{
		j --;
	}
	j ++;
	tmp[j] = 0;	
	
	j = 0;
	while(tmp[j])
	{
		str[j] = tmp[j];
		j ++;
	}
	str[j] = 0;
	return j;
}
static int replaceInString(char* str,char from,char to)
{
	int i;
	i = 0;
	while(
		(str[i] != '\0')
		)
	{
		if(str[i] == from)
		{
			str[i] = to;
		}
		i ++;
	}
	return i;
}
static int strStartWith(char* str,char* check)
{
	int i;
	i = 0;
	while(check[i])
	{
		if(str[i] != check[i])
		{
			return 0;
		}
		i ++;
	}
	return 1;
}
static int powerZXR(int k)
{
	int i;
	int p;
	p = 1;
	for(i = 0; i < k; i ++)
	{
		p *= 2;
	} 
	return p;
}
static void setBasename(char* basename, char* filename, char* filename_extension)
{
	char* p_last_slash;
	char* p_extension_start;
	char tmpStr[MAXLINE];
	int i;

	basename[0] = 0;
	strcpy(tmpStr,filename);
	p_last_slash = strrchr(tmpStr,'\\');
	if(!p_last_slash)
	{
		p_last_slash = strrchr(tmpStr,'/');
	}
	p_extension_start = strstr(tmpStr,filename_extension);
	if((!p_extension_start)&&(!p_last_slash))
	{
		strcpy(basename,tmpStr);
		return;
	}
	if((p_extension_start)&&(!p_last_slash))
	{
        *p_extension_start = 0;
		strcpy(basename,tmpStr);
		return;
	}
	if((p_last_slash))
	{
		i = 0;
		p_last_slash ++;
		while(p_last_slash != p_extension_start)
		{
			basename[i] = *p_last_slash;
			i ++;
			p_last_slash ++;
			if(!(*p_last_slash))
			{
				break;
			}
		}
		basename[i] = 0;
	}

}
#endif

