#include "glut.h"
#include <stdlib.h>
#include <stdarg.h>

#include <iostream>
#include <memory.h>
#include <time.h>
#include <fstream>
using namespace std;

// Default Image dimensions
int imageWidth = 640;
int imageHeight = 480;


//OpenGL Calls
void setupGL();
void CheckGLError();

//Callbacks
void Display();
void Idle();
void Reshape(int w, int h);
void Keyboard (unsigned char key, int , int );
void MouseButton(int button, int state, int x, int y);
void MouseMotion(int x, int y);


// a cleanup function
void quit(int i = 0);

void main(int argc, char **argv)
{
	// INITIALIZE THE GLUT WINDOW
	glutInit(&argc, argv);  
	glutInitWindowSize(imageWidth, imageHeight);
	glutInitDisplayString("rgb double");
	glutInitWindowPosition(0, 0);
	glutCreateWindow("Project #0");

	//SETUP GLUT CALLBACKS
	cout << "Setting up callbacks... ";
	glutDisplayFunc(Display);
	glutKeyboardFunc(Keyboard);
	glutMouseFunc(MouseButton);
	glutMotionFunc(MouseMotion);
	glutReshapeFunc(Reshape);
	glutIdleFunc(Idle);
	cout << "[completed]\n";
	glEnable(GL_DEPTH_TEST);

	//SETUP MISC GL
	setupGL();

	CheckGLError();
	glutMainLoop();
}



// This function checks the state of openGL and prints 
// an error if an error has occurred
void CheckGLError()
{
  	GLenum error;
  	error = glGetError();
  	if (error!=GL_NO_ERROR)
  	{
		cout << "OpenGL reports an error: "<< gluErrorString(error) << endl;
		quit(1);
  	}
}


// This function draws the scene
void Display()
{
	glClear(GL_COLOR_BUFFER_BIT);

	//draw here

	glutSwapBuffers();
}




// set up GL stuff
void setupGL() {

	// set the clear color
	glClearColor(0.0, 0.0, 0.0, 1.0);  // background color

}


// This function is continuously called when events are not being received
// by the window.  This is a good place to update the state of your objects 
// after every frame.
void Idle() {
	glutPostRedisplay();
}

// keyboard handler
void Keyboard (unsigned char key, int , int )
{
}

void MouseButton(int button, int state, int x, int y)
{	
}

void MouseMotion(int x, int y)
{
}

// This functions handles what happens when the window is reshaped
void Reshape(int w, int h) 
{
}

// a cleanup function.  call this when you want to exit.
void quit(int i) 
{
	
}