#ifndef VREGION2D_H
#define VREGION2D_H

#include "num.h"
#include "constants.h"
#include "region2D.h"
#include "mSlob.h"
#include "undefinedSpatialObjectException.h"
#include "vectorBinarySearchWrapper.h"
#include "user_types.h"
#include "vasa_types.h"
#include "TopPred2D.h"

/*namespace stu
{*/
	using namespace stu;
	using namespace std;
	

	class vregion2D{
			
		public:
			
			vregion2D();
			vregion2D(const Locator& m);
			vregion2D(const Locator& m, const region2D &k, const region2D &c);
			vregion2D(const Locator& m, const vregion2D& ps);
	
			~vregion2D();
	
			uint size() const; //the number of points

			
			//constructor ops
			region2D getKernel() const; //adds point checks it didn't exist already
			region2D getConjecture() const; //adds point checks it didn't exist already
			void setKernel(const region2D& k) throw (undefinedSpatialObjectException); //set this kernel as the given (copy)
			void setConjecture(const region2D& c) throw (undefinedSpatialObjectException); //set this conjecture as the given (copy)
	
			trival isEmpty() const; //returns getSize()==0

			bool validate();

			bool isValid() const;

			mbb2D getmbb() const;

			//homogeneous ops
			vregion2D intersection(const vregion2D &other) const;
			vregion2D sunion(const vregion2D &other) const;	
			vregion2D difference(const vregion2D &other) const;
	
			rat min_mindistance(const vregion2D &other) const; //returns the min min distance, considers conjecture
			rat max_mindistance(const vregion2D &other) const; //returns the max min distance, only considering kernel
	
			rat min_length() const; //returns the min length, only considering kernel
			rat max_length() const; //returns the max length, considers conjecture
			
			rat min_area() const; //returns the min area, only considering kernel
			rat max_area() const; //returns the max area, considers conjecture
			
			//Output operator
			friend std::ostream &operator << (std::ostream &ostr, const vregion2D &rhs) throw( undefinedSpatialObjectException );
		
		private:
			Locator global; //represents whole object
			region2D kernel;
			region2D conjecture;

			bool valid;
	};
// }
#endif

