#include "vregion2D.h"
#include <iostream>

// namespace stu
// {
	using namespace stu;
	using namespace std;
			
	vregion2D::vregion2D():global(true), kernel(global.insert(0, OBJECT_LEVEL)), conjecture(global.insert(1, OBJECT_LEVEL)), valid(true)
	{}
	
	vregion2D::vregion2D(const Locator& m): global(m),kernel(static_cast<bool>(false)),conjecture(static_cast<bool>(false)), valid(false)
	{
		if (global.getElements()==0) //then its an empty COLLECTION NODE, insert objects
		{
			kernel=region2D(global.insert(0)); //insert, then get kernel
			conjecture=region2D(global.insert(1)); //insert, then get conjecture
			valid=true;
		}
		else
		{
			kernel=region2D(global.locate(0)); //get kernel
			conjecture=region2D(global.locate(1)); //get conjecture
			valid=validate();
		}
	}
	
	vregion2D::vregion2D(const Locator& m, const region2D &k,  const region2D &c): global(m), kernel(global.insert(0, OBJECT_LEVEL),k), conjecture(global.insert(1,OBJECT_LEVEL),c), valid(false)
	{	
	}
	
	vregion2D::vregion2D(const Locator& m, const vregion2D &ps): global(m), kernel(global.insert(0, OBJECT_LEVEL),ps.getKernel()), conjecture(global.insert(1, OBJECT_LEVEL),ps.getConjecture()), valid(ps.valid)
	{		
	}

	vregion2D::~vregion2D()
	{
	}
	

	region2D vregion2D::getKernel() const { return kernel; }
	
	region2D vregion2D::getConjecture() const { return conjecture; }
	
	void vregion2D::setKernel(const region2D& k) throw (undefinedSpatialObjectException){ kernel=k; }
	
	void vregion2D::setConjecture(const region2D& c) throw (undefinedSpatialObjectException){ conjecture=c; }
	
	
	trival vregion2D::isEmpty() const
	{
		if (!kernel.isEmpty())
			return VFALSE;
		else if (!conjecture.isEmpty())
			return VMAYBE;
		else
			return VTRUE;
	}
	
	bool vregion2D::validate()
	{
		valid=true; //assume at first that it is valid, now try to invalidate
		if (!(kernel.isValid() && conjecture.isValid()))
		{
			cout << "Sorry ";
			
			if (!kernel.isValid())
				cout << " the kernel is invalid" << endl;
			if (!conjecture.isValid())
				cout << " the conjecture is invalid" << endl;
			
			valid=false;
			return valid;
		}
		cout << "K and C valid by themselves!" << endl;
		
		//check top predicate between kernel and conjecture
		int rel=TopPred2D::topPred(kernel,conjecture);
		
		cout << "The rel: " << rel << endl;
		
		if (rel>4)
			valid=false;
		
		return valid;
	}

	bool vregion2D::isValid() const
	{
		return valid;
	}
	
	mbb2D vregion2D::getmbb() const 
	{
		if (!valid)
			cerr << "Undefined Object. No MBB Available" << endl;

		rat minx(0);
		rat miny(0);
		rat maxx(0);
		rat maxy(0);

		mbb2D km=kernel.getmbb();
 		mbb2D cm=conjecture.getmbb();

		minx=km.getB().getX();
		miny=km.getB().getY();

		maxx=km.getU().getX();
		maxy=km.getU().getY();

		if (cm.getB().getX()<minx) minx=cm.getB().getX();
		if (cm.getB().getY()<miny) miny=cm.getB().getY();
		if (cm.getU().getX()>maxx) maxx=cm.getU().getX();
		if (cm.getU().getY()>maxx) maxx=cm.getU().getX();

		return  mbb2D(poi2D(minx,miny),poi2D(maxx,maxy));
	}
	
	//homogeneous ops
	vregion2D vregion2D::intersection(const vregion2D &other) const 
	{ 
		vregion2D toreturn;
		toreturn.setKernel(getKernel().intersection(other.getKernel()));
		toreturn.setConjecture(((getConjecture().intersection(other.getConjecture())).sunion(getKernel().intersection(other.getConjecture()))).sunion(getConjecture().intersection(other.getKernel())));
		
		return toreturn;
	}

	vregion2D vregion2D::sunion(const vregion2D &other) const 
	{
		vregion2D toreturn;
		toreturn.setKernel(getKernel().sunion(other.getKernel()));
		toreturn.setConjecture((getConjecture().sunion(other.getConjecture())).difference(getKernel().sunion(other.getKernel())));
		
		return toreturn;
	}	

	vregion2D vregion2D::difference(const vregion2D &other) const 
	{
		vregion2D toreturn;
		toreturn.setKernel(getKernel().difference((other.getKernel()).sunion(other.getConjecture())));
		toreturn.setConjecture(
				(getConjecture().intersection(other.getConjecture())).sunion
				(
					(getKernel().intersection(other.getConjecture())).sunion(
				getConjecture().difference((other.getKernel()).sunion(other.getConjecture()))
																			)
				)
							  );
		
		return toreturn;
		
	}
	
	rat vregion2D::min_mindistance(const vregion2D &other) const //returns the minimum distance
	{
		rat min;

		min=(getKernel().sunion(getConjecture())).distance(other.getKernel().sunion(other.getConjecture()));
		
		return min;
	}
	
	rat vregion2D::max_mindistance(const vregion2D &other) const //returns the minimum distance
	{
		rat min;

		min=getKernel().distance(other.getKernel());
		
		return min;
	}

	rat vregion2D::min_length() const //returns the min length, only considering kernel
	{
		return kernel.getLength();
	}
	
	rat vregion2D::max_length() const //returns the max length, considers conjecture
	{
		return kernel.getLength() + conjecture.getLength();	
	}
	
	rat vregion2D::min_area() const //returns the min area, only considering kernel
	{
		return kernel.getArea();
	}
	
	rat vregion2D::max_area() const //returns the max area, considers conjecture
	{
		return kernel.getArea() + conjecture.getArea();	
	}
	
	//heterogeneous ops
// 	region2D& region2D::intersection(const region2D &other)const {return *(new region2D(*this));}
// 	region2D& region2D::intersection(const region2D &other)const {return *(new region2D(*this));}
// 	region2D& region2D::difference(const region2D &other)const {return *(new region2D(*this));}
// 	region2D& region2D::difference(const region2D &other)const {return *(new region2D(*this));}
// 	
// 	rat &region2D::distance(const region2D &other)const {return *(new rat(1));}
// 	rat &region2D::distance(const region2D &other)const {return *(new rat(1));}
	
	std::ostream& operator << (std::ostream &ostr, const vregion2D &rhs) throw( undefinedSpatialObjectException )
	{
		if( !rhs.isValid( ) ) {
			ostr<< "--Undefined--" ;
		} 	
		ostr << "Kernel: " << rhs.getKernel() << endl;
		ostr << "Conjecture: " << rhs.getConjecture() << endl;
		
		return ostr;
	}

// }

