#include <oci.h>
//#include "rational.h"
#include "vpoint2D.h"
#include "VTP2D.h"
#include "mSlob.h"

//Spal2D points wrapper library
//Alejandro Pauly
//Created: 10/24/2006
extern "C" typedef struct OCILobWrapper{
	OCILobLocator* lob;
	OCISvcCtx*     cntxt;
	OCIError*      errhp;
} OCILobWrapper;

extern "C" int vpoint_getMinCount(OCIExtProcContext *ctx, OCILobLocator* point){
	OCIEnv   *envhp;
	OCISvcCtx  *svchp;
	OCIError   *errhp;
	sword  retval;
	retval = OCIExtProcGetEnv (ctx, &envhp, &svchp, &errhp);

	OCILobWrapper *b=new OCILobWrapper;
	b->lob=point;
	b->errhp=errhp;
	b->cntxt=svchp;

	mSlob p(b);
	
	Locator points(p.locateGlobal());
	
	vpoint2D ps(points);
	
	int cc=(int)ps.getMinPointCount();
	return cc;
/*	int cc=(int)p.count(points);
	return cc;*/
}

extern "C" int vpoint_getMaxCount(OCIExtProcContext *ctx, OCILobLocator* point){
	OCIEnv   *envhp;
	OCISvcCtx  *svchp;
	OCIError   *errhp;
	sword  retval;
	retval = OCIExtProcGetEnv (ctx, &envhp, &svchp, &errhp);

	OCILobWrapper *b=new OCILobWrapper;
	b->lob=point;
	b->errhp=errhp;
	b->cntxt=svchp;

	mSlob p(b);
	
	Locator points(p.locateGlobal());
	
	vpoint2D ps(points);
	
	int cc=(int)ps.getMaxPointCount();
	return cc;
/*	int cc=(int)p.count(points);
	return cc;*/
}


extern "C" int vpoint_Disjoint(OCIExtProcContext *ctx, OCILobLocator* A, OCILobLocator* B){
	OCIEnv   *envhp;
	OCISvcCtx  *svchp;
	OCIError   *errhp;
	sword  retval;
	retval = OCIExtProcGetEnv (ctx, &envhp, &svchp, &errhp);

	OCILobWrapper *a=new OCILobWrapper;
	a->lob=A;
	a->errhp=errhp;
	a->cntxt=svchp;
	
	OCILobWrapper *b=new OCILobWrapper;
	b->lob=B;
	b->errhp=errhp;
	b->cntxt=svchp;

	mSlob pa(a);
	mSlob pb(b);
	
	Locator pointsa(pa.locateGlobal());
	Locator pointsb(pb.locateGlobal());
	
	vpoint2D psa(pointsa);
	vpoint2D psb(pointsb);
	
	int cc=(int)VTP2D::Disjoint(psa,psb);
	return cc;
/*	int cc=(int)p.count(points);
	return cc;*/
}


extern "C" int vpoint_Overlap(OCIExtProcContext *ctx, OCILobLocator* A, OCILobLocator* B){
	OCIEnv   *envhp;
	OCISvcCtx  *svchp;
	OCIError   *errhp;
	sword  retval;
	retval = OCIExtProcGetEnv (ctx, &envhp, &svchp, &errhp);

	OCILobWrapper *a=new OCILobWrapper;
	a->lob=A;
	a->errhp=errhp;
	a->cntxt=svchp;
	
	OCILobWrapper *b=new OCILobWrapper;
	b->lob=B;
	b->errhp=errhp;
	b->cntxt=svchp;

	mSlob pa(a);
	mSlob pb(b);
	
	Locator pointsa(pa.locateGlobal());
	Locator pointsb(pb.locateGlobal());
	
	vpoint2D psa(pointsa);
	vpoint2D psb(pointsb);
	
	int cc=(int)VTP2D::Overlap(psa,psb);
	return cc;
	/*int cc=(int)p.count(points);
	return cc;*/
}
