/** This class is for representing complex point objects.
 * A complex point represents a set of single points in the plane.
 	@see poi2D.
 *  \author Alejandro Pauly, Mark McKenney
 *  \version 0.1
 *  \date    2005-10-05
 *  \version 0.2
 *  \date    2005-10-14
 *  \version 0.3
 *  \date    2005-11-25 
 *  \version 0.4 Removed Impl stuff, fixing for mSlob
 *  \date    2006-09-28 
 * 
 */
 
#ifndef VPOINT2D_H
#define VPOINT2D_H

#include "num.h"
#include "constants.h"
#include "point2D.h"
#include "mSlob.h"
#include "undefinedSpatialObjectException.h"
#include "vectorBinarySearchWrapper.h"
#include "user_types.h"
#include "vasa_types.h"
#include "TopPred2D.h"

/*namespace stu
{*/
	using namespace stu;
	using namespace std;
	

	class vpoint2D{
			
		public:
			
			vpoint2D();
			vpoint2D(const Locator& m);
			vpoint2D(const Locator& m, const point2D &k, const point2D &c);
			vpoint2D(const Locator& m, const vpoint2D& ps);
	
			~vpoint2D();
	
			uint size() const; //the number of points

			
			//constructor ops
			point2D getKernel() const; //adds point checks it didn't exist already
			point2D getConjecture() const; //adds point checks it didn't exist already
			void setKernel(const point2D& k) throw (undefinedSpatialObjectException); //set this kernel as the given (copy)
			void setConjecture(const point2D& c) throw (undefinedSpatialObjectException); //set this conjecture as the given (copy)
	
			trival isEmpty() const; //returns getSize()==0

			bool validate();

			bool isValid() const;

			mbb2D getmbb() const;

			//homogeneous ops
			vpoint2D intersection(const vpoint2D &other) const;
			vpoint2D sunion(const vpoint2D &other) const;	
			vpoint2D difference(const vpoint2D &other) const;
	
			const uint getMinPointCount() const; //returns the size/number of kernel points
			const uint getMaxPointCount() const; //returns the size/number of kernel+conjecture points
			
			rat min_mindistance(const vpoint2D &other) const; //returns the min min distance, considers conjecture
			rat max_mindistance(const vpoint2D &other) const; //returns the max min distance, only considering kernel
	
			//heterogeneous ops
// 			point2D & intersection(const line2D& other) const;
// 			point2D & intersection(const region2D& other) const;
// 			point2D & difference(const line2D& other) const;
// 			point2D & difference(const region2D& other) const;
// 	
// 			rat &distance(const line2D &other) const;
// 			rat &distance(const region2D &other) const;
			
			//Output operator
			friend std::ostream &operator << (std::ostream &ostr, const vpoint2D &rhs) throw( undefinedSpatialObjectException );
				
		
		private:
			Locator global; //represents whole object
			point2D kernel;
			point2D conjecture;

			bool valid;
	};
// }
#endif

