#include "vpoint2D.h"
#include <iostream>

// namespace stu
// {
	using namespace stu;
	using namespace std;
			
	vpoint2D::vpoint2D():global(static_cast<bool>(true)), kernel(static_cast<bool>(false)), conjecture(static_cast<bool>(false)), valid(true)
	{
		//global.debug();
		//cerr << "Inserting kernel dude" << endl;
		kernel=point2D(static_cast<Locator>(global.insert(0, OBJECT_LEVEL)));
		//global.debug();
		//cerr << "Inserting conjecture dude" << endl;
		conjecture=point2D(global.insert(1, OBJECT_LEVEL));
	}
	
	vpoint2D::vpoint2D(const Locator& m): global(m),kernel(static_cast<bool>(false)),conjecture(static_cast<bool>(false)), valid(false)
	{
		if (global.getElements()==0) //then its an empty COLLECTION NODE, insert objects
		{
			kernel=point2D(global.insert(0)); //insert, then get kernel
			conjecture=point2D(global.insert(1)); //insert, then get conjecture
			valid=true;
		}
		else
		{
			//cerr << "Will assign" << endl;
			kernel=point2D(global.locate(0)); //get kernel
			conjecture=point2D(global.locate(1)); //get conjecture
			//cerr << "Assigned" << endl;
			valid=validate();
			//cerr << "Validated" << endl;
		}
	}
	
	vpoint2D::vpoint2D(const Locator& m, const point2D &k,  const point2D &c): global(m), kernel(global.insert(0, OBJECT_LEVEL),k), conjecture(global.insert(1,OBJECT_LEVEL),c), valid(false)
	{	
	}
	
	vpoint2D::vpoint2D(const Locator& m, const vpoint2D &ps): global(m), kernel(global.insert(0, OBJECT_LEVEL),ps.getKernel()), conjecture(global.insert(1, OBJECT_LEVEL),ps.getConjecture()), valid(ps.valid)
	{		
	}

	vpoint2D::~vpoint2D()
	{
	}
	

	point2D vpoint2D::getKernel() const { return kernel; }
	
	point2D vpoint2D::getConjecture() const { return conjecture; }
	
	void vpoint2D::setKernel(const point2D& k) throw (undefinedSpatialObjectException){ kernel=k; }
	
	void vpoint2D::setConjecture(const point2D& c) throw (undefinedSpatialObjectException){ conjecture=c; }
	
	
	trival vpoint2D::isEmpty() const
	{
		if (!kernel.isEmpty())
			return VFALSE;
		else if (!conjecture.isEmpty())
			return VMAYBE;
		else
			return VTRUE;
	}
	
	bool vpoint2D::validate()
	{
		valid=true; //assume at first that it is valid, now try to invalidate
		if (!(kernel.isValid() && conjecture.isValid()))
			valid=false;

		//check top predicate between kernel and conjecture
		int rel=TopPred2D::topPred(kernel,conjecture);
		
		if (rel!=1)
			valid=false;
		
		return valid;
	}

	bool vpoint2D::isValid() const
	{
		return valid;
	}
	
	mbb2D vpoint2D::getmbb() const 
	{
		if (!valid)
			cerr << "Undefined Object. No MBB Available" << endl;

		rat minx(0);
		rat miny(0);
		rat maxx(0);
		rat maxy(0);

		mbb2D km=kernel.getmbb();
 		mbb2D cm=conjecture.getmbb();

		minx=km.getB().getX();
		miny=km.getB().getY();

		maxx=km.getU().getX();
		maxy=km.getU().getY();

		if (cm.getB().getX()<minx) minx=cm.getB().getX();
		if (cm.getB().getY()<miny) miny=cm.getB().getY();
		if (cm.getU().getX()>maxx) maxx=cm.getU().getX();
		if (cm.getU().getY()>maxx) maxx=cm.getU().getX();

		return  mbb2D(poi2D(minx,miny),poi2D(maxx,maxy));
	}
	
	//homogeneous ops
	vpoint2D vpoint2D::intersection(const vpoint2D &other) const 
	{ 
		vpoint2D toreturn;
		toreturn.setKernel(getKernel().intersection(other.getKernel()));
		toreturn.setConjecture(((getConjecture().intersection(other.getConjecture())).sunion(getKernel().intersection(other.getConjecture()))).sunion(getConjecture().intersection(other.getKernel())));
		
		return toreturn;
	}

	vpoint2D vpoint2D::sunion(const vpoint2D &other) const 
	{
		vpoint2D toreturn;
		toreturn.setKernel(getKernel().sunion(other.getKernel()));
		toreturn.setConjecture((getConjecture().sunion(other.getConjecture())).difference(getKernel().sunion(other.getKernel())));
		
		return toreturn;
	}	

	vpoint2D vpoint2D::difference(const vpoint2D &other) const 
	{
		vpoint2D toreturn;
		toreturn.setKernel(getKernel().difference((other.getKernel()).sunion(other.getConjecture())));
		toreturn.setConjecture(
				(getConjecture().intersection(other.getConjecture())).sunion
				(
					(getKernel().intersection(other.getConjecture())).sunion(
				getConjecture().difference((other.getKernel()).sunion(other.getConjecture()))
																			)
				)
							  );
		
		return toreturn;
		
	}
	
	
	const uint vpoint2D::getMinPointCount() const //returns the size/number of kernel points
	{
		return kernel.getPointCount();
	}
	
	const uint vpoint2D::getMaxPointCount() const //returns the size/number of kernel+conjecture points
	{
		return (kernel.getPointCount()+conjecture.getPointCount());	
	}
	
	rat vpoint2D::min_mindistance(const vpoint2D &other) const //returns the minimum distance
	{
		rat min;

		min=(getKernel().sunion(getConjecture())).distance(other.getKernel().sunion(other.getConjecture()));
		
		return min;
	}
	
	rat vpoint2D::max_mindistance(const vpoint2D &other) const //returns the minimum distance
	{
		rat min;

		min=getKernel().distance(other.getKernel());
		
		return min;
	}

	
	//heterogeneous ops
// 	point2D& point2D::intersection(const line2D &other)const {return *(new point2D(*this));}
// 	point2D& point2D::intersection(const region2D &other)const {return *(new point2D(*this));}
// 	point2D& point2D::difference(const line2D &other)const {return *(new point2D(*this));}
// 	point2D& point2D::difference(const region2D &other)const {return *(new point2D(*this));}
// 	
// 	rat &point2D::distance(const line2D &other)const {return *(new rat(1));}
// 	rat &point2D::distance(const region2D &other)const {return *(new rat(1));}
	
	std::ostream& operator << (std::ostream &ostr, const vpoint2D &rhs) throw( undefinedSpatialObjectException )
	{
		if( !rhs.isValid( ) ) {
			ostr<< "--Undefined--" ;
		} 	
		ostr << "Kernel: " << rhs.getKernel() << endl;
		ostr << "Conjecture: " << rhs.getConjecture() << endl;
		
		return ostr;
	}

// }

