#ifndef VLINE2D_H
#define VLINE2D_H

#include "num.h"
#include "constants.h"
#include "line2D.h"
#include "mSlob.h"
#include "undefinedSpatialObjectException.h"
#include "vectorBinarySearchWrapper.h"
#include "user_types.h"
#include "vasa_types.h"
#include "TopPred2D.h"

/*namespace stu
{*/
	using namespace stu;
	using namespace std;
	

	class vline2D{
			
		public:
			
			vline2D();
			vline2D(const Locator& m);
			vline2D(const Locator& m, const line2D &k, const line2D &c);
			vline2D(const Locator& m, const vline2D& ps);
	
			~vline2D();
	
			uint size() const; //the number of points

			
			//constructor ops
			line2D getKernel() const; //adds point checks it didn't exist already
			line2D getConjecture() const; //adds point checks it didn't exist already
			void setKernel(const line2D& k) throw (undefinedSpatialObjectException); //set this kernel as the given (copy)
			void setConjecture(const line2D& c) throw (undefinedSpatialObjectException); //set this conjecture as the given (copy)
	
			trival isEmpty() const; //returns getSize()==0

			bool validate();

			bool isValid() const;

			mbb2D getmbb() const;

			//homogeneous ops
			vline2D intersection(const vline2D &other) const;
			vline2D sunion(const vline2D &other) const;	
			vline2D difference(const vline2D &other) const;
	
			rat min_mindistance(const vline2D &other) const; //returns the min min distance, considers conjecture
			rat max_mindistance(const vline2D &other) const; //returns the max min distance, only considering kernel
	
			rat min_length() const; //returns the min length, only considering kernel
			rat max_length() const; //returns the max length, considers conjecture
			
			//Output operator
			friend std::ostream &operator << (std::ostream &ostr, const vline2D &rhs) throw( undefinedSpatialObjectException );
		
		private:
			Locator global; //represents whole object
			line2D kernel;
			line2D conjecture;

			bool valid;
	};
// }
#endif

