#include "vline2D.h"
#include <iostream>

// namespace stu
// {
	using namespace stu;
	using namespace std;
			
	vline2D::vline2D():global(true), kernel(global.insert(0, OBJECT_LEVEL)), conjecture(global.insert(1, OBJECT_LEVEL)), valid(true)
	{}
	
	vline2D::vline2D(const Locator& m): global(m),kernel(static_cast<bool>(false)),conjecture(static_cast<bool>(false)), valid(false)
	{
		cerr << "In Here!" << endl;
		if (global.getElements()==0) //then its an empty COLLECTION NODE, insert objects
		{
			kernel=line2D(global.insert(0)); //insert, then get kernel
			conjecture=line2D(global.insert(1)); //insert, then get conjecture
			valid=true;
		}
		else
		{
			kernel=line2D(global.locate(0)); //get kernel
			conjecture=line2D(global.locate(1)); //get conjecture
			valid=validate();
		}
	}
	
	vline2D::vline2D(const Locator& m, const line2D &k,  const line2D &c): global(m), kernel(global.insert(0, OBJECT_LEVEL),k), conjecture(global.insert(1,OBJECT_LEVEL),c), valid(false)
	{	
	}
	
	vline2D::vline2D(const Locator& m, const vline2D &ps): global(m), kernel(global.insert(0, OBJECT_LEVEL),ps.getKernel()), conjecture(global.insert(1, OBJECT_LEVEL),ps.getConjecture()), valid(ps.valid)
	{		
	}

	vline2D::~vline2D()
	{
	}
	

	line2D vline2D::getKernel() const { return kernel; }
	
	line2D vline2D::getConjecture() const { return conjecture; }
	
	void vline2D::setKernel(const line2D& k) throw (undefinedSpatialObjectException){ kernel=k; }
	
	void vline2D::setConjecture(const line2D& c) throw (undefinedSpatialObjectException){ conjecture=c; }
	
	
	trival vline2D::isEmpty() const
	{
		if (!kernel.isEmpty())
			return VFALSE;
		else if (!conjecture.isEmpty())
			return VMAYBE;
		else
			return VTRUE;
	}
	
	bool vline2D::validate()
	{
		valid=true; //assume at first that it is valid, now try to invalidate
		if (!(kernel.isValid() && conjecture.isValid()))
			valid=false;

		//check top predicate between kernel and conjecture
		int rel=TopPred2D::topPred(kernel,conjecture);
		
		if (rel>8) //disallows intersection boundary/interior
			valid=false;
		
		//if (rel>32) //allows intersection boundary/interior
		//	valid=false;
		
		return valid;
	}

	bool vline2D::isValid() const
	{
		return valid;
	}
	
	mbb2D vline2D::getmbb() const 
	{
		if (!valid)
			cerr << "Undefined Object. No MBB Available" << endl;

		rat minx(0);
		rat miny(0);
		rat maxx(0);
		rat maxy(0);

		mbb2D km=kernel.getmbb();
 		mbb2D cm=conjecture.getmbb();

		minx=km.getB().getX();
		miny=km.getB().getY();

		maxx=km.getU().getX();
		maxy=km.getU().getY();

		if (cm.getB().getX()<minx) minx=cm.getB().getX();
		if (cm.getB().getY()<miny) miny=cm.getB().getY();
		if (cm.getU().getX()>maxx) maxx=cm.getU().getX();
		if (cm.getU().getY()>maxx) maxx=cm.getU().getX();

		return  mbb2D(poi2D(minx,miny),poi2D(maxx,maxy));
	}
	
	//homogeneous ops
	vline2D vline2D::intersection(const vline2D &other) const 
	{ 
		vline2D toreturn;
		line2D ok=other.getKernel();
		line2D oc=other.getConjecture();
		line2D k=getKernel();
		line2D c=getConjecture();
		toreturn.setKernel(k.intersection(ok));
		toreturn.setConjecture(((c.intersection(oc)).sunion(k.intersection(oc))).sunion(c.intersection(ok)));
		
		return toreturn;
	}

	vline2D vline2D::sunion(const vline2D &other) const 
	{
		vline2D toreturn;
		line2D ok=other.getKernel();
		line2D oc=other.getConjecture();
		line2D k=getKernel();
		line2D c=getConjecture();
		toreturn.setKernel(k.sunion(ok));
		toreturn.setConjecture((c.sunion(oc)).difference(k.sunion(oc)));
		
		return toreturn;
	}	

	vline2D vline2D::difference(const vline2D &other) const 
	{
		vline2D toreturn;
		line2D ok=other.getKernel();
		line2D oc=other.getConjecture();
		line2D k=getKernel();
		line2D c=getConjecture();
		
		toreturn.setKernel(k.difference((ok).sunion(oc)));
		toreturn.setConjecture(
				(c.intersection(oc)).sunion
				(
					(k.intersection(oc)).sunion(
				c.difference((ok).sunion(oc))
																			)
				)
							  );
		
		return toreturn;
		
	}
	
	rat vline2D::min_mindistance(const vline2D &other) const //returns the minimum distance
	{
		rat min;
		line2D ok=other.getKernel();
		line2D oc=other.getConjecture();
		line2D k=getKernel();
		line2D c=getConjecture();

		min=(k.sunion(c)).distance(ok.sunion(oc));
		
		return min;
	}
	
	rat vline2D::max_mindistance(const vline2D &other) const //returns the minimum distance
	{
		rat min;

		min=getKernel().distance(other.getKernel());
		
		return min;
	}

	rat vline2D::min_length() const //returns the min length, only considering kernel
	{
		return kernel.getLength();
	}
	
	rat vline2D::max_length() const //returns the max length, considers conjecture
	{
		return kernel.getLength() + conjecture.getLength();	
	}
	
	//heterogeneous ops
// 	line2D& line2D::intersection(const line2D &other)const {return *(new line2D(*this));}
// 	line2D& line2D::intersection(const region2D &other)const {return *(new line2D(*this));}
// 	line2D& line2D::difference(const line2D &other)const {return *(new line2D(*this));}
// 	line2D& line2D::difference(const region2D &other)const {return *(new line2D(*this));}
// 	
// 	rat &line2D::distance(const line2D &other)const {return *(new rat(1));}
// 	rat &line2D::distance(const region2D &other)const {return *(new rat(1));}
	
	std::ostream& operator << (std::ostream &ostr, const vline2D &rhs) throw( undefinedSpatialObjectException )
	{
		if( !rhs.isValid( ) ) {
			ostr<< "--Undefined--" ;
		} 	
		ostr << "Kernel: " << rhs.getKernel() << endl;
		ostr << "Conjecture: " << rhs.getConjecture() << endl;
		
		return ostr;
	}

// }

