create or replace library vasa_lib as '/var/opt/oracle/product/10.2.0.1/lib/tvpoints.so'; 
/

create or replace type vpoint2D as Object (
	pdata blob,
		member function getMinCount 	return pls_integer,
		member function getMaxCount 	return pls_integer,
		member function Disjoint(b blob) 	return pls_integer,
		member function Overlap(b blob)	return pls_integer	
);
/

CREATE or replace PACKAGE vpoint_pkg AS  
   function vpoint_getMinCount(b blob) return pls_integer;
   function vpoint_getMaxCount(b blob) return pls_integer;
   function vpoint_Disjoint(a blob, b blob) return pls_integer;
   function vpoint_Overlap(a blob, b blob) return pls_integer;
END;
/

create or replace package body vpoint_pkg as
	function vpoint_getMinCount(b blob) return pls_integer 
	as external
	language C WITH CONTEXT
	name "vpoint_getMinCount"
	library VASA_LIB 
	parameters(CONTEXT, b OCILobLocator); 

	function vpoint_getMaxCount(b blob) return pls_integer 
	as external
	language C WITH CONTEXT
	name "vpoint_getMaxCount"
	library VASA_LIB 
	parameters(CONTEXT, b OCILobLocator); 

	function vpoint_Disjoint(a blob, b blob) return pls_integer 
	as external
	language C WITH CONTEXT
	name "vpoint_Disjoint"
	library VASA_LIB 
	parameters(CONTEXT, a OCILobLocator, b OCILobLocator); 

	function vpoint_Overlap(a blob, b blob) return pls_integer 
	as external
	language C WITH CONTEXT
	name "vpoint_Overlap"
	library VASA_LIB 
	parameters(CONTEXT, a OCILobLocator, b OCILobLocator); 
end;
/

create or replace type body vpoint2D is
		member function getMinCount 	return pls_integer is
			num pls_integer := vpoint_pkg.vpoint_getMinCount(pdata);
			BEGIN
				return num;
			END;

		member function getMaxCount 	return pls_integer is
			num pls_integer := vpoint_pkg.vpoint_getMaxCount(pdata);
			BEGIN
				return num;
			END;

		member function Disjoint(b blob) return pls_integer is
			num pls_integer := vpoint_pkg.vpoint_getMinCount(pdata);
			BEGIN
				return num;
			END;

		member function Overlap(b blob) return pls_integer is
			num pls_integer := vpoint_pkg.vpoint_getMaxCount(pdata);
			BEGIN
				return num;
			END;
end;
/

create table testvpoint(
	id integer primary key,
	vpointy vpoint2D
);

select id, vpoint2D.getMinCount(pointy) from testvpoint;