#ifndef VTP2D_H
#define VTP2D_H

#include "vpoint2D.h"
#include "vline2D.h"
#include "vregion2D.h"
#include "TopPred2D.h"
#include "vasa_types.h"

namespace stu
{
	using namespace stu;
	class VTP2D
	{
		public:

	// vpoint2D predicates
			static trival Disjoint( vpoint2D&,  vpoint2D&);
			static trival Overlap( vpoint2D&,  vpoint2D&);
			static trival Meet( vpoint2D&,  vpoint2D&);
			static trival Equal( vpoint2D&,  vpoint2D&);
			static trival Covers( vpoint2D&,  vpoint2D&);
			static trival Contain( vpoint2D&,  vpoint2D&);
			static trival CoveredBy( vpoint2D&,  vpoint2D&);
			static trival Inside( vpoint2D&,  vpoint2D&);
	
	// vvline2D predicates
			static trival Disjoint( vline2D&,  vline2D&);
			static trival Overlap( vline2D&,  vline2D&);
			static trival Meet( vline2D&,  vline2D&);
			static trival Equal( vline2D&,  vline2D&);
			static trival Covers( vline2D&,  vline2D&);
			static trival Contain( vline2D&,  vline2D&);
			static trival CoveredBy( vline2D&,  vline2D&);
			static trival Inside( vline2D&,  vline2D&);
	
	// vregion2D predicates
			static trival Disjoint( vregion2D&,  vregion2D&);
			static trival Overlap( vregion2D&,  vregion2D&);
			static trival Meet( vregion2D&,  vregion2D&);
			static trival Equal( vregion2D&,  vregion2D&);
			static trival Covers( vregion2D&,  vregion2D&);
			static trival Contain( vregion2D&,  vregion2D&);
			static trival CoveredBy( vregion2D&,  vregion2D&);
			static trival Inside( vregion2D&,  vregion2D&);
			
		private:
			static bool rr_matrix[33][9];
			static bool ll_matrix[82][9];
			static bool pp_matrix[5][9];
			
			static trival Disjoint( bool mkk[9],  bool mAk[9],
									bool mkB[9],  bool mAB[9]);
			static trival Overlap( bool mkk[9],  bool mAk[9],
									bool mkB[9],  bool mAB[9]);
			static trival Meet( bool mkk[9],  bool mAk[9],
								bool mkB[9],  bool mAB[9]);
			static trival Equal( bool mkk[9],  bool mAk[9],
									bool mkB[9],  bool mAB[9]);
			static trival CoveredBy( bool mkk[9],  bool mAk[9],
										bool mkB[9],  bool mAB[9]);
			static trival Inside( bool mkk[9],  bool mAk[9],
									bool mkB[9],  bool mAB[9]);

			static void pointPQRS( vpoint2D& A,  vpoint2D& B, int& p, int& q, int& r, int& s);
			static void linePQRS( vline2D& A,  vline2D& B, int& p, int& q, int& r, int& s);
			static void regionPQRS( vregion2D& A,  vregion2D& B, int& p, int& q, int& r, int& s);
	};
}
#endif //VTP2D_H
