#include "VTP2D.h"

				bool VTP2D::pp_matrix[5][9] = {{false,false,true,false,false,false,true,false,true},
				{true,false,false,false,false,false,false,false,true},
				{true,false,false,false,false,false,true,false,true},
				{true,false,true,false,false,false,false,false,true},
				{true,false,true,false,false,false,true,false,true}};
			
				bool VTP2D::ll_matrix[82][9]= { {0,0,1,0,0,0,1,0,1},{0,0,1,0,0,0,1,1,1},{0,0,1,0,0,1,1,0,1},{0,0,1,0,0,1,1,1,1},
				{0,0,1,0,1,0,1,0,1},{0,0,1,0,1,0,1,1,1},{0,0,1,0,1,1,1,0,1},{0,0,1,0,1,1,1,1,1},
				{0,0,1,1,0,0,1,0,1},{0,0,1,1,0,0,1,1,1},{0,0,1,1,0,1,1,0,1},{0,0,1,1,0,1,1,1,1},
				{0,0,1,1,1,0,1,0,1},{0,0,1,1,1,0,1,1,1},{0,0,1,1,1,1,1,0,1},{0,0,1,1,1,1,1,1,1},
				{0,1,1,0,0,0,1,0,1},{0,1,1,0,0,0,1,1,1},{0,1,1,0,0,1,1,0,1},{0,1,1,0,0,1,1,1,1},
				{0,1,1,0,1,0,1,0,1},{0,1,1,0,1,0,1,1,1},{0,1,1,0,1,1,1,0,1},{0,1,1,0,1,1,1,1,1},
				{0,1,1,1,0,0,1,0,1},{0,1,1,1,0,0,1,1,1},{0,1,1,1,0,1,1,0,1},{0,1,1,1,0,1,1,1,1},
				{0,1,1,1,1,0,1,0,1},{0,1,1,1,1,0,1,1,1},{0,1,1,1,1,1,1,0,1},{0,1,1,1,1,1,1,1,1},
				{1,0,0,0,0,0,0,0,1},{1,0,0,0,0,0,1,0,1},{1,0,0,0,0,0,1,1,1},{1,0,0,0,1,0,0,0,1},
				{1,0,0,0,1,0,1,0,1},{1,0,0,0,1,0,1,1,1},{1,0,0,1,0,0,1,0,1},{1,0,0,1,0,0,1,1,1},
				{1,0,0,1,1,0,1,0,1},{1,0,0,1,1,0,1,1,1},{1,0,1,0,0,0,0,0,1},{1,0,1,0,0,0,1,0,1},
				{1,0,1,0,0,0,1,1,1},{1,0,1,0,0,1,0,0,1},{1,0,1,0,0,1,1,0,1},{1,0,1,0,0,1,1,1,1},
				{1,0,1,0,1,0,0,0,1},{1,0,1,0,1,0,1,0,1},{1,0,1,0,1,0,1,1,1},{1,0,1,0,1,1,0,0,1},
				{1,0,1,0,1,1,1,0,1},{1,0,1,0,1,1,1,1,1},{1,0,1,1,0,0,1,0,1},{1,0,1,1,0,0,1,1,1},
				{1,0,1,1,0,1,1,0,1},{1,0,1,1,0,1,1,1,1},{1,0,1,1,1,0,1,0,1},{1,0,1,1,1,0,1,1,1},
				{1,0,1,1,1,1,1,0,1},{1,0,1,1,1,1,1,1,1},{1,1,1,0,0,0,0,0,1},{1,1,1,0,0,0,1,0,1},
				{1,1,1,0,0,0,1,1,1},{1,1,1,0,0,1,0,0,1},{1,1,1,0,0,1,1,0,1},{1,1,1,0,0,1,1,1,1},
				{1,1,1,0,1,0,0,0,1},{1,1,1,0,1,0,1,0,1},{1,1,1,0,1,0,1,1,1},{1,1,1,0,1,1,0,0,1},
				{1,1,1,0,1,1,1,0,1},{1,1,1,0,1,1,1,1,1},{1,1,1,1,0,0,1,0,1},{1,1,1,1,0,0,1,1,1},
				{1,1,1,1,0,1,1,0,1},{1,1,1,1,0,1,1,1,1},{1,1,1,1,1,0,1,0,1},{1,1,1,1,1,0,1,1,1},
				{1,1,1,1,1,1,1,0,1},{1,1,1,1,1,1,1,1,1} };
			
				
				bool VTP2D::rr_matrix[33][9]={ {false,false,true,false,false,true,true,true,true},{false,false,true,false,true,false,true,true,true},{false,false,true,false,true,true,true,false,true},
					{false,false,true,false,true,true,true,true,true},{true,false,false,false,true,false,false,false,true},{true,false,false,false,true,false,true,true,true},
					{true,false,false,true,false,false,true,true,true},{true,false,false,true,true,false,true,false,true},{true,false,false,true,true,false,true,true,true},
					{true,false,true,false,true,false,true,true,true},{true,false,true,false,true,true,false,false,true},{true,false,true,false,true,true,true,false,true},
					{true,false,true,false,true,true,true,true,true},{true,false,true,true,false,true,true,true,true},{true,false,true,true,true,false,true,false,true},
					{true,false,true,true,true,false,true,true,true},{true,false,true,true,true,true,true,false,true},{true,false,true,true,true,true,true,true,true},
					{true,true,true,false,false,true,false,false,true},{true,true,true,false,false,true,true,true,true},{true,true,true,false,true,false,false,false,true},
					{true,true,true,false,true,false,true,false,true},{true,true,true,false,true,false,true,true,true},{true,true,true,false,true,true,false,false,true},
					{true,true,true,false,true,true,true,false,true},{true,true,true,false,true,true,true,true,true},{true,true,true,true,false,false,true,true,true},
					{true,true,true,true,false,true,true,false,true},{true,true,true,true,false,true,true,true,true},{true,true,true,true,true,false,true,false,true},
					{true,true,true,true,true,false,true,true,true},{true,true,true,true,true,true,true,false,true},{true,true,true,true,true,true,true,true,true} };


	/* Translation of Matrix entries to single index:
		0,0 = 0
		0,1 = 1
		0,2 = 2
		1,0 = 3
		1,1 = 4
		1,2 = 5
		2,0 = 6
		2,1 = 7
		2,2 = 8
	*/

	trival VTP2D::Disjoint( vpoint2D& A,  vpoint2D& B)
	{
		int p,q,r,s;
		return VTRUE;
		pointPQRS(A,B,p,q,r,s);
	
		return Disjoint(pp_matrix[p], pp_matrix[q], pp_matrix[r], pp_matrix[s]);
	}

	trival VTP2D::Overlap( vpoint2D& A,  vpoint2D& B)
	{
		int p,q,r,s;
		pointPQRS(A,B,p,q,r,s);
	
		return Overlap(pp_matrix[p], pp_matrix[q], pp_matrix[r], pp_matrix[s]);	
	}
	
	trival VTP2D::Meet( vpoint2D& A,  vpoint2D& B)
	{
		int p,q,r,s;
		pointPQRS(A,B,p,q,r,s);
	
		return Meet(pp_matrix[p], pp_matrix[q], pp_matrix[r], pp_matrix[s]);
	}

	trival VTP2D::Equal( vpoint2D& A,  vpoint2D& B)
	{
		int p,q,r,s;
		pointPQRS(A,B,p,q,r,s);
	
		return Equal(pp_matrix[p], pp_matrix[q], pp_matrix[r], pp_matrix[s]);
	}

	trival VTP2D::Covers( vpoint2D& A,  vpoint2D& B)
	{
		int p,q,r,s;
		pointPQRS(B,A,p,q,r,s);
	
		return CoveredBy(pp_matrix[p], pp_matrix[q], pp_matrix[r], pp_matrix[s]);
	}

	trival VTP2D::Contain( vpoint2D& A,  vpoint2D& B)
	{
		int p,q,r,s;
		pointPQRS(B,A,p,q,r,s);
	
		return Inside(pp_matrix[p], pp_matrix[q], pp_matrix[r], pp_matrix[s]);
	}

	trival VTP2D::CoveredBy( vpoint2D& A,  vpoint2D& B)
	{	
		int p,q,r,s;
		pointPQRS(A,B,p,q,r,s);
	
		return CoveredBy(pp_matrix[p], pp_matrix[q], pp_matrix[r], pp_matrix[s]);
	}

	trival VTP2D::Inside( vpoint2D& A,  vpoint2D& B)
	{
		int p,q,r,s;
		pointPQRS(A,B,p,q,r,s);
	
		return Inside(pp_matrix[p], pp_matrix[q], pp_matrix[r], pp_matrix[s]);
	}

	trival VTP2D::Disjoint( vline2D& A,  vline2D& B)
	{
		int p,q,r,s;
		linePQRS(A,B,p,q,r,s);
	
		return Disjoint(ll_matrix[p], ll_matrix[q], ll_matrix[r], ll_matrix[s]);
	}

	trival VTP2D::Overlap( vline2D& A,  vline2D& B)
	{
		int p,q,r,s;
		linePQRS(A,B,p,q,r,s);
	
		return Overlap(ll_matrix[p], ll_matrix[q], ll_matrix[r], ll_matrix[s]);	
	}
	
	trival VTP2D::Meet( vline2D& A,  vline2D& B)
	{
		int p,q,r,s;
		linePQRS(A,B,p,q,r,s);
	
		return Meet(ll_matrix[p], ll_matrix[q], ll_matrix[r], ll_matrix[s]);
	}

	trival VTP2D::Equal( vline2D& A,  vline2D& B)
	{
		int p,q,r,s;
		linePQRS(A,B,p,q,r,s);
	
		return Equal(ll_matrix[p], ll_matrix[q], ll_matrix[r], ll_matrix[s]);
	}

	trival VTP2D::Covers( vline2D& A,  vline2D& B)
	{
		int p,q,r,s;
		linePQRS(B,A,p,q,r,s);
	
		return CoveredBy(ll_matrix[p], ll_matrix[q], ll_matrix[r], ll_matrix[s]);
	}

	trival VTP2D::Contain( vline2D& A,  vline2D& B)
	{
		int p,q,r,s;
		linePQRS(B,A,p,q,r,s);
	
		return Inside(ll_matrix[p], ll_matrix[q], ll_matrix[r], ll_matrix[s]);
	}

	trival VTP2D::CoveredBy( vline2D& A,  vline2D& B)
	{	
		int p,q,r,s;
		linePQRS(A,B,p,q,r,s);
	
		return CoveredBy(ll_matrix[p], ll_matrix[q], ll_matrix[r], ll_matrix[s]);
	}

	trival VTP2D::Inside( vline2D& A,  vline2D& B)
	{
		int p,q,r,s;
		linePQRS(A,B,p,q,r,s);
	
		return Inside(ll_matrix[p], ll_matrix[q], ll_matrix[r], ll_matrix[s]);
	}
	
	trival VTP2D::Disjoint( vregion2D& A,  vregion2D& B)
	{
		int p,q,r,s;
		regionPQRS(A,B,p,q,r,s);
	
		return Disjoint(rr_matrix[p], rr_matrix[q], rr_matrix[r], rr_matrix[s]);
	}

	trival VTP2D::Overlap( vregion2D& A,  vregion2D& B)
	{
		int p,q,r,s;
		regionPQRS(A,B,p,q,r,s);
	
		return Overlap(rr_matrix[p], rr_matrix[q], rr_matrix[r], rr_matrix[s]);	
	}
	
	trival VTP2D::Meet( vregion2D& A,  vregion2D& B)
	{
		int p,q,r,s;
		regionPQRS(A,B,p,q,r,s);
	
		return Meet(rr_matrix[p], rr_matrix[q], rr_matrix[r], rr_matrix[s]);
	}

	trival VTP2D::Equal( vregion2D& A,  vregion2D& B)
	{
		int p,q,r,s;
		regionPQRS(A,B,p,q,r,s);
	
		return Equal(rr_matrix[p], rr_matrix[q], rr_matrix[r], rr_matrix[s]);
	}

	trival VTP2D::Covers( vregion2D& A,  vregion2D& B)
	{
		int p,q,r,s;
		regionPQRS(B,A,p,q,r,s);
	
		return CoveredBy(rr_matrix[p], rr_matrix[q], rr_matrix[r], rr_matrix[s]);
	}

	trival VTP2D::Contain( vregion2D& A,  vregion2D& B)
	{
		int p,q,r,s;
		regionPQRS(B,A,p,q,r,s);
	
		return Inside(rr_matrix[p], rr_matrix[q], rr_matrix[r], rr_matrix[s]);
	}

	trival VTP2D::CoveredBy( vregion2D& A,  vregion2D& B)
	{	
		int p,q,r,s;
		regionPQRS(A,B,p,q,r,s);
	
		return CoveredBy(rr_matrix[p], rr_matrix[q], rr_matrix[r], rr_matrix[s]);
	}

	trival VTP2D::Inside( vregion2D& A,  vregion2D& B)
	{
		int p,q,r,s;
		regionPQRS(A,B,p,q,r,s);
	
		return Inside(rr_matrix[p], rr_matrix[q], rr_matrix[r], rr_matrix[s]);
	}
	
	static int II=0;
	static int IB=1;
	static int IE=2;
	static int BI=3;
	static int BB=4;
	static int BE=5;
	static int EI=6;
	static int EB=7;
	static int EE=8;

	void VTP2D::pointPQRS( vpoint2D& A,  vpoint2D& B, int& p, int& q, int& r, int& s)
	{
		point2D Ak(A.getKernel());
		point2D Bk(A.getKernel());
		point2D uA(A.getConjecture().sunion(Ak));
		point2D uB(B.getConjecture().sunion(Bk));
		
		p=TopPred2D::topPred(Ak,Bk);
		q=TopPred2D::topPred(uA,Bk);
		r=TopPred2D::topPred(Ak,uB);
		s=TopPred2D::topPred(uA,uB);
	}
	
	void VTP2D::linePQRS( vline2D& A,  vline2D& B, int& p, int& q, int& r, int& s)
	{
		line2D Ak(A.getKernel());
		line2D Bk(A.getKernel());
		line2D uA(A.getConjecture().sunion(Ak));
		line2D uB(B.getConjecture().sunion(Bk));
		
		p=TopPred2D::topPred(Ak,Bk);
		q=TopPred2D::topPred(uA,Bk);
		r=TopPred2D::topPred(Ak,uB);
		s=TopPred2D::topPred(uA,uB);
	}
		
	void VTP2D::regionPQRS( vregion2D& A,  vregion2D& B, int& p, int& q, int& r, int& s)
	{
		region2D Ak(A.getKernel());
		region2D Bk(A.getKernel());
		region2D uA(A.getConjecture().sunion(Ak));
		region2D uB(B.getConjecture().sunion(Bk));
		
		p=TopPred2D::topPred(Ak,Bk);
		q=TopPred2D::topPred(uA,Bk);
		r=TopPred2D::topPred(Ak,uB);
		s=TopPred2D::topPred(uA,uB);
	}
	
	trival VTP2D::Disjoint( bool mkk[9],  bool mAk[9],
								   bool mkB[9],  bool mAB[9])
	{
		if (!mAB[II] && !mAB[IB] && !mAB[BI] && !mAB[BB])
			return VTRUE;
		else if (mkk[II] && mkk[IB] && mkk[BI] && mkk[BB])
			return VFALSE;
		else
			return VMAYBE;
	}
	
	
	trival VTP2D::Overlap( bool mkk[9],  bool mAk[9],
								  bool mkB[9],  bool mAB[9])
	{
		if (mkk[II] && mkB[IE] && mAk[EI])
			return VTRUE;
		else if (!mAB[IE] || !mAB[II] || !mAB[EI])
			return VFALSE;
		else
			return VMAYBE;	
	}
	
	trival VTP2D::Meet( bool mkk[9],  bool mAk[9],
							   bool mkB[9],  bool mAB[9])
	{
		if ((mkk[BB] || mkk[BI]) && !mAB[II])
			return VTRUE;
		else if (mkk[II] || (!mkB[II] && !mAk[II]) && mAB[II] && mAB[BE] && mAB[EB])
			return VFALSE;
		else
			return VMAYBE;	
	
	}

	trival VTP2D::Equal( bool mkk[9],  bool mAk[9],
								bool mkB[9],  bool mAB[9])
	{
		if (!mkk[IB] && !mkk[IE] && !mkk[BI] && !mkk[BE] && !mkk[EB] && !mkk[EI] &&
		   !mkB[IB] && !mkB[IE] && !mkB[BI] && !mkB[BE] && !mkB[EB] && !mkB[EI] &&
			!mAk[IB] && !mAk[IE] && !mAk[BI] && !mAk[BE] && !mAk[EB] && !mAk[EI] &&
			!mAB[IB] && !mAB[IE] && !mAB[BI] && !mAB[BE] && !mAB[EB] && !mAB[EI])
			return VTRUE;
		else if (mkB[BE] || mkB[EI])
			return VFALSE;
		else
			return VMAYBE;	
	
	}

	trival VTP2D::CoveredBy( bool mkk[9],  bool mAk[9],
									bool mkB[9],  bool mAB[9])
	{
		if (mAk[II] && mAk[BI] && !mAk[IE] && !mAk[BE] && !mAk[IB] && mkk[BB])
			return VTRUE;
		else if (mkB[IE] || Inside(mkk,mkB,mAk,mAB)==VTRUE)
			return VFALSE;
		else
			return VMAYBE;	
	
	}

	trival VTP2D::Inside( bool mkk[9],  bool mAk[9],
								 bool mkB[9],  bool mAB[9])
	{
		if (mAk[II] && !mAk[IE] && !mAk[BE] && !mAk[IB] && !mAk[BB])
			return VTRUE;
		else if (mkB[IE] || mkB[BB])
			return VFALSE;
		else
			return VMAYBE;	
	
	}

