#ifndef VECTORBINARYSEARCHWRAPPER_H
#define VECTORBINARYSEARCHWRAPPER_H


#include <iostream>
#include <stdexcept>
namespace stu
{
	using namespace stu;
	using namespace std;
	// takes any container with size(), ==, and < overloaded
	
	// T is the vector, S is the vector type
	template <class T, class S>
	class vectorBinarySearchWrapper
	{
		private:
			T *theVector;
			bool privateFind( const S &item, uint min, uint max, uint curr, uint &index );
		public:
			vectorBinarySearchWrapper( T* thevec );
			// returns index of item and true if item is found.
			// if item not found, returns false and the index where the item
			// should be inserted into the vector.
			bool find( const S &item, uint &index );
	};

	template <class T, class S>
	vectorBinarySearchWrapper<T, S>::vectorBinarySearchWrapper( T* thevec ): theVector( thevec )
	{    }

	template <class T, class S>
	bool vectorBinarySearchWrapper<T, S>::find( const S &item, uint &index )
	{
		if( theVector->size() == 0 ){ index = 0; return false; }
		uint max = theVector->size( )-1;
		return privateFind( item, 0, max, max/2, index );
	}

	template <class T, class S>
	bool vectorBinarySearchWrapper<T, S>::privateFind( const S &item, uint min, uint max, uint curr, uint &index )
	{
		while( true )
		{
			//cerr<<"search: min:"<<min<<", max:"<<max<<", curr:"<<curr<<" item: "<<item<<endl;
			//cerr<<"search: min:"<<min<<", max:"<<max<<", curr:"<<curr<<endl;
			// first check if we have zeroed in on a single cell
			if( min == max )
			{
				if( item == (*theVector)[curr] )
				{
					index = min;
					return true;
				} 
				else  if( item < (*theVector)[curr] )
				{
					//cerr << "In the middle*************************" << endl;
					index = min;
					return false;
				}
				else
				{
					//cerr << "******************in the bottom" << endl;
					// if the new value is bigger than the biggest value in the vector	
					index = curr+1;
					return false;
				}
			}
			
			// now do the general case
			
			if( item == (*theVector)[curr] )
			{
				index = curr;
				return true;
			}
			else if( item < (*theVector)[curr] )
			{
				uint newCurr = ((curr-min)/2)+min;
				if( newCurr == curr && newCurr > min ) newCurr--;
				max = curr;
				curr = newCurr;
				continue;
			}
			else
			{
				uint newCurr = ((max-curr)/2)+curr;
				if( newCurr == curr && newCurr < max ) newCurr++;
				// case if the item does not exist in the vector
				// at this point, we knoiw we are greater than vector[curr]...
				// so if we are less than vector[newCurr], item not in vector.
				if( newCurr < curr ) throw runtime_error("error in bin search");
				if( newCurr-curr == 1 && item < (*theVector)[newCurr] )
				{
					index = newCurr;
					return false;
				}
				min = curr;
				curr = newCurr;
				continue;
			}
			
		}
		return false;
	}
}
#endif
