/**************************
John O'Rourke
ISTUDY - schneider
vector.h
*************************/

#ifndef STUVECTOR_H
#define STUVECTOR_H

#include <cstdlib>
#include <iostream>
#include <typeinfo>
//#include "user_types.h"


namespace stu{
	using namespace stu;

	template <class itemType>
	class stuVector
	{
	public:
	
	// constructors/destructor
		stuVector( );                 
		stuVector( int size );     //size of vector
		stuVector( int size, const itemType & fillValue ); // set size and value of each element
		stuVector( itemType* values, uint size); //constructor provides primitive array and its size
		stuVector( const stuVector & vec );     // copy constructor
		~stuVector( );                       // destructor
	
	// operator overloads
		bool operator==( const stuVector & vec );
		const stuVector & operator = ( const stuVector & vec );
		itemType & operator [ ] ( int index ) const;   // indexing with range checking
	
	// member functions
		uint  length( ) const;                   // capacity of vector
		void resize( int newSize );             // change size dynamically;
		void resize( int newSize, const itemType & fillValue);// change size dynamically, fill new spots with fillValue

		void push_back(const itemType & newValue);
		void add_front(const itemType & newValue);
		void insert(uint idx, const itemType & newValue);
	
	private:
		uint  size;                            // number of elements
		itemType * list;                      // array 
	};
	template <class itemType>
			stuVector<itemType>::stuVector()
	: size(0), list(0)
	{
	//empty default constructor
	}
	
	template <class itemType>
			stuVector<itemType>::stuVector(int aSize)
	: size(aSize), list(new itemType[aSize])
	{
	/// initiializes the size of the stuVector
	}
	
	template <class itemType>
			stuVector<itemType>::stuVector(int aSize, const itemType & fillValue)
	: size(aSize), list(new itemType[aSize])
	{
	///sets the initial values for the elements in the arrays
		for(int k = 0; k < aSize; k++)
		{
			list[k] = fillValue;
		}
	}
	
	template <class itemType>
			stuVector<itemType>::stuVector(const stuVector & vec)
	: size(vec.length()), list(new itemType[vec.length()])
	{  
		memcpy(list,vec.list,vec.length() * sizeof(itemType));
	}
	
	template <class itemType>
			stuVector<itemType>::stuVector(itemType* values, uint s  )
	: size(s), list(values)  //does not copy values, just references existing array.
	{  /*** Mark switched the order of size and list in the initialization list 10/26/2006 ***/
/*		list=new itemType[s];
		for (uint i=0; i<s; i++)
			list[i]=values[i];
		size=s;*/
	}
	
	
	template <class itemType>
			bool stuVector<itemType>::operator==( const stuVector & vec )
	{
		for (uint i=0; i<size; i++)
			if ((*this)[i]!=vec[i])
				return false;
		return true;
	}	
	
	template <class itemType>
			const stuVector<itemType> &
			stuVector<itemType>::operator = (const stuVector<itemType> & rhs)
	{
		if (this != &rhs)                         // don't assign to self!
		{
			delete [] list;                       // get rid of old storage
			size = rhs.length();
			list = new itemType [size];         // allocate new storage
			memcpy(list,rhs.list,rhs.length() * sizeof(itemType));
		}
		return *this;                             // permit a = b = c = d
	}
	
	template <class itemType>
			uint stuVector<itemType>::length() const
	{
	///returns the length
		return size;
	}
	
	template <class itemType>
			itemType & stuVector<itemType>::operator [] (int k) const
	{
		if (k < 0 || static_cast<long long int>(size) <= k) /*** Mark added static cast on 10/26/2006 ***/
		{
			std::cerr << "Illegal stuVector index: " << k << " max index = "
					<< size-1 << std::endl;;
			abort();
		}
		return list[k];
	}
	
	template <class itemType>
			void stuVector<itemType>::resize(int newSize)
	{
		int numToCopy = newSize < static_cast<long long int>(size) ? newSize : size; /*** Mark added static cast  on 10/26/2006 ***/
	
	// allocate new storage and copy element into new storage
	
		itemType * newList = new itemType[newSize];
	//memcpy(newList,list,numToCopy * sizeof(itemType));
		for (int i=0; i<numToCopy; i++)
			newList[i]=list[i];
	
		delete [] list;                         // de-allocate old storage
		size = newSize;                         // assign new storage/size
		list = newList;
	}
	
	template <class itemType>
			void stuVector<itemType>::resize(int newSize, const itemType & fillValue)
	{
		int numToCopy = newSize < static_cast<long long int>( size ) ? newSize : size; /*** Mark added static cast  on 10/26/2006 ***/
	
	// allocate new storage and copy element into new storage
	
		itemType * newList = new itemType[newSize];
	//memcpy(newList,list,numToCopy * sizeof(itemType));
		for (int i=0; i<numToCopy; i++)
			newList[i]=list[i];
	
		for (int i=numToCopy; i<newSize; i++)
			newList[i]=fillValue;
		
		delete [] list;                         // de-allocate old storage
		size = newSize;                         // assign new storage/size
		list = newList;
	}
	
	template <class itemType>
			void stuVector<itemType>::push_back(const itemType & newValue)
	{
			this->resize(size+1);
			(*this)[size-1]=newValue;
	}

	template <class itemType>
			void stuVector<itemType>::add_front(const itemType & newValue)
	{
		this->insert(0,newValue);
	}
	
	template <class itemType>
			void stuVector<itemType>::insert(uint idx, const itemType & newValue)
	{
		this->resize(size+1);
		for (uint i=this->size-1; i>idx; i--)
			(*this)[i]=(*this)[i-1];
			
		(*this)[idx]=newValue;
	}
	
	template <class itemType>
			stuVector<itemType>::~stuVector ()
	{
	//destructor
		delete []list;
	}
}
#endif






