/*****************************************************
* Class rationalImpl                                     *
*                                                    *
* Implements a class of rationalImpl numbers with all    *
* arithmentic operations based on arbitrarily        *
* long integer representation                        *     
*****************************************************/

#ifndef RATIONALIMPL_H
#define RATIONALIMPL_H
#include "integer.h"
#include "zerodenominatorexception.h"

namespace stu{
	using namespace stu;
	using namespace std;

	class rationalImpl{
	public:
		// Standard constructors
		rationalImpl(); // default constructor initializing to zero
		rationalImpl(const rationalImpl &arg); // copy constructor
		rationalImpl(const integer &_num, const integer &_den) throw( ZeroDenominatorException ); // utility constructor
		rationalImpl(unsigned char* data, uint size); //deserializing constructor
		void print(); ///for debugging
		
		//actual definition allows us to by-pass user defined types
		
		rationalImpl(signed char nschar, signed char dschar=1) throw( ZeroDenominatorException );
		rationalImpl(unsigned char nuchar, unsigned char duchar=1) throw( ZeroDenominatorException );
		rationalImpl(signed short int nssint, signed short int dssint=1) throw( ZeroDenominatorException );
		rationalImpl(unsigned short int nusint, unsigned short int dusint=1) throw( ZeroDenominatorException );
		rationalImpl(signed int nsint, signed int dsint=1) throw( ZeroDenominatorException );
		rationalImpl(unsigned int nuint, unsigned int duint=1) throw( ZeroDenominatorException );
		rationalImpl(signed long nslong, signed long dslong=1) throw( ZeroDenominatorException );
		rationalImpl(unsigned long nulong, unsigned long dulong=1) throw( ZeroDenominatorException );
		rationalImpl(float ntheFloat, float dtheFloat=1) throw( ZeroDenominatorException );
		rationalImpl(double ntheDouble, double dtheDouble=1) throw( ZeroDenominatorException );
		rationalImpl(const string &nstr, const string &dstr="1") throw( ZeroDenominatorException );
		
		// Assignment operators
		
		rationalImpl& operator = (const rationalImpl &rhs);
		
		// Arithmetic operators '+', '-', '*', '/', '%', '^'
		
		rationalImpl operator + (const rationalImpl &rhs) const; 
		rationalImpl operator - (const rationalImpl &rhs) const;
		rationalImpl operator * (const rationalImpl &rhs) const;  
		rationalImpl operator / (const rationalImpl &rhs) const throw (DivisionByZeroException);
		rationalImpl operator ^ (const integer &rhs) const;
		
		// Arithmetic assignment operators '+=', '-=', '*=', '/='
		
		rationalImpl &operator += (const rationalImpl &rhs);
		rationalImpl &operator -= (const rationalImpl &rhs);
		rationalImpl &operator *= (const rationalImpl &rhs);
		rationalImpl &operator /= (const rationalImpl &rhs) throw (DivisionByZeroException);
				
		// Unary operators '+', '-'
		
		rationalImpl operator + () const;
		rationalImpl operator - () const;
		
		// Increment/decrement operators '++', '--'
		
		rationalImpl& operator ++ ();    // prefix
		rationalImpl operator ++ (int); // postfix
		rationalImpl& operator -- ();    // prefix
		rationalImpl operator -- (int); // postfix
		
		// Comparison operators
		
		bool operator == (const rationalImpl &rhs) const;
		bool operator != (const rationalImpl &rhs) const;
		bool operator >  (const rationalImpl &rhs) const;
		bool operator <  (const rationalImpl &rhs) const;
		bool operator >= (const rationalImpl &rhs) const;
		bool operator <= (const rationalImpl &rhs) const;
			
		// Other functions
		
		rationalImpl abs() const; // absolute value
		rationalImpl neg() const; // negate value
		rationalImpl sqrt() const; // approximate square root (newton's iteration)
		
		// Trigonometric functions
		rationalImpl sin() const; // approximate sinus (newton's iteration)
		rationalImpl cos() const; // approximate cosinus (newton's iteration)
		rationalImpl tan() const throw (DivisionByZeroException); // approximate tangent (newton's iteration)
		rationalImpl cot() const throw (DivisionByZeroException); // approximate cotangent (newton's iteration)
		
		// Stream input/output operators
		integer toInteger() const; //returns floor integer
		double toDouble() const; //returns approximate double

		friend istream &operator >> (istream &istr, rationalImpl &rhs);
		friend ostream &operator << (ostream &ostr, const rationalImpl &rhs);
		
		//serializer
		uint serialize(unsigned char* data) const;
		uint serialSize() const; //returns number of bytes this object takes when serialized
			
	private:
		integer num; //numerator
		integer den; //denominator
		void reduce(); //numbers should always be kept completely factorized
	};
}
#endif // RATIONAL_H
