/******************************************************
* Class rationalImpl                                      *
*                                                     *
* Implements a class of rationalImpl numbers              *
* First version started September, 2004               *
* Authors:  Alejandro Pauly                           *
*           Brian E. Weinrich                         *
*                                                     *
*******************************************************/

#include <cstdlib>
#include <string>
#include <iostream>
#include <sstream>
#include <cmath>
#include "rationalImpl.h"
#include "float.h"

namespace stu{
	using namespace stu;
	using namespace std;

	/* macro used for debugging, first line should be commented out
	* when in production */
	//#define debug(x) cout << x << endl;
	#ifndef debug
	#define debug(x)
	#endif
	
	//utility macros
	#define max(x,y) (x>y?x:y)
	
	void rationalImpl::reduce(){
		integer gcd=num.gcd(den);
		num=num/gcd;
		den=den/gcd;
	}
	
	
	//standard constructors
	
	rationalImpl::rationalImpl():num(0),den(1){}
	
	
	/*copy constructor, deeps copy, no shared data*/
	rationalImpl::rationalImpl(const rationalImpl&arg):num(arg.num),den(arg.den){}
	
	//deserializing constructor
	rationalImpl::rationalImpl(unsigned char* data, uint size)://unserializes buffer into a rat
		num(data+sizeof(uint),*((uint*)data)), 
		den(data+sizeof(uint)+(*((uint*)data)),size-((*((uint*)data))+sizeof(uint)))
	{	
// 		cout << "Start of num: " << sizeof(uint) << endl;
// 		cout << "Length of num: " << *((uint*)data) << endl;
// 		cout << "Start of den: " << (sizeof(uint)+(*((uint*)data))) << endl;
// 		cout << "Length of den: " << (size-((*((uint*)data))+sizeof(uint))) << endl;
	}
	
	// utility constructor
	rationalImpl::rationalImpl(const integer &_num, const integer &_den) throw( ZeroDenominatorException )
		//:num(_num),den(_den)
			{ 
				if (_den==integer(0))  throw ZeroDenominatorException(); 
				
				if (_den<integer(0)) { //we either want -1/x or 1/x but no 1/-x
						num=_num.neg();
						den=_den.neg();
					}else{
						num=_num;
						den=_den;	
					}
			}
	
	/*prints directly to standard output, same as cout << rationalImpl*/
	void rationalImpl::print()
	{ cout << num << "/" << den;}
	
	rationalImpl::rationalImpl(signed char nschar, signed char dschar) throw( ZeroDenominatorException )
	//	:num(nschar),den(dschar)
			{ 
				if (dschar==0)  throw ZeroDenominatorException(); 
				
				if (dschar<0) { //we either want -1/x or 1/x but no 1/-x
						num=integer(nschar*-1);
						den=integer(dschar*-1);
					}else{
						num=integer(nschar);
						den=integer(dschar);
					}
			}
	
	rationalImpl::rationalImpl(unsigned char nuchar, unsigned char duchar) throw( ZeroDenominatorException )
		:num(nuchar),den(duchar){ if (duchar==0)  throw ZeroDenominatorException(); }
	
	rationalImpl::rationalImpl(signed short int nssint, signed short int dssint) throw( ZeroDenominatorException )
		//:num(nssint),den(dssint)
			{ 
				if (dssint==0)  throw ZeroDenominatorException(); 
				
				if (dssint<0) { //we either want -1/x or 1/x but no 1/-x
						num=integer(nssint*-1);
						den=integer(dssint*-1);
					}else{
						num=integer(nssint);
						den=integer(dssint);
					}
			}
	
	rationalImpl::rationalImpl(unsigned short int nusint, unsigned short int dusint) throw( ZeroDenominatorException )
		:num(nusint),den(dusint){ if (dusint==0)  throw ZeroDenominatorException(); }
	
	rationalImpl::rationalImpl(signed int nsint, signed int dsint) throw( ZeroDenominatorException )
		//:num(nsint),den(dsint)
			{ 
				if (dsint==0)  throw ZeroDenominatorException();
				
				if (dsint<0) { //we either want -1/x or 1/x but no 1/-x
						num=integer(nsint*-1);
						den=integer(dsint*-1);
					}else{
						num=integer(nsint);
						den=integer(dsint);
					}			
			}
	
	rationalImpl::rationalImpl(unsigned int nuint, unsigned int duint) throw( ZeroDenominatorException )
		:num(nuint),den(duint){ if (duint==0)  throw ZeroDenominatorException(); }
	
	rationalImpl::rationalImpl(signed long nslong, signed long dslong) throw( ZeroDenominatorException )
		//:num(nslong),den(dslong)
			{ 
				if (dslong==0)  throw ZeroDenominatorException(); 
	
				if (dslong<0) { //we either want -1/x or 1/x but no 1/-x
						num=integer(nslong*-1);
						den=integer(dslong*-1);
					}else{
						num=integer(nslong);
						den=integer(dslong);
					}		
			}
	
	rationalImpl::rationalImpl(unsigned long nulong, unsigned long dulong) throw( ZeroDenominatorException )
		:num(nulong),den(dulong){ if (dulong==0)  throw ZeroDenominatorException(); }
	
	rationalImpl::rationalImpl(float ntheFloat, float dtheFloat) throw( ZeroDenominatorException ){
	
		
		if (dtheFloat==0)  throw ZeroDenominatorException(); 
	
			if (dtheFloat<0) { //we either want -1/x or 1/x but no 1/-x
					dtheFloat*=-1;
					ntheFloat*=-1;
			}

		stringstream numer;
		stringstream denom;
		
		numer.precision(10);
		denom.precision(10);
		
		numer << ntheFloat;
		denom << dtheFloat;
		
		string strn=numer.str();
		string strd=denom.str();

		//find decimal points
		string::size_type numpos=strn.find(".",0);
		string::size_type denpos=strd.find(".",0);

		uint nummult=0;
		uint denmult=0;

		//now delete the points
		if (numpos!=/*static_cast<long long int>*/(string::npos)){ 
			nummult=(uint)pow((float)10,(float)(strn.size()-numpos-1));
			strn.erase(numpos,1); 
		}
		if (denpos!=/*static_cast<long long int>*/(string::npos)){ 
			denmult=(uint)pow((float)10,(float)(strd.size()-denpos-1));
			strd.erase(denpos,1); 
		}

		if (nummult>denmult){
			denmult/=nummult;
			if (denmult==0) denmult=nummult;
			nummult=1;
		}
		else if (nummult<denmult){
			nummult/=denmult;
			if (nummult==0) nummult=denmult;
			denmult=1;
		}
		else{
			nummult=1;
			denmult=1;
		}
		
		integer ntemp(strn);
		integer dtemp(strd);

		num=ntemp*integer(nummult);
		den=dtemp*integer(denmult);
	}
	
	rationalImpl::rationalImpl(double ntheDouble, double dtheDouble) throw( ZeroDenominatorException ){
		
		if (dtheDouble==0)  throw ZeroDenominatorException(); 
	
			if (dtheDouble<0) { //we either want -1/x or 1/x but no 1/-x
					dtheDouble*=-1;
					ntheDouble*=-1;
			}
	


		stringstream numer;
		stringstream denom;
		
		numer.precision(10);
		denom.precision(10);
		
		numer << ntheDouble;
		denom << dtheDouble;
		
		string strn=numer.str();
		string strd=denom.str();

		//find decimal points
		string::size_type numpos=strn.find(".",0);
		string::size_type denpos=strd.find(".",0);

		uint nummult=0;
		uint denmult=0;

		//now delete the points
		if (numpos!=/*static_cast<long long int>*/(string::npos)){ 
			nummult=(uint)pow((double)10,(double)(strn.size()-numpos-1));
			strn.erase(numpos,1); 
		}
		if (denpos!=/*static_cast<long long int>*/(string::npos)){ 
			denmult=(uint)pow((double)10,(double)(strd.size()-denpos-1));
			strd.erase(denpos,1); 
		}

		if (nummult>denmult){
			denmult/=nummult;
			if (denmult==0) denmult=nummult;
			nummult=1;
		}
		else if (nummult<denmult){
			nummult/=denmult;
			if (nummult==0) nummult=denmult;
			denmult=1;
		}
		else{
			nummult=1;
			denmult=1;
		}
		
		integer ntemp(strn);
		integer dtemp(strd);

		num=ntemp*integer(nummult);
		den=dtemp*integer(denmult);
	}
	
	rationalImpl::rationalImpl(const string &nstr, const string &dstr) throw( ZeroDenominatorException )
		:num(nstr),den(dstr)
			{ 
				if (den==integer(0))  throw ZeroDenominatorException(); 
				
				if (den<integer(0)) { //we either want -1/x or 1/x but no 1/-x
						num=num.neg();
						den=den.neg();
					}
			}			
	
	// Assignment Operators
	/* assignment makes a deep copy, no shared data left */
	rationalImpl& rationalImpl::operator = (const rationalImpl &rhs)
	{
		if (this!=&rhs) {     
			num=rhs.num;
			den=rhs.den;
		}
		return *this;
	}
	
	// Arithmetic operators '+', '-', '*', '/', '%', '^'
	rationalImpl rationalImpl::operator + (const rationalImpl &rhs) const
	/**********************LOG**************************
	
	Purpose:  Addition operator
	
	Created by:  Brian E. Weinrich - October 16, 23, 29, 30, 2004
	Modified by: Alejandro Pauly - February 15, 2005
	****************************************************/ 
	{
	integer tempnumera;
	integer tempdenom;
	tempnumera = num*rhs.den + rhs.num*den;   
	tempdenom = den*rhs.den;
	rationalImpl sumrec(tempnumera,tempdenom);
	sumrec.reduce();
	return sumrec;
	} // Overload binary +
	
	
	rationalImpl rationalImpl::operator - (const rationalImpl &rhs) const
	/**********************LOG**************************
	
	Purpose:  Subtraction operator
	
	Created by:  Brian E. Weinrich - October 16, 23, 29, 30, 2004
	Modified by: Alejandro Pauly - February 15, 2005
	****************************************************/ 
	{
	integer tempnumera;
	integer tempdenom;
	
	tempnumera = num*rhs.den - rhs.num*den;
	tempdenom = den*rhs.den;
	rationalImpl differrec(tempnumera,tempdenom);
	differrec.reduce();
	return differrec;
	} // Overload binary -
	
	rationalImpl rationalImpl::operator * (const rationalImpl &rhs) const
	/**********************LOG**************************
	
	Purpose:  Multiplication operator
	
	Created by:  Brian E. Weinrich - October 16, 23, 30, 2004
	Modified by: Alejandro Pauly - February 15, 2005
	****************************************************/ 
	{
	integer tempnumera;
	integer tempdenom;
	tempnumera = num*rhs.num;   
	tempdenom = den*rhs.den;
	rationalImpl prodrec(tempnumera,tempdenom);
	prodrec.reduce();
	return prodrec;
	} // Overload *
	
	rationalImpl rationalImpl::operator / (const rationalImpl &rhs) const throw (DivisionByZeroException)
	/**********************LOG**************************
	
	Purpose:  Division operator
	
	Created by:  Brian E. Weinrich - October 16, 23, 30, 2004
	Modified by: Alejandro Pauly - February 15, 2005
	Alejandro Pauly - November 29, 2005 (Added DivisionByZeroException)
	****************************************************/ 
	{
	integer tempnumera;
	integer tempdenom;
	rationalImpl zero(0);
	if (rhs==zero)
		throw DivisionByZeroException();
	
	tempnumera = num*rhs.den;
	tempdenom = den*rhs.num;
	rationalImpl quotrec(tempnumera,tempdenom);
	quotrec.reduce();
	return quotrec;
	} // Overload /
	
	/**********************LOG**************************
	
	Purpose:  Exponentiation operator (assumes integer exponent)
	
	Created by:  Brian E. Weinrich - October 23, 30, 2004
	Modified by: Alejandro Pauly - February 15, 2005
	****************************************************/ 
	rationalImpl rationalImpl:: operator ^ (const integer &rhs) const
	{
	integer tempnumera;
	integer tempdenom;
	integer zero(0);
	//
	//  Invert numerator and denominator when exponent is negative.
	//
	if (rhs >= zero) {
		tempnumera = num^rhs;
		tempdenom = den^rhs;
	} // if
	else {
		tempnumera = den^(-rhs);
		tempdenom = num^(-rhs);
	} // else
	//
	//  Instantiate and return exponentiated result.
	//
	rationalImpl exponrec(tempnumera,tempdenom);
	return exponrec;
	} // Overload ^
	
	// Arithmetic assignment operators '+=', '-=', '*=', '/='
	rationalImpl& rationalImpl::operator += (const rationalImpl &rhs)
	{
	/**********************LOG**************************
	
	Purpose: in place addition operator
	
	Created by:  Alejandro Pauly - October 15, 2004
	****************************************************/ 
	(*this)=(*this) + rhs;
	return *this;   
	}
	
	rationalImpl& rationalImpl::operator -= (const rationalImpl &rhs)
	{  
	/**********************LOG**************************
	
	Purpose: in place subtraction operator
	
	Created by:  Alejandro Pauly - October 15, 2004
	****************************************************/ 
	(*this)=(*this) - rhs;
	return *this;   
	}
	
	rationalImpl& rationalImpl::operator *= (const rationalImpl &rhs)
	{
	/**********************LOG**************************
	
	Purpose: in place multiplication operator
	
	Created by:  Alejandro Pauly - October 15, 2004
	****************************************************/ 
	(*this)=(*this) * rhs;
	return *this;   
	}
	
	rationalImpl& rationalImpl::operator /= (const rationalImpl &rhs) throw (DivisionByZeroException)
	{
	/**********************LOG**************************
	
	Purpose: in place division operator
	
	Created by:  Alejandro Pauly - October 15, 2004
	Alejandro Pauly - November 29, 2005 (Added DivisionByZeroException)
	****************************************************/ 
	(*this)=(*this) / rhs;
	return *this;   
	}
	
	// Unary operators '+', '-'
	
	rationalImpl rationalImpl::operator + () const
	{
	/**********************LOG**************************
	
	Purpose: unary plus operator, no change to actual representation
	
	Created by:  Alejandro Pauly - October 15, 2004
	****************************************************/ 
	return (*this);
	}
	
	rationalImpl rationalImpl::operator - () const
	{
	/**********************LOG**************************
	
	Purpose: unary minus, returns negative representation without making changes 
	
	Created by:  Alejandro Pauly - October 15, 2004
	****************************************************/ 
	return (*this).neg();
	}
	
	// Increment/decrement operators '++', '--'
	rationalImpl& rationalImpl::operator ++()
	{
	/**********************LOG**************************
	
	Purpose: prefix increment
	
	Created by:  Alejandro Pauly - October 15, 2004
	****************************************************/ 
	rationalImpl one(1,1);
	(*this)=(*this) + one;
	return (*this);
	} // prefix
	
	rationalImpl rationalImpl::operator ++(int)
	{
	/**********************LOG**************************
	
	Purpose: postfix increment
	
	Created by:  Alejandro Pauly - October 15, 2004
	****************************************************/   
	rationalImpl temp(num,den);
	rationalImpl one(1,1);
	(*this)=(*this) + one;
	return temp;
	} // postfix
	
	rationalImpl& rationalImpl::operator --()
	{
	/**********************LOG**************************
	
	Purpose: prefix decrement
	
	Created by:  Alejandro Pauly - October 15, 2004
	****************************************************/ 
	rationalImpl one(1,1);
	(*this)=(*this) - one;
	return (*this);
	} // prefix
	
	rationalImpl rationalImpl::operator -- (int)
	{
	/**********************LOG**************************
	
	Purpose: postfix decrement
	
	Created by:  Alejandro Pauly - October 15, 2004
	****************************************************/ 
	rationalImpl temp(num,den);
	rationalImpl one(1,1);
	(*this)=(*this) - one;
	return temp;
	} // postfix
	
	// Comparison operators
	/* Basic idea of comparison operators is to find first distinction *
	* between operands and analyze the distinction to determine the   *
	* what result it should yield                                     */
	bool rationalImpl::operator == (const rationalImpl &rhs) const
	{
	/**********************LOG**************************
	
	Purpose: equality comparison boolean operator
	
	Created by:  Alejandro Pauly - October 13, 2004
	****************************************************/ 
	integer temp(0);
	integer zero(0);
	if (den==rhs.den){
		if (num==rhs.num)
			return true;
		else
			return false;
	}
	else{
		temp=((num*rhs.den)-(den*rhs.num));
		if (temp==zero)
			return true;
		else
			return false;
	}
	}
	
	bool rationalImpl::operator != (const rationalImpl &rhs) const
	{
	/**********************LOG**************************
	
	Purpose: inequality comparison boolean operator
	
	Created by:  Alejandro Pauly - October 13, 2004
	****************************************************/ 
	integer temp(0);
	integer zero(0);
	if (den==rhs.den){
		if (num!=rhs.num)
			return true;
		else
			return false;
	}
	else{
		temp=(num*rhs.den)-(den*rhs.num);
		if (temp!=zero)
			return true;
		else
			return false;
	}
	}
	
	bool rationalImpl::operator > (const rationalImpl &rhs) const
	{
	/**********************LOG**************************
	
	Purpose: greater than comparison boolean operator
	
	Created by:  Alejandro Pauly - October 13, 2004
	****************************************************/ 
	integer temp(0);
	integer zero(0);
	if (den==rhs.den){
		if (num>rhs.num)
			return true;
		else
			return false;
	}
	else{
		temp=(num*rhs.den)-(den*rhs.num);
		if (temp>zero)
			return true;
		else
			return false;
	}
	}
	
	bool rationalImpl::operator < (const rationalImpl &rhs) const
	{
	/**********************LOG**************************
	
	Purpose: less than comparison boolean operator
	
	Created by:  Alejandro Pauly - October 13, 2004
	****************************************************/ 
	integer temp(0);
	integer zero(0);
	if (den==rhs.den){
		if (num<rhs.num)
			return true;
		else
			return false;
	}
	else{
		temp=(num*rhs.den)-(den*rhs.num);
		if (temp<zero)
			return true;
		else
			return false;
	}
	}
	
	bool rationalImpl::operator >= (const rationalImpl &rhs) const
	{
	/**********************LOG**************************
	
	Purpose: greater or equal than comparison boolean operator
	
	Created by:  Alejandro Pauly - October 13, 2004
	****************************************************/ 
	
	integer temp(0);
	integer zero(0);
	if (den==rhs.den){
		if (num>=rhs.num)
			return true;
		else
			return false;
	}
	else{
		temp=(num*rhs.den)-(den*rhs.num);
		if (temp>=zero)
			return true;
		else
			return false;
	}
	}
	
	bool rationalImpl::operator <=(const rationalImpl &rhs) const
	{
	/**********************LOG**************************
	
	Purpose: less or equal than comparison boolean operator
	
	Created by:  Alejandro Pauly - October 13, 2004
	****************************************************/ 
	integer temp(0);
	integer zero(0);
	if (den==rhs.den){
		if (num<=rhs.num)
			return true;
		else
			return false;
	}
	else{
		temp=(num*rhs.den)-(den*rhs.num);
		if (temp<=zero)
			return true;
		else
			return false;
	}
	}
	
	// Stream input/output operators
	integer rationalImpl::toInteger() const //returns floor integer
	{
		integer t=num/den;
		return t;
	}

	double rationalImpl::toDouble() const{ //returns approximate double
		unsigned long maxint=ULONG_MAX;
		unsigned long numl,denl;
		integer temp(maxint);
		integer ten(10);
		
		const_cast<rationalImpl*>(this)->reduce(); //make sure the number is factorized
		
		integer tnum=num;
		integer tden=den;
		
		while (tnum>temp && tden>temp){ //keep reducing
			tnum/=ten;
			tden/=ten;
		}
		
		numl=tnum.asULong();	
		denl=tden.asULong();	
		double ratdbl=(double)numl/(double)denl; //be as precise as possible
		if( (num < 0 && den >= 0) || (num >=0 && den < 0) )
		{ 
			ratdbl *= -1; 
		}
	return ratdbl;
	}
	
	istream& operator >> (istream &istr, rationalImpl &rhs)
	{
	/**********************LOG**************************
	
	Purpose: input operator for istream objects
	
	Created by:  Alejandro Pauly - October 16, 2004
	****************************************************/ 
	char c=' ';
	bool first=true;
	bool numerator=true;
	string temp="";
	string num="",den="";
	do {
		istr.get(c);
		if (c!='\n'){
			if (c=='0' || c=='1' || c=='2' || c=='3' || c=='4' || 
				c=='5' || c=='6' || c=='7' || c=='8' || c=='9' ||
				((c=='-' || c=='+') && first==true)){
				temp=temp + c;
				first=false;
			} // if
			else if (c=='/' && numerator){ //finished with numerator
				numerator=false; //done
				num=temp;
				temp="";
				first=true; //now start accepting denominator   
			}
			else {
				cout << "ERROR: Invalid Input:" << c << ":" << endl;
				exit(0);
			} // else
		} // if
	} while (c!='\n');
	if (!numerator)
		den=temp;
	else { //assume den=1
		if (temp=="") 
			num="0";
		else
			num=temp;
		den="1";
	}
	if (num!="" && den!="") rhs=rationalImpl(num,den);
	return istr;
	}         
	
	ostream& operator << (ostream &ostr, const rationalImpl &rhs)
	{
	/**********************LOG**************************
	
	Purpose: output operator for ostream objects
	
	Created by:  Alejandro Pauly - October 13, 2004
	****************************************************/ 
	ostr << rhs.num << "/" << rhs.den;
	return ostr;
	}
	
	rationalImpl rationalImpl::abs() const
	{
	/**********************LOG**************************
	
	Purpose: returns absolute value, no matter sign
	
	Created by:  Alejandro Pauly - October 13, 2004
	****************************************************/ 
	
	rationalImpl absRat(num.abs(),den.abs());
	return absRat;
	} // absolute value
	
	rationalImpl rationalImpl::neg() const
	{
	/**********************LOG**************************
	
	Purpose: same as unary minus
	
	Created by:  Alejandro Pauly - October 13, 2004
	****************************************************/ 
	
	rationalImpl negRat(num.neg(),den);
	return negRat;
	} // negate value
	
	rationalImpl rationalImpl::sqrt() const
	{
		/**********************LOG**************************
		
		Purpose: calculate approximate square root of number. If number is
		small enough to fit into a double precision machine number then convert
		and compute with machine's implementation. Otherwise, if number is too big
		compute sqrt based on newton's iterative method.
		
		Created by:  Alejandro Pauly - March 22, 2005
		Modified: October 12, 2006
		****************************************************/ 
		//uint32 base=(uint32)pow(2.0,BASEEXP);
		unsigned long maxint=ULONG_MAX;
		unsigned long numl,denl;
		integer temp((unsigned long) maxint);
		
//		cout << "Maxint(" << maxint << "): " << temp << "  Num: " << num << " Den: " << den << endl; 
		
		const_cast<rationalImpl*>(this)->reduce(); //make sure the number is factorized
		
		if (this->num<=temp && this->den<=temp){ //then we can convert
			numl=num.asULong();	
			denl=den.asULong();	
			double ratdbl=(double)numl/(double)denl; //be as precise as possible
			rationalImpl result((double)std::sqrt(ratdbl),(double)1);
			//std::cout << "SQRT of " << *this << "(" << ratdbl << "): " << std::sqrt(ratdbl) << "(" << result << ")" << endl; 
			return result;
		}else{
			rationalImpl newx(num,den); //make a copy to initialize
			rationalImpl x(0); 
			rationalImpl tol(0); //saves difference of X-newX
			rationalImpl half(1,2); //0.5, to use in computation
			rationalImpl TOLERANCE("1","100000");
			
			do{
				x=newx;
				newx = half * (x+(*this)/x);
				tol = (x - newx) / newx;
				tol=tol.abs();  
			}
			while(tol>TOLERANCE);
			
			return newx;
		}
	} //end sqrt
	
	rationalImpl rationalImpl::sin() const
	{
		/**********************LOG**************************
		
		Purpose: calculate an approximation of trigonometric sinus function of a rational number
		using power serie and newton's iterative method.
		
		Created by:  Reasey Praing - April 04, 2006
		****************************************************/ 
		rationalImpl newx(num,den); //make a copy to initialize
		rationalImpl x(0); 
		rationalImpl tol(0); //saves difference of X-newX
		rationalImpl TOLERANCE("1","10");
		rationalImpl neg1("-1","1");
		rationalImpl rn(0);
		integer in(0);
		rationalImpl fac(1);
		rationalImpl r1(1);
		rationalImpl r2(2);
		integer i1(1);
		integer i2(2);
		do{
			rn++;
			in++;
			x=newx;
			fac = fac*(r2*rn)*((r2*rn)+r1);
			newx = x + ((neg1^in) *((*this)^((i2*in)+i1)))/fac ;
			tol = (newx - x);
			tol=tol.abs();
		}
		while(tol>TOLERANCE);
		
		return newx;
	} //end sin
	
	rationalImpl rationalImpl::cos() const
	{
		/**********************LOG**************************
		
		Purpose: calculate an approximation of trigonometric cosinus function of a rational number
		using power serie and newton's iterative method.
		
		Created by:  Reasey Praing - April 04, 2006
		****************************************************/ 
		rationalImpl newx(1);
		rationalImpl x(0); 
		rationalImpl tol(0); //saves difference of X-newX
		rationalImpl TOLERANCE("1","10000");
		rationalImpl neg1("-1","1");
		rationalImpl rn(0);
		integer in(0);
		rationalImpl fac(1);
		rationalImpl r1(1);
		rationalImpl r2(2);
		integer i1(1);
		integer i2(2);
		do{
			rn++;
			in++;
			x=newx;
			fac = fac*((r2*rn)-r1)*(r2*rn);
			newx = x + ((neg1^in) *((*this)^(i2*in)))/fac ;
			tol = (newx - x);
			tol=tol.abs();
		}
		while(tol>TOLERANCE);
		
		return newx;
	} //end cos
	
	rationalImpl rationalImpl::tan() const throw (DivisionByZeroException)
	{
		/**********************LOG**************************
		
		Purpose: calculate an approximation of trigonometric tangent function of a rational number
		using power serie and newton's iterative method.
		
		Created by:  Reasey Praing - April 04, 2006
		****************************************************/ 
		rationalImpl zero(0);
		if(this->cos() == zero)
			throw DivisionByZeroException();
		return this->sin()/this->cos();
	} //end tan
	
	rationalImpl rationalImpl::cot() const throw (DivisionByZeroException)
	{
		/**********************LOG**************************
		
		Purpose: calculate an approximation of trigonometric cotangent function of a rational number
		using power serie and newton's iterative method.
		
		Created by:  Reasey Praing - April 04, 2006
		****************************************************/ 
		rationalImpl zero(0);
		if(this->sin() == zero)
			throw DivisionByZeroException();
		return this->cos()/this->sin();
	} //end cot

	uint rationalImpl::serialize(unsigned char* data) const
	{
		unsigned char *buf;
		
		uint lentemp=num.serialSize();
		
		//first store size of x
		buf=(unsigned char *)&lentemp;
		for (uint i=0; i<sizeof(uint); i++)
			data[i]=buf[i];
		
		//then store num
		uint numlen=num.serialize(data+sizeof(uint));
		
		//the store den
		numlen+=den.serialize(data+sizeof(uint)+numlen);
		
		return numlen+sizeof(uint);
	}
	
	uint rationalImpl::serialSize() const
	{
		return (sizeof(uint)+num.serialSize()+den.serialSize());
	}
}
