/*****************************************************
* Class rational                                     *
*                                                    *
* Implements a class of rational numbers with all    *
* arithmentic operations based on arbitrarily        *
* long integer representation                        *     
*****************************************************/

#ifndef RATIONAL_H
#define RATIONAL_H

#include "rationalImpl.h"
#include "zerodenominatorexception.h"

namespace stu{
	using namespace stu;
   using namespace std;

    class rational{
   public:
   // Standard constructors
      rational(); // default constructor initializing to zero
      rational(const rational &arg); // copy constructor
      rational(const rationalImpl &arg); // copy constructor
	  rational(unsigned char* data, uint size); //deserializing constructor
	  void print(); ///for debugging
   
   //actual definition allows us to by-pass user defined types
   
      rational(signed char nschar, signed char dschar=1) throw( ZeroDenominatorException );
      rational(unsigned char nuchar, unsigned char duchar=1) throw( ZeroDenominatorException );
      rational(signed short int nssint, signed short int dssint=1) throw( ZeroDenominatorException );
      rational(unsigned short int nusint, unsigned short int dusint=1) throw( ZeroDenominatorException );
      rational(signed int nsint, signed int dsint=1) throw( ZeroDenominatorException );
      rational(unsigned int nuint, unsigned int duint=1) throw( ZeroDenominatorException );
      rational(signed long nslong, signed long dslong=1) throw( ZeroDenominatorException );
      rational(unsigned long nulong, unsigned long dulong=1) throw( ZeroDenominatorException );
      rational(float ntheFloat, float dtheFloat=1) throw( ZeroDenominatorException );
      rational(double ntheDouble, double dtheDouble=1) throw( ZeroDenominatorException );
      rational(const string &nstr, const string &dstr="1") throw( ZeroDenominatorException );
   
   
   // Assignment operator
      rational& operator = (const rational &rhs);
   
   // Arithmetic operators '+', '-', '*', '/', '%', '^'
   
      rational operator + (const rational &rhs) const; 
      rational operator - (const rational &rhs) const;
      rational operator * (const rational &rhs) const;  
      rational operator / (const rational &rhs) const throw (DivisionByZeroException);
      rational operator ^ (const integer &rhs) const;
   
   // Arithmetic assignment operators '+=', '-=', '*=', '/='
   
      rational &operator += (const rational &rhs);
      rational &operator -= (const rational &rhs);
      rational &operator *= (const rational &rhs);
      rational &operator /= (const rational &rhs) throw (DivisionByZeroException);
        
   // Unary operators '+', '-'
   
      rational operator + () const;
      rational operator - () const;
   
   // Increment/decrement operators '++', '--'
   
      rational& operator ++ ();    // prefix
      rational operator ++ (int); // postfix
      rational& operator -- ();    // prefix
      rational operator -- (int); // postfix
   
   // Comparison operators
   
      bool operator == (const rational &rhs) const;
      bool operator != (const rational &rhs) const;
      bool operator >  (const rational &rhs) const;
      bool operator <  (const rational &rhs) const;
      bool operator >= (const rational &rhs) const;
      bool operator <= (const rational &rhs) const;
    
   // Other functions
   
      rational abs() const; // absolute value
      rational neg() const; // negate value
      rational sqrt() const; //approximate square root
      // Trigonometric functions
      rational sin() const; // approximate sinus (newton's iteration)
      rational cos() const; // approximate cosinus (newton's iteration)
      rational tan() const throw (DivisionByZeroException); // approximate tangent (newton's iteration)
      rational cot() const throw (DivisionByZeroException); // approximate cotangent (newton's iteration)
   
   // Stream input/output operators
	  integer toInteger() const; //returns floor integer
	  double toDouble() const; //returns approximate double
	  
	  friend istream &operator >> (istream &istr, rational &rhs);
      friend ostream &operator << (ostream &ostr, const rational &rhs);
   
	  
	  //serializer
	  uint serialize(unsigned char* data) const;
	  uint serialSize() const; //returns number of bytes this object takes when serialized
	  
   private:
      rationalImpl ri;
   };
}
#endif // RATIONAL_H
