/*****************************************************
* Class integer                                     *
*                                                   *
* Implements a class of "arbitrarily long" integers *
*                                                   *
* Author: Markus Schneider                          *
*                                                   *
*****************************************************/

#ifndef INTEGER_H
#define INTEGER_H

#include <string>
#include <iostream>
#include "integerImpl.h"

namespace stu{
	using namespace stu;
	using namespace std;
	
	
	
	//integer class interface declaration
	
	class integer
	{
	public:
	// Standard constructors
	integer(); // default constructor initializing to zero
	integer(const integer &arg); // copy constructor
	integer(const integerImpl &i); //special constructor needed for internal issues
	integer(unsigned char* data, uint size); //deserializing constructor
	void print(); ///for debugging
	
	//actual definition allows us to by-pass user defined types
	
	integer(signed char schar);
	integer(unsigned char uchar);
	integer(signed short int ssint);
	integer(unsigned short int usint);
	integer(signed int sint);
	integer(unsigned int uint);
	integer(signed long slong);
	integer(unsigned long ulong);
	integer(float theFloat);
	integer(double theDouble);
	integer(const string &str);
	
	// Assignment operators
	integer& operator = (const integer &rhs);
	
	// Arithmetic operators '+', '-', '*', '/', '%', '^'
	
	integer operator + (const integer &rhs) const; 
	integer operator - (const integer &rhs) const;
	integer operator * (const integer &rhs) const;  
	integer operator / (const integer &rhs) const throw (DivisionByZeroException);
	integer operator % (const integer &rhs) const;
	integer operator ^ (const integer &rhs) const;
	
	// Arithmetic assignment operators '+=', '-=', '*=', '/='
	
	integer &operator += (const integer &rhs);
	integer &operator -= (const integer &rhs);
	integer &operator *= (const integer &rhs);
	integer &operator /= (const integer &rhs) throw (DivisionByZeroException);
			
	// Unary operators '+', '-'
	
	integer operator + () const;
	integer operator - () const;
	
	// Increment/decrement operators '++', '--'
	
	integer& operator ++ ();    // prefix
	integer& operator ++ (int); // postfix
	integer& operator -- ();    // prefix
	integer& operator -- (int); // postfix
	
	// Comparison operators
	
	bool operator == (const integer &rhs) const;
	bool operator != (const integer &rhs) const;
	bool operator >  (const integer &rhs) const;
	bool operator <  (const integer &rhs) const;
	bool operator >= (const integer &rhs) const;
	bool operator <= (const integer &rhs) const;
		
	// Other functions
	
	integer gcd(const integer &rhs) const; // greatest common divisor
	integer lcm(const integer &rhs) const; // least common multiple
	integer abs() const; // absolute value
	integer neg() const; // negate value
	
	// Stream input/output operators
	
	friend istream &operator >> (istream &istr, integer	&rhs);
	friend ostream &operator << (ostream &ostr, const integer &rhs);
	
	
	//converter functions
	
		//serializer
	uint serialize(unsigned char* data) const;
	uint serialSize() const; //returns number of bytes this object takes when serialized
	
		//convert integer to an unsigned long (ignore sign)
	unsigned long asULong() const;
	
	private:
	integerImpl impl;
	};
}
#endif // integer_h 
