
/******************************************************
* Class integer                                       *
*                                                     *
* Implements a class of "arbitrarily long" integers   *
* First version finished in July, 2004                *
*                                                     *
* Authors:  Alejandro Pauly, Brian E. Weinrich        *
*                                                     *
*                                                     *
* Modified: 08/14/2004 (AP)                           *
*           Clean up code, wrote a few comments       *
*                                                     *
*           09/06/2004 (AP)                           *
*           -Remove "positive"(sign) property, put as *
*            part of vector in position n             *
*           -fixed unary +,- definitions              *
*                                                     *
*           09/15/2004 (AP)                           *
*           Some documentation done                   *
*                                                     *
*           09/17/2004 (BEW)                          *
*           Extensive documentation and               *
*           reformatting done                         *
*
*            11/29/2005(AP)
*            Added DivisionByZeroException
*
*                                                     *
*******************************************************/

#include <iostream>
#include "integer.h"

namespace stu{
	using namespace stu;
	using namespace std;
	
	/*
	*  Eliminate "most significant" zeros    *
	*  necessary because algorithms can      *
	*  only estimate size of result          *
	*/
	
	/*default constructor, initializes to number 0*/
	integer::integer():impl(){}
	
	/*copy constructor, deeps copy, no shared data*/
	integer::integer(const integer&arg):impl(arg.impl){}
	
	/*copy constructor, deeps copy, no shared data*/
	integer::integer(const integerImpl &i):impl(i){}
	
	//deserializing constructor
	integer::integer(unsigned char* data, uint size):impl(data,size){}
	
	/*prints directly to standard output, same as cout << integer*/
	void integer::print()
	{  impl.print(); } // function print
	
	integer::integer(signed char schar):impl(schar){}
	
	integer::integer(unsigned char uchar):impl(uchar){}
	
	integer::integer(signed short int ssint):impl(ssint){}
	
	integer::integer(unsigned short int usint):impl(usint){}
	
	integer::integer(signed int sint):impl(sint){}
	
	integer::integer(unsigned int uint):impl(uint){}
	
	integer::integer(unsigned long longNumber):impl(longNumber){}
	
	integer::integer(signed long slong):impl(slong){}
	
	integer::integer(float theFloat):impl(theFloat){}
	
	integer::integer(double theDouble):impl(theDouble){}
	
	integer::integer(const string &str):impl(str){}
	
	/* assignment makes a deep copy, no shared data left */
	integer& integer::operator = (const integer &rhs)
	{
		impl=rhs.impl;
		return *this;
	} // Overload =
	
	// Arithmetic operators '+', '-', '*', '/', '%', '^'
	integer integer::operator + (const integer &rhs) const
	{ 
	integer temp(impl+rhs.impl);
	return temp;
	} // Overload binary +
	
	integer integer::operator - (const integer &rhs) const
	{  
	integer temp(impl-rhs.impl);
	return temp;
	} // Overload binary -
	
	integer integer::operator * (const integer &rhs) const
	{
	integer temp(impl*rhs.impl);
	return temp;
	} // Overload *
	
	integer integer::operator / (const integer &rhs) const throw (DivisionByZeroException)
	{ 
	integer temp(impl/rhs.impl);
	return temp;
	} // Overload /
	
	integer integer::operator % (const integer &rhs) const
	{
	integer temp(impl%rhs.impl);
	return temp;
	} // Overload %
	
	integer integer:: operator ^ (const integer &rhs) const
	{
	integer temp(impl^rhs.impl);
	return temp;
	} // Overload ^
	
	// Arithmetic assignment operators '+=', '-=', '*=', '/='
	/* these all make calls to above implementations, study idea of *
	* reimplementing for efficiency                                */
	
	integer& integer::operator += (const integer &rhs)
	{
	(*this)=(*this) + rhs;
	return *this;
	} // Overload +=
	
	integer& integer::operator -= (const integer &rhs)
	{  
	(*this)=(*this) - rhs;  
	return *this;   
	} // Overload -=
	
	integer& integer::operator *= (const integer &rhs)
	{
	(*this)=(*this) * rhs;
	return *this;   
	} // Overload *=
	
	integer& integer::operator /= (const integer &rhs) throw (DivisionByZeroException)
	{
	(*this)=(*this) / rhs;
	return *this;   
	} // Overload /=
	
	// Unary operators '+', '-'
	
	integer integer::operator + () const
	{
	return (*this);
	} // Overload unary +
	
	integer integer::operator - () const
	{
	return (*this).neg();
	} // Overload unary -
	
	// Increment/decrement operators '++', '--'
	integer& integer::operator ++()
	{
	integer one(1);
	(*this)=(*this) + one;
	return (*this);
	} // Overload prefix ++
	
	integer& integer::operator ++(int)
	{
	integer * temp=new integer(impl);
	integer one(1);
	(*this)=(*this) + one;
	return *temp;
	} // Overload postfix ++
	
	integer& integer::operator --()
	{
	integer one(1);
	(*this)=(*this) - one;
	return (*this);
	} // Overload prefix ++
	
	integer& integer::operator --(int)
	{
	integer * temp=new integer(impl);
	integer one(1);
	(*this)=(*this) - one;
	return *temp;
	} // Overload postfix ++
	
	// Comparison operators
	/* Basic idea of comparison operators is to find first distinction *
	* between operands and analyze the distinction to determine the   *
	* what result it should yield                                     */
	bool integer::operator ==(const integer &rhs) const
	{
	return (impl==rhs.impl);
	} // Overload ==
	
	bool integer::operator !=(const integer &rhs) const
	{
	return (impl!=rhs.impl);
	} // Overload !=
	
	bool integer::operator >(const integer &rhs) const
	{
	return (impl>rhs.impl);
	} // Overload >
	
	bool integer::operator <(const integer &rhs) const
	{
	return (impl<rhs.impl);
	} // Overload <
	
	bool integer::operator >=(const integer &rhs) const
	{
	return (impl>=rhs.impl);
	} // Overload >=
	
	bool integer::operator <=(const integer &rhs) const
	{
	return (impl<=rhs.impl);} // Overload <=
	
	// Stream input/output operators
	/* currently there is a problem, semantics for input need to be studied */
	istream& operator >> (istream &istr, integer &rhs)
	{
	return istr >> rhs.impl;
	} // Overload >>
	
	/*overloaded output op just makes call to recursive function and adds the sign */
	ostream& operator << (ostream &ostr, const integer &rhs)
	{
		ostr << rhs.impl;
		return ostr;
	} // Overload <<
	
	// Other functions
	integer integer::gcd(const integer &rhs) const
	{  
		integer temp(impl.gcd(rhs.impl));
		return temp;
	} // function gcd (greatest common divisor)
	
	integer integer::lcm(const integer &rhs) const
	{ // Needs to be implemented
		return *this;
	} // least common multiple
	
	integer integer::abs() const
	{
		integer temp(impl.abs());
		return temp;
	} // function abs (absolute value)
	
	integer integer::neg() const
	{
		integer temp(impl.neg());
		return temp;
	} // function neg (negate value)
	
	uint integer::serialize(unsigned char* data) const
	{
		return impl.serialize(data);
	}
	
	uint integer::serialSize() const //returns number of bytes this object takes when serialized
	{
		return impl.serialSize();
	}

	unsigned long integer::asULong() const{ return impl.asULong();}

}
