/*
g++ -ggdb test.cpp OraclemSlob.cpp imSlobstream.cpp SequenceIndex.cpp -locci -lclntsh -L /usr/lib/oracle/10.2.0.1/client/lib -I /usr/include/oracle/10.2.0.1/client/ -o mmmm
*/

#include <iostream>
#include "mSlob.h"
#include <oci.h>
#include <stdexcept>

using namespace std;
//using namespace oracle::occi;
typedef struct OCILobWrapper{
	OCILobLocator* lob;
	OCISvcCtx*	cntxt;
	OCIError* errhp;
} OCILobWrapper;

static text *username = (text *) "apauly";
static text *password = (text *) "testis";
static text *seloci = (text *)"SELECT age FROM ocitest where id=4";

static OCIEnv *envhp;
static OCIError *errhp;
static sword status;



static void checkerr(OCIError *errhp, sword status)
{
	text errbuf[512];
	ub4 buflen;
	sb4 errcode;
	string er;
	
	if (status == OCI_SUCCESS) return;

	switch (status)
	{
		case OCI_SUCCESS_WITH_INFO:
			cout << "Error - OCI_SUCCESS_WITH_INFO" << endl;
			OCIErrorGet ((dvoid *) errhp, (ub4) 1, (text *) NULL, &errcode,
						  errbuf, (ub4) sizeof(errbuf), (ub4) OCI_HTYPE_ERROR);
			er=(char*)errbuf;
			cout << "Error -" << er << endl;
			break;
		case OCI_NEED_DATA:
			cout << "Error - OCI_NEED_DATA" << endl;
			break;
		case OCI_NO_DATA:
			cout << "Error - OCI_NO_DATA" << endl;
			break;
		case OCI_ERROR:
			OCIErrorGet ((dvoid *) errhp, (ub4) 1, (text *) NULL, &errcode,
						  errbuf, (ub4) sizeof(errbuf), (ub4) OCI_HTYPE_ERROR);
			er=(char*)errbuf;
			cout << "Error -" << er << endl;
			break;
		case OCI_INVALID_HANDLE:
			cout << "Error - OCI_INVALID_HANDLE" << endl;
			break;
		case OCI_STILL_EXECUTING:
			cout << "Error - OCI_STILL_EXECUTING" << endl;
			break;
		case OCI_CONTINUE:
			cout << "Error - OCI_CONTINUE" << endl;
			break;
		default:
			cout << "Error - " << status << endl;
			break;
	}
}

int main(int argc, char* argv[])
{
	Locator slobby,daddy;
	OCILobLocator *mylob;
	uint myid;
	
	cout << "Test: " << sizeof(uint) << endl;
	
	OCISession *authp = (OCISession *) 0;
	OCIServer *srvhp;
	OCISvcCtx *svchp;
	OCIStmt	*stmthp;
	OCIDefine *defnp = (OCIDefine *) 0;
	OCIDefine *defnp2 = (OCIDefine *) 0;
	
	//create environment and 	//allocate handles and data structures
	(void) OCIInitialize((ub4) OCI_DEFAULT, (dvoid *)0,
	(dvoid * (*)(dvoid *, size_t)) 0,
	(dvoid * (*)(dvoid *, dvoid *, size_t))0,
	(void (*)(dvoid *, dvoid *)) 0 );

	(void) OCIEnvInit( (OCIEnv **) &envhp, OCI_DEFAULT, (size_t) 0,
	(dvoid **) 0 );

	(void) OCIHandleAlloc( (dvoid *) envhp, (dvoid **) &errhp, OCI_HTYPE_ERROR,
	(size_t) 0, (dvoid **) 0);

	/* server contexts */
	(void) OCIHandleAlloc( (dvoid *) envhp, (dvoid **) &srvhp, OCI_HTYPE_SERVER,
	(size_t) 0, (dvoid **) 0);

	(void) OCIHandleAlloc( (dvoid *) envhp, (dvoid **) &svchp, OCI_HTYPE_SVCCTX,
	(size_t) 0, (dvoid **) 0);

	(void) OCIServerAttach( srvhp, errhp, (text *)"berlin.dbcenter.cise.ufl.edu:1521/orastu1", strlen("berlin.dbcenter.cise.ufl.edu:1521/orastu1"), 0);

	/* set attribute server context in the service context */
	(void) OCIAttrSet( (dvoid *) svchp, OCI_HTYPE_SVCCTX, (dvoid *)srvhp,
	(ub4) 0, OCI_ATTR_SERVER, (OCIError *) errhp);

	(void) OCIHandleAlloc((dvoid *) envhp, (dvoid **)&authp,
	(ub4) OCI_HTYPE_SESSION, (size_t) 0, (dvoid **) 0);

	(void) OCIAttrSet((dvoid *) authp, (ub4) OCI_HTYPE_SESSION,
	(dvoid *) username, (ub4) strlen((char *)username),
	(ub4) OCI_ATTR_USERNAME, errhp);

	(void) OCIAttrSet((dvoid *) authp, (ub4) OCI_HTYPE_SESSION,
	(dvoid *) password, (ub4) strlen((char *)password),
	(ub4) OCI_ATTR_PASSWORD, errhp);

	//connect to server and being session
	checkerr(errhp, OCISessionBegin ( svchp,  errhp, authp, OCI_CRED_RDBMS,
			 (ub4) OCI_DEFAULT));

	(void) OCIAttrSet((dvoid *) svchp, (ub4) OCI_HTYPE_SVCCTX,
	(dvoid *) authp, (ub4) 0,
	(ub4) OCI_ATTR_SESSION, errhp);

	checkerr(errhp, OCIHandleAlloc( (dvoid *) envhp, (dvoid **) &stmthp,
			 OCI_HTYPE_STMT, (size_t) 0, (dvoid **) 0));

	//allocate lob descriptor
	if (OCIDescriptorAlloc((dvoid *) envhp, (dvoid **) &mylob,
		(ub4)OCI_DTYPE_LOB, (size_t) 0, (dvoid **) 0))
	{
		cout << "FAILED: OCIDescriptorAlloc()" << endl;
		return OCI_ERROR;
	}
	
	//issue SQL and process data
	checkerr(errhp, OCIStmtPrepare(stmthp, errhp, (text *)"SELECT id, data FROM slobber where id=777 FOR UPDATE",
			 (ub4)strlen("SELECT id, data FROM slobber where id=777 FOR UPDATE"),
			 (ub4) OCI_NTV_SYNTAX, (ub4) OCI_DEFAULT));	
	
	
	checkerr(errhp, OCIDefineByPos(stmthp, &defnp, errhp, 1, (dvoid *) &myid,
			 (sword) sizeof(int), SQLT_INT, (dvoid *) 0, (ub2 *)0,
			 (ub2 *)0, OCI_DEFAULT));

	
	checkerr(errhp, OCIDefineByPos(stmthp, &defnp2, errhp, (ub4) 2,
				   (dvoid *) &mylob, (sb4) -1, (ub2) SQLT_BLOB,
				   (dvoid *) 0, (ub2 *) 0, (ub2 *) 0, (ub4) OCI_DEFAULT));
			
			
	/* execute and fetch */
	if (status = OCIStmtExecute(svchp, stmthp, errhp, (ub4) 1, (ub4) 0,
		(CONST OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT))
	{
		if (status == OCI_NO_DATA)
			cout << "No data returned!" << endl;
		else
		{
			checkerr(errhp, status);
			if (envhp)
				(void) OCIHandleFree((dvoid *) envhp, OCI_HTYPE_ENV);
			return OCI_ERROR;
		}
	}else
		cout << "The id is: " << myid << endl;	

		if (status==OCI_SUCCESS || status==OCI_SUCCESS_WITH_INFO)
		{
			
			ub4 loblen = 0;
			cout << "Retrieved tuple with ID: " << myid << endl;
			(void) OCILobGetLength(svchp, errhp, mylob, &loblen);
			cout << "Size of Blob: " << loblen << endl;
			
			checkerr(errhp,OCILobTrim2(svchp,errhp,mylob,0));
			cout << "Set to Empty!" << endl;
			(void) OCILobGetLength(svchp, errhp, mylob, &loblen);
			cout << "Size of Blob again: " << loblen << endl;
			
			OCILobWrapper *blob1=new OCILobWrapper;
			blob1->lob=mylob;
			blob1->cntxt=svchp;
			blob1->errhp=errhp;
			
			(void) OCILobGetLength(blob1->cntxt, blob1->errhp, blob1->lob, &loblen);
			cout << "Size of Blob again and again: " << loblen << endl;
			
			unsigned char buffer[3];
			
			//"THE CAT IN THE HAT";
			cout << "Will build mSLOB" << endl;
			mSlob p(blob1);
			cout << "mSLOB Built" << endl;
			
			p.beginBatch();
			
			daddy=p.locateGlobal();
			slobby=p.locate(daddy,0);
			
			//uint struc=p.addStruct(slobby); //added new structure
			Locator pinga=slobby.insert(1); //add secondary struct
		
/*			Locator pinga(p.locate(slobby,struc));*/
			pinga.debug();
			cout << "Added Struct" << endl;

			Locator l(p.locate(slobby,0)); //retrieve primary struct
			cout << "Located!" << endl;
			l.debug();
			cout << "Sentence: "; 
			Locator sent=p.insert(l,0); //insert empty "sentence object"
			sent.debug();
			buffer[0] = 'T';
			buffer[1] = 'H';
			buffer[2] = 'E';
			cout << "The: "; 
			(p.insert(buffer,3,sent,0)).debug();
			
			buffer[0] = 'C';
			buffer[1] = 'A';
			buffer[2] = 'T';
			cout << "Cat: "; 
			(p.insert(buffer,3,sent,1)).debug();
				
			buffer[0] = 'I';
			buffer[1] = 'N';
			cout << "In: "; 
			(p.insert(buffer,2,sent,2)).debug();
			
			buffer[0] = 'T';
			buffer[1] = 'H';
			buffer[2] = 'E';
			cout << "The2: "; 
			(p.insert(buffer,3,sent,3)).debug();
			
			buffer[0] = 'H';
			buffer[1] = 'A';
			buffer[2] = 'T';
			cout << "Hat: "; 
			(p.insert(buffer,3,sent,4)).debug();

			unsigned char buffer3[]="el gatos";
			
//			l=p.locatemSlob();
			cout << "Located2!" << endl;
			l.debug();
			cout << "el gatos: "; 
			(p.insert(buffer3,8,l,1)).debug();

			unsigned char buffer2[]="IN FRENCH CHAT DANS CHAPEAU";
			
//			l=p.locatemSlob();
			cout << "Located3!" << endl;
			l.debug();
			cout << "Frenchen: "; 
			(p.insert(buffer2,27,l,2)).debug();
			
			cout << "CHECKING LOCATORS" << endl;
			l=p.locate(slobby,0);			
			cout << "PARENT: ";
			l.debug();

			cout << "Child1: ";
			(p.locate(l,0)).debug();
			cout << "Child2: ";
			(p.locate(l,1)).debug();
			cout << "Child3: ";
			(p.locate(l,2)).debug();
 
			p.commitBatch();
			cout << "DONE INSERTING!, now READ" << endl;
			
			l.debug();

			imSlobstream reader=p.getStream(l);
			
			//get( char* const c, const  uint size, uint & numBytesRead, bool & EndOfObj );
			unsigned char bufferr[10];
			uint nread=1;
			uint ccc=0;
			while (nread!=0)
			{
				ccc++;
				reader.read(bufferr,10,nread);
				if (ccc==7) break;
				for (uint k=0; k<nread; k++)
					cout << bufferr[k];
				cout << endl;
			}
		
			cout << "Done Reading 1" << endl;
	
			cout << "Will try Struct handling" <<endl;

			Locator newstr=p.locate(slobby,1);
			newstr.debug();

			Locator eng=p.locate(l,0);
			Locator french=p.locate(l,2);
			Locator spa=p.locate(l,1);
	
			
			cout << "Will insert into secondary" << endl;

			p.beginBatch();
			(p.insert(french,newstr,0)).debug();
			cout << "Inserted french, new count:" << newstr.getElements() << endl;
			(p.insert(eng,newstr,1)).debug();
			cout << "Inserted eng, new count:" << newstr.getElements() << endl;
			Locator spal=p.insert(spa,newstr,2);
			spal.debug();
			cout << "Inserted spa, new count:" << newstr.getElements() << endl;
			p.commitBatch();
			cout << "will read again" << endl;
	
			//p2->strongRemove(l,2);
			
			newstr=p.locate(slobby,1);
			Locator french2=p.locate(newstr,0);
			
			imSlobstream reader2=p.getStream(french2);
			
			//get( char* const c, const  uint size, uint & numBytesRead, bool & EndOfObj );
			nread=1;
			ccc=0;
			while (nread!=0)
			{
				ccc++;
				reader2.read(bufferr,10,nread);
				if (ccc==7) exit(1);
				for (uint k=0; k<nread; k++)
					cout << bufferr[k];
				cout << endl;
			}
	
			
			OCILobClose(svchp, errhp, mylob);
			if (envhp)
				(void) OCIHandleFree((dvoid *) envhp, OCI_HTYPE_ENV);
		}else{	
			text errbuf[512];
			ub4 buflen;
			sb4 errcode;
			
			OCIErrorGet (errhp, (ub4) 1, (text *) NULL, &errcode,
						 errbuf, (ub4) sizeof(errbuf), (ub4) OCI_HTYPE_ERROR);
		
			string er=(char*)errbuf;
			cout << "Error: " << er << endl;
			throw runtime_error("Unable to retrieve tuple.");
		}
		
	
//	catch (SQLException ea)
//	{
//		cout << ea.what();
//		}
	//Environment::terminateEnvironment (env);
}
