#include "orphanedLocatorList.h"

orphanedLocatorList::orphanedLocatorList( )
{	}

orphanedLocatorList::~orphanedLocatorList( )
{

}

orphanedLocatorList& orphanedLocatorList::operator=( orphanedLocatorList& RHS )
{
	orphans.clear( );
	for( uint i = 0; i < RHS.orphans.size( ); i++ )
	{
		orphans.push_back( RHS.orphans[i] );
	}
	return *this;
}

void orphanedLocatorList::insertOrphan( LocatorNode * newNode )
{
	bool inserted = false;
	vector<LocatorNode*>::iterator spot = orphans.begin( );
	
	if( isInOrphanList( newNode ) )
	{
		throw runtime_error( "Locator already exists in orphaned list, cannot insert it again\n" );
	}
	
	for( uint i = 0; i < orphans.size( ); i++ )
	{
		if( *newNode > *orphans[i] )
		{
			spot += i;
			orphans.insert( spot, newNode );
			inserted = true;
			break;
		}
	}
	
	// if it is the last item in the list, then insert it there
	if( !inserted )
	{
		orphans.push_back( newNode );
	}
}

void orphanedLocatorList::removeOrphan( LocatorNode * delNode)
{
	bool removed = false;
	vector<LocatorNode*>::iterator item = orphans.begin( );
	
	if( !isInOrphanList( delNode ) )
	{
		throw runtime_error( "Locator does not exist in orphaned list, cannot be removed\n" );
	}
	
	for( uint i = 0; i < orphans.size( ); i++ )
	{
		if( *delNode == *orphans[i] )
		{
			item += i;
			orphans.erase( item );
			removed = true;
			break;
		}
	}
	
	if( !removed )
	{
		throw runtime_error( "Error: did not remove locator from orphaned list\n" );
	}
}

bool orphanedLocatorList::isInOrphanList( LocatorNode * checkNode, LocatorNode *& nodeInList )
{
	for( uint i = 0; i < orphans.size( ); i++ )
	{
		if( *checkNode == *orphans[i] )
		{
			nodeInList = orphans[i];
			return true;
		}
	}
	return false;
}

bool orphanedLocatorList::isInOrphanList( LocatorNode * checkNode )
{
	for( uint i = 0; i < orphans.size( ); i++ )
	{
		if( *checkNode == *orphans[i] )
		{
			return true;
		}
	}
	return false;
}

