#ifndef MEMSLOB_H
#define MEMSLOB_H

#include "SequenceIndex.h"
#include "imSlobstream.h"
#include "Locator.h"
#include "stuVector.h"
#include "mSlob.h"
#include "constants.h"


using namespace std;
using namespace stu;

//const uint ADDRESS_SIZE=4; //already defined in SequenceIndex.h
	
class Locator;
class imSlobstream;
class mSlob;

class node{
	public:
		node* prev; //pointer to the previous element
		node* next; //pointer to the next element
		node* parent; //pointer to parent. needed by struct to access their "sister" structs
		void* data; //children in general, could be raw data of type unsigned char*(BASE_LEVEL) or stuVector*(OBJECT_LEVEL) or node*(otherwise)
		uint len; //how many subobjects are there? or what's the size of this base object
/*		bool isRef; //if true, then data is a pointer to the node this references
		bool isBase; //is this a base object? if false, then data is actually a pointer to node (the children)*/
		int  objectType; //what struct does this belong to?
		bool isHead; //used for head of structs

		node();
		~node();
};

class memSlob{
	friend class imSlobstream;
	friend class mSlob;
	friend class Locator;
	friend class LocatorNode;
	
	public:

		
		//Constructors & destructor
		memSlob(); /**< Initializes necessary structures to default values */
		memSlob(mSlob* ms); 
		memSlob(const memSlob& s); //copy constructor
		~memSlob();/**< Default destructor, releases all references*/

		//Structure manipulation
		
		//Data manipulation
// 		Locator locateGlobal(); //provides locator to entire memSLOB, basically "mslobs" element

		Locator locate(const Locator& loc, uint idx); //locate object at loc level. loc also refers to a specific virtual SLOB
		
		imSlobstream getStream(Locator& l); //get stream at level of hierachy of object at l, streams cannot be retrieved for entire mslobs...only for individual structs
		
		Locator insert(unsigned char data[], uint size, Locator& loc, uint idx); //insert object at position idx of object loc, returns locator to inserted base object
		
		Locator insert(Locator& loc, uint idx, int oType=OBJECT_LEVEL); //insert empty object into position idx of loc. non-base object inserter, Loc could be the main locator, in which case a new mslob is being added
		
		Locator insert(const Locator& loc1, Locator& loc2, uint idx); //insert object in loc1 into spot idx of loc2, returns locator to inserted object

		bool weakRemove(Locator& loc, uint idx); //remove reference to object idx at level loc, update loc's offset count
		
		bool strongRemove(Locator& loc, uint idx); //remove whole object and all its links

		Locator append(unsigned char data[], uint size, Locator& loc); //append object as subobject of object loc

		uint length(const Locator& loc); //size of object at loc, in bytes
		
		uint count(const Locator& loc); //number of subobjects of loc
		
		uint  fragmentation(); //always 0 for memSlobs
		
		//Restructuring data
		void resequence();
		void resequence( const Locator& loc );
		
		//"batch" handling methods to somewhat increase performance and reduce fragmentation, here provided just for compatibility
		bool beginBatch();
		bool commitBatch();
		
		
	private:
		//stuVector<node*> structs;
		
		/*every mSlob has at least root, with objectType==COLLECTION_TYPE*/
		node* root; 
		uint elements; //number of objects at top level
// 		Locator *global;
		mSlob *myslob; //keep a pointer for various needs, specially useful when instantiating Locators
		
		Locator locateRef(const Locator& loc, uint idx);
		Locator DeReference(const Locator& loc);
		void removeReferences(Locator p, Locator lst);
		uint recLength(node* p) const;
};
#endif


/*
Notes on memSlob handling:

1. Count of subobjects in object is located after "end" of object.
2. When looking for data values: first look on "start" values of sequence index, then if the address is within a range. Last, look at value being at the end of a range which would mean it was substituted.
3. The start of the first (sub)object,is computed differently from the rest because there is no "previous" offset to compute it so it is computed by: start of object + (count * offset_size)L
4. Steps to create a Locator, where S is the start of the parent object P, E is the end, C is the count and idx is the index of the object to locate within P:
		
		NOTE: value: address x length -> byte[]
		
		a) start=value(START + (idx*ADDRESS_SIZE)L, ADDRESS_SIZE);
		b) end=value(START + ((idx+1)*ADDRESS_SIZE)L, ADDRESS_SIZE);
		c) count=value(end, (ADDRESS_SIZE)L)


*/

